/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.system.scorecard;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.j2html.portal.producer.common.ProducerUtils;
import com.cognos.admin.portal.producer.process.common.MetricsUtils;
import com.cognos.admin.portal.producer.process.system.scorecard.RelationshipsView;
import com.cognos.admin.resource.v1_0.ResourceLookupManager;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.xts.ext.XTSExt;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GetData
extends Stage {
    public GetData(ServiceLogger logger) {
        super(logger);
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        try {
            if (RelationshipsView.isActiveView(context)) {
                String sResourceID = XTSExt.xmlencode((String)XTSExt.urldecode((String)ProducerUtils.getParameter((StageContext)context, (String[])new String[]{"relationshipResourceID"}, (String)ResourceLookupManager.getInstance().getRootResourceId(context))));
                String sRelationshipType = ProducerUtils.getParameter((StageContext)context, (String[])new String[]{"selectedRelationshipType", "relationshipType", "rootRelationshipType", "defaultRelationshipType"}, (String)"servers");
                context.getStateParams().setParameter("resourceID", sResourceID);
                context.getStateParams().setParameter("relationshipType", sRelationshipType);
                Reader values = this.getValues(context, sResourceID, sRelationshipType);
                MetricsUtils.createResponse(context, "scorecardDataResponse", values);
            }
        }
        catch (PipelineException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Reader getValues(StageContext context, String sResourceID, String sRelationshipType) throws PipelineException {
        StringBuffer sPropertyList = new StringBuffer();
        XMLStreamReader staxReader = context.getInputAsXMLStreamReader("propertyList");
        if (staxReader != null) {
            try {
                StaxUtils.moveToElement((String)"propertyList", (XMLStreamReader)staxReader);
                PathIterator iter = new PathIterator(staxReader, new String[]{"/propertyList/ResourceProperty", "/propertyList/ResourceGroup/ResourceProperty"});
                while (iter.moveToNextPath() != -1) {
                    StaxUtils.toString((XMLStreamReader)iter, (StringBuffer)sPropertyList);
                }
            }
            catch (XMLStreamException e) {
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        StringReader body = new StringReader(new StringBuffer("<SOAP-ENV:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header>").append(context.getBusHeader()).append("<nemo:cogadminHeader xmlns:nemo=\"http://developer.cognos.com/nemo\">").append("<nemo:ResourceIdentifier>").append(sResourceID).append("</nemo:ResourceIdentifier>").append("</nemo:cogadminHeader></SOAP-ENV:Header><SOAP-ENV:Body>").append("<admin:CogQueryRelationshipsByType xmlns:admin=\"http://developer.cognos.com/admin/properties\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><admin:RequestedType>").append(sRelationshipType).append("</admin:RequestedType>").append(sPropertyList).append("</admin:CogQueryRelationshipsByType></SOAP-ENV:Body></SOAP-ENV:Envelope>").toString());
        return MetricsUtils.cogQueryRelationshipsByType(body);
    }

    public boolean canShare() {
        return false;
    }
}

