/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.system.scorecard;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.portal.producer.process.common.MetricsUtils;
import com.cognos.admin.portal.producer.process.system.scorecard.RelationshipsView;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.Stage;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputImpl;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class GetMetadata
extends Stage {
    public GetMetadata(ServiceLogger logger) {
        super(logger);
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        try {
            if (RelationshipsView.isActiveView(context)) {
                PipelineOutputImpl output = new PipelineOutputImpl();
                XMLStreamWriter staxWriter = output.getXMLStreamWriter();
                staxWriter.writeStartElement("metadataResponse");
                Iterator iter = this.getResourceIds(context).iterator();
                while (iter.hasNext()) {
                    Reader metadata = MetricsUtils.getProperty(context, (String)iter.next(), "MetadataDescriptor");
                    XMLStreamReader staxReader = XMLStreamFactory.createXMLStreamReader((Reader)metadata);
                    StaxUtils.copyCurrentElement((XMLStreamReader)staxReader, (XMLStreamWriter)staxWriter);
                }
                staxWriter.writeEndElement();
                context.addOutput("scorecardMetadataResponse", (IPipelineOutput)output);
            }
        }
        catch (PipelineException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (XMLStreamException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private List getResourceIds(StageContext context) throws PipelineException, XMLStreamException {
        XMLStreamReader staxReader = context.getInputAsXMLStreamReader("scorecardDataResponse");
        ArrayList<String> resourceIds = new ArrayList<String>(20);
        PathIterator iter = new PathIterator(staxReader, new String[]{"/CogQueryRelationshipsByTypeResponse/Relationship/Participant/ResourceId"});
        while (iter.moveToNextPath() != -1) {
            resourceIds.add(iter.getElementText());
        }
        return resourceIds;
    }

    public boolean canShare() {
        return false;
    }
}

