/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.system.scorecard;

import com.cognos.admin.common.ResourceIdFactory;
import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IMessagesManager;
import com.cognos.admin.j2html.format.DateTimeFormatter;
import com.cognos.admin.j2html.format.PercentageFormatter;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.admin.j2html.table.TableColumnModel;
import com.cognos.admin.portal.common.messages.MessagesManagerFacade;
import com.cognos.admin.portal.components.system.Resource;
import com.cognos.admin.portal.components.system.ResourceTableModel;
import com.cognos.admin.portal.components.system.scorecard.ScorecardComponent;
import com.cognos.admin.portal.producer.process.system.datastores.DatastoresResourceTableModel;
import com.cognos.admin.portal.producer.process.system.scorecard.AbstractScorecardView;
import com.cognos.admin.resource.v1_0.intf.IResourceID;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.PathIterator;
import com.cognos.xts.ext.XTSDuration;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RelationshipsView
extends AbstractScorecardView {
    private static final String ROOT_PROPERTYLIST = "/propertyList/ResourceProperty";
    private static final String ROOT_METADATARESPONSE = "/metadataResponse/GetMultipleResourcePropertiesResponse/MetadataDescriptor";
    private static final String ROOT_METRICSRESPONSE = "/CogQueryRelationshipsByTypeResponse/Relationship/Participant";
    private static final String TABLE_CELL_RENDERER_CLASS_KEY = "iTableCellRenderer";
    protected HashMap propertyRenderers = null;
    private ModelMap metaDataByResourceType = null;

    public RelationshipsView(ServiceLogger logger) {
        super(logger);
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        block19: {
            super.executeImpl(context);
            try {
                ProducerContext producerContext = new ProducerContext(context, (IMessagesManager)new MessagesManagerFacade());
                if (RelationshipsView.isMenuView(context)) {
                    ScorecardComponent scorecardComponent = new ScorecardComponent((IContext)producerContext, null, true, false);
                    producerContext.render((ControlledComponent)scorecardComponent);
                    break block19;
                }
                if (!RelationshipsView.isActiveView(context)) break block19;
                this.context = context;
                context.getFragment().setPreferredTitle(producerContext.localize("IDS_ADM_TOP_SYSTEM"));
                this.metaDataByResourceType = this.getMetadataByResourceType(context);
                ArrayList relationshipsResponse = this.getRelationshipsResponse(context, null);
                ResourceTableModel model = "ds".equals(context.getEnv().getParameter("application")) ? new DatastoresResourceTableModel((IContext)producerContext, relationshipsResponse.size()) : new ResourceTableModel((IContext)producerContext, relationshipsResponse.size());
                model.setSummary(producerContext.localize("IDS_ADM_TOP_SYSTEM"));
                TableColumnModel columnModel = model.getTableColumnModel();
                int row = 0;
                ArrayList metricProperties = RelationshipsView.isMaximized(context) ? this.getMetricPropertyNames(context) : null;
                for (ModelMap resourceTypeAttrs : relationshipsResponse) {
                    String encodedResourceType = (String)resourceTypeAttrs.get("Role");
                    String resourceType = encodedResourceType.replaceFirst("cogadmin:role:", "");
                    ModelMap resourceTypeMetaData = this.metaDataByResourceType.getMap(resourceType);
                    if (resourceTypeMetaData != null) {
                        Resource resource = new Resource();
                        resource.enableActions(true);
                        String resId = resourceTypeAttrs.getValue("ResourceId");
                        resource.setResourceId(resId);
                        resource.setObjectClass(resourceTypeAttrs.getValue("ObjectClass"));
                        resource.setIconPath("/ps/" + resourceTypeAttrs.getValue("Icon"));
                        resource.setIconTooltip(resourceTypeAttrs.getValue("IconTooltip"));
                        resource.setAncestors(resourceTypeAttrs.getValue("Ancestors"));
                        resource.setHidden(Boolean.valueOf(resourceTypeAttrs.getValue("Hidden")));
                        resource.setHealth(resourceTypeAttrs.getValue("Health"));
                        resource.setOperationalStatus(resourceTypeAttrs.getValue("OperationalStatus"));
                        resource.setName(resourceTypeAttrs.getValue("Caption"));
                        resource.setTenantID(resourceTypeAttrs.getValue("TenantID"));
                        try {
                            IResourceID resIdObj = ResourceIdFactory.getResourceID((String)resource.getResourceId(false));
                            if (resIdObj.getSystem().equals("ds") && resIdObj.getBaseType().equals("queryService")) {
                                String[] tokens = resource.getAncestors().split(" > ");
                                resource.setDetailedName(resource.getName() + " - " + tokens[tokens.length - 1]);
                            } else {
                                resource.setDetailedName(resource.getName());
                            }
                        }
                        catch (BaseFaultType e) {
                            CogAdminLogger.getInstance().error("Unable to set detailed name for resource. " + resource.getResourceId(false));
                        }
                        String[] type = resourceTypeAttrs.getValue("Role").split(":");
                        resource.setType(type[type.length - 1]);
                        if (resource.getType().equals("system")) {
                            resource.setStoreId(resourceTypeAttrs.getValue("StoreID"));
                            resource.setTenantID(resourceTypeAttrs.getValue("TenantID"));
                        }
                        boolean hasChildren = Boolean.valueOf(resourceTypeAttrs.getValue("HasChildren"));
                        resource.setHasChildren(hasChildren);
                        resource.setCanNavigate(hasChildren);
                        model.setResourceAt(resource, row);
                        if (RelationshipsView.isMaximized(context)) {
                            try {
                                this.addSummaryMetrics((IContext)producerContext, resourceType, model, row, columnModel, resourceTypeAttrs, metricProperties);
                            }
                            catch (DatatypeConfigurationException e) {
                                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        ++row;
                        continue;
                    }
                    CogAdminLogger.getInstance().warn("No metadata for resourceType: " + resourceType + ". Skipping...");
                    model.setRowCount(model.getRowCount() - 1);
                }
                ScorecardComponent scorecardComponent = new ScorecardComponent((IContext)producerContext, model, true, this.canSelectRow());
                producerContext.render((ControlledComponent)scorecardComponent);
            }
            catch (NumberFormatException e) {
                CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (LocalizableException e) {
                CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (XMLStreamException e) {
                CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (J2HTMLException e) {
                CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (ParseException e) {
                CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (BaseFaultType e) {
                CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
                throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static boolean isBuildSiblingMenu(StageContext context) {
        return "true".equals(context.getEnv().getParameter("buildSiblingMenu"));
    }

    private ArrayList getMetricPropertyNames(StageContext context) throws PipelineException, XMLStreamException {
        XMLStreamReader staxPropertyListReader = context.getInputAsXMLStreamReader("propertyList");
        ArrayList<String> propertyNames = new ArrayList<String>();
        PathIterator iter = new PathIterator(staxPropertyListReader, new String[]{ROOT_PROPERTYLIST});
        block0: while (iter.moveToNextPath() >= 0) {
            String renderer = iter.getAttributeValue("", TABLE_CELL_RENDERER_CLASS_KEY);
            String propName = iter.getElementText();
            for (ModelMap resourceTypeAttrs : this.getRelationshipsResponse(context, null)) {
                ModelMap propertyMetaData;
                String encodedResourceType = resourceTypeAttrs.get("Role").toString();
                String resourceType = encodedResourceType.replaceFirst("cogadmin:role:", "");
                ModelMap resourceTypeMetaData = this.metaDataByResourceType.getMap(resourceType);
                if (resourceTypeMetaData == null || (propertyMetaData = resourceTypeMetaData.getMap("Property").getMap(propName)) == null) continue;
                propertyNames.add(propName);
                if (renderer == null) continue block0;
                if (this.propertyRenderers == null) {
                    this.propertyRenderers = new HashMap();
                }
                this.propertyRenderers.put(propName, renderer);
                continue block0;
            }
        }
        return propertyNames;
    }

    private ModelMap getMetadataByResourceType(StageContext context) throws PipelineException, XMLStreamException {
        int index;
        XMLStreamReader staxMetadataResponseReader = context.getInputAsXMLStreamReader("scorecardMetadataResponse");
        PathIterator iter = new PathIterator(staxMetadataResponseReader, new String[]{"/metadataResponse/GetMultipleResourcePropertiesResponse/MetadataDescriptor/Name", "/metadataResponse/GetMultipleResourcePropertiesResponse/MetadataDescriptor/PropertiesGroups/PropertiesGroup", "/metadataResponse/GetMultipleResourcePropertiesResponse/MetadataDescriptor/Property", "/metadataResponse/GetMultipleResourcePropertiesResponse/MetadataDescriptor/Action"});
        ModelMap resourceTypes = new ModelMap();
        ModelMap resourceAttributes = null;
        block3: while ((index = iter.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    String resourceTypeName = iter.getElementText().split("MetadataDescriptor")[0];
                    resourceAttributes = new ModelMap();
                    resourceTypes.put(resourceTypeName, resourceAttributes);
                    continue block3;
                }
            }
            this.processResourceAttributes((XMLStreamReader)iter, resourceAttributes, null);
        }
        return resourceTypes;
    }

    private void processResourceAttributes(XMLStreamReader iter, ModelMap resourceAttributes, ArrayList filter) throws PipelineException, XMLStreamException {
        String name;
        ModelMap propTypes;
        String resourceAttributeType = iter.getLocalName();
        ModelMap props = resourceAttributes.getMap(resourceAttributeType);
        if (props == null) {
            props = new ModelMap();
            resourceAttributes.put(resourceAttributeType, props);
        }
        if ((propTypes = this.createModelMapWithLeafElements(iter)) != null && (name = (String)propTypes.get("Name")) != null) {
            props.put(name, propTypes);
        }
    }

    private ArrayList getRelationshipsResponse(StageContext context, ArrayList propertyNames) throws PipelineException, XMLStreamException {
        XMLStreamReader staxPropertyListReader = context.getInputAsXMLStreamReader("scorecardDataResponse");
        ArrayList<ModelMap> resource = new ArrayList<ModelMap>();
        PathIterator iter = new PathIterator(staxPropertyListReader, new String[]{ROOT_METRICSRESPONSE});
        while (iter.moveToNextPath() != -1) {
            ModelMap ret = this.createModelMapWithLeafElements((XMLStreamReader)iter);
            resource.add(ret);
        }
        return resource;
    }

    ModelMap createModelMapWithLeafElements(XMLStreamReader reader) throws XMLStreamException {
        ModelMap elements = new ModelMap();
        int level = 0;
        int event = reader.getEventType();
        String attrValue = null;
        String attrName = null;
        while (true) {
            switch (event) {
                case 1: {
                    ++level;
                    attrName = reader.getLocalName();
                    attrValue = null;
                    break;
                }
                case 2: {
                    if (attrName != null && attrValue != null) {
                        this.addAttribute(elements, attrName, attrValue.trim());
                    }
                    if (--level == 0) {
                        return elements;
                    }
                    attrName = null;
                    attrValue = null;
                    break;
                }
                case 4: {
                    attrValue = attrValue == null ? reader.getText() : attrValue + reader.getText();
                }
            }
            event = reader.next();
        }
    }

    private void addAttribute(ModelMap map, String name, String value) {
        if (name != null && value != null) {
            map.put(name, value);
        }
    }

    public static boolean isActiveView(IContext context) {
        return RelationshipsView.isActiveView(((ProducerContext)context).getStageContext());
    }

    public static boolean isActiveView(StageContext context) {
        return !RelationshipsView.isTemplate(context) && !RelationshipsView.isMenuView(context);
    }

    public static boolean isMenuView(StageContext context) {
        return "true".equals(context.getEnv().getParameter("buildSiblingMenu")) || "true".equals(context.getEnv().getParameter("buildActionsMenu"));
    }

    public boolean canSelectRow() {
        return !RelationshipsView.isMaximized(this.context);
    }

    private void addSummaryMetrics(IContext producerContext, String resourceType, ResourceTableModel model, int row, TableColumnModel columnModel, ModelMap resourceTypeAttrs, ArrayList propertyNames) throws ParseException, PipelineException, XMLStreamException, DatatypeConfigurationException {
        ModelMap propertyMetaData = null;
        if (row == 0) {
            model.setColumnCount(model.getColumnCount() + propertyNames.size());
        }
        ModelMap resourceTypeMetaData = this.metaDataByResourceType.getMap(resourceType);
        int col = 0;
        int visibleColCount = "true".equals(producerContext.getSessionParameter("e_showTenantInfo")) ? 4 : 3;
        String rendererClass = null;
        for (String propName : propertyNames) {
            TableColumn column;
            if (resourceTypeMetaData != null) {
                propertyMetaData = resourceTypeMetaData.getMap("Property").getMap(propName);
            }
            if ((column = columnModel.getColumn(col + visibleColCount)) == null) {
                column = new TableColumn(col + visibleColCount);
                columnModel.addColumn(column);
            }
            if (propertyMetaData != null) {
                if (this.propertyRenderers != null && (rendererClass = (String)this.propertyRenderers.get(propName)) != null) {
                    column.setCellRenderer(rendererClass);
                }
                column.setHeaderValue((Object)propertyMetaData.getValue("Caption"));
                column.setToolTip(propertyMetaData.getValue("Description"));
            }
            Object value = resourceTypeAttrs.getValue(propName);
            if (rendererClass == null && value != null && propertyMetaData != null) {
                String type = propertyMetaData.getValue("Type");
                if ("xs:duration".equals(type)) {
                    value = new XTSDuration(String.valueOf(value));
                    ((XTSDuration)value).setLocale(this.context.getEnv().getContentLocale());
                } else if ("cdm:percentage".equals(type)) {
                    value = new PercentageFormatter(Float.valueOf(value.toString()), producerContext);
                } else if ("xs:unsignedLong".equals(type)) {
                    value = Long.valueOf(value.toString());
                } else if ("xs:dateTime".equals(type)) {
                    value = new DateTimeFormatter(value.toString(), producerContext);
                }
            }
            model.setValueAt(value, row, col);
            ++col;
        }
    }

    static class ModelMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;

        ModelMap() {
        }

        public ModelMap getMap(String key) {
            return (ModelMap)super.get(key);
        }

        public String getValue(String key) {
            return (String)this.get(key);
        }
    }
}

