/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.portal.producer.process.system.scorecard;

import com.cognos.admin.common.logging.CogAdminLogger;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IMessagesManager;
import com.cognos.admin.j2html.portal.producer.control.ProducerContext;
import com.cognos.admin.portal.common.messages.MessagesManagerFacade;
import com.cognos.admin.portal.components.system.Resource;
import com.cognos.admin.portal.components.system.ResourceTableModel;
import com.cognos.admin.portal.components.system.scorecard.ScorecardComponent;
import com.cognos.admin.portal.producer.process.system.scorecard.AbstractScorecardView;
import com.cognos.admin.ws.wsrf.wsrf_bf.v1_2.BaseFaultType;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.producer.stage.StageContext;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.PathIterator;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TemplatesView
extends AbstractScorecardView {
    private static final String ROOT_RELATIONSHIPS = "/GetMultipleResourcePropertiesResponse/SupportedResourceTypes/ResourceType";

    public TemplatesView(ServiceLogger logger) {
        super(logger);
    }

    protected void executeImpl(StageContext context) throws PipelineException {
        try {
            if (TemplatesView.isActiveView(context)) {
                this.context = context;
                ProducerContext producerContext = new ProducerContext(context, (IMessagesManager)new MessagesManagerFacade());
                ArrayList rows = this.init(context, context.getInputAsXMLStreamReader("templatesDataResponse"), new String[]{ROOT_RELATIONSHIPS, "/GetMultipleResourcePropertiesResponse/SupportedResourceTypes/ResourceType/Name", "/GetMultipleResourcePropertiesResponse/SupportedResourceTypes/ResourceType/Caption", "/GetMultipleResourcePropertiesResponse/SupportedResourceTypes/ResourceType/ResourceId", "/GetMultipleResourcePropertiesResponse/SupportedResourceTypes/ResourceType/Icon", "/GetMultipleResourcePropertiesResponse/SupportedResourceTypes/ResourceType/SupportsTemplates"});
                ResourceTableModel model = new ResourceTableModel((IContext)producerContext, rows.size());
                for (int i = 0; i < rows.size(); ++i) {
                    model.setValueAt(rows.get(i), i, 0);
                }
                ScorecardComponent comp = new ScorecardComponent((IContext)producerContext, model, false, true);
                producerContext.render((ControlledComponent)comp);
            }
        }
        catch (PipelineException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LocalizableException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (J2HTMLException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (BaseFaultType e) {
            CogAdminLogger.getInstance().error(e.getMessage(), (Throwable)e);
            throw new PipelineException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private ArrayList init(StageContext context, XMLStreamReader reader, String[] searchPath) throws PipelineException, XMLStreamException, UnsupportedEncodingException, BaseFaultType {
        int index;
        PathIterator iter = new PathIterator(reader, searchPath);
        Resource resource = null;
        ArrayList<Resource> rows = new ArrayList<Resource>();
        while ((index = iter.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    resource = new Resource();
                    break;
                }
                case 1: {
                    String name = iter.getElementText();
                    resource.setResourceId(name);
                    break;
                }
                case 2: {
                    String caption = iter.getElementText();
                    resource.setName(caption);
                    break;
                }
                case 3: {
                    String resourceId = iter.getElementText();
                    resource.setResourceId(resourceId);
                    break;
                }
                case 4: {
                    String iconPath = iter.getElementText();
                    resource.setIconPath("/ps/" + iconPath);
                    break;
                }
                case 5: {
                    String supportsTemplates = iter.getElementText();
                    if (supportsTemplates != null && !Boolean.valueOf(supportsTemplates).booleanValue()) break;
                    rows.add(resource);
                }
            }
        }
        Collections.sort(rows);
        return rows;
    }

    public static boolean isActiveView(StageContext context) {
        return TemplatesView.isTemplate(context);
    }
}

