/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.userpreferences.datasourcecredentials;

import com.cognos.admin.common.NameSpace;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IJ2HTMLXmlProcessor;
import com.cognos.admin.portal.common.NavRequestBuilder;
import com.cognos.admin.userpreferences.datasourcecredentials.DataSourceCredential;
import com.cognos.admin.userpreferences.datasourcecredentials.Error;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class BuildNavRequest
extends NavRequestBuilder
implements IJ2HTMLXmlProcessor {
    private XMLStreamReader dataSourceCredentialsReader = null;
    private XMLStreamWriter navRequestWriter = null;
    private XMLStreamWriter navRequestFlagWriter = null;
    private XMLStreamWriter dataSourceCredentialsWriter = null;
    private List<DataSourceCredential> dataSourceCredentials = null;
    private ArrayList<String> dataSourcePaths = null;
    private IContext context = null;

    public void writeToXMLWriterStream(IContext context, Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.setContext(context);
        this.setWritersAndReaders(readers, writers);
        this.readDataSourceCredentials();
        this.generateOutput();
    }

    private void setContext(IContext context) throws J2HTMLException {
        this.checkContext(context);
        this.context = context;
    }

    @Override
    protected IContext getContext() {
        return this.context;
    }

    @Override
    protected void writeNavRequestQueries(XMLStreamWriter writer) throws J2HTMLException, XMLStreamException {
        int index = -1;
        int existingIndex = -1;
        this.dataSourcePaths = new ArrayList(this.dataSourceCredentials.size());
        this.navRequestWriter.writeStartElement(NameSpace.NAV.getUri(), "queries");
        for (DataSourceCredential dataSourceCredential : this.dataSourceCredentials) {
            this.validateDataSourceCredential(dataSourceCredential);
            existingIndex = this.getDataSourceIndex(dataSourceCredential);
            if (existingIndex >= 0) {
                dataSourceCredential.setDataSourceNavIndex(existingIndex);
            } else {
                this.writeGetItemQuery(this.navRequestWriter, dataSourceCredential.generateDataSourcePath());
                dataSourceCredential.setDataSourceNavIndex(++index);
                this.registerDataSource(dataSourceCredential, index);
            }
            this.writeGetItemQuery(this.navRequestWriter, dataSourceCredential.generateDataSourceConnectionPath());
            dataSourceCredential.setDataSourceConnectionNavIndex(++index);
        }
        this.navRequestWriter.writeEndElement();
    }

    private int getDataSourceIndex(DataSourceCredential dataSourceCredential) {
        return this.dataSourcePaths.indexOf(dataSourceCredential.getDataSourceName());
    }

    private void registerDataSource(DataSourceCredential dataSourceCredential, int index) {
        this.dataSourcePaths.add(dataSourceCredential.getDataSourceName());
    }

    private void setWritersAndReaders(Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.setDataSourceCreadentialReader(readers);
        this.setNavRequestWriter(writers);
        this.setNavRequestFlagWriter(writers);
        this.setDataSourceCredentialsWriter(writers);
    }

    private void setDataSourceCreadentialReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        this.dataSourceCredentialsReader = this.findReader(readers, "dataSourceCredentials");
        if (this.dataSourceCredentialsReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_CREDENTIALS_READER.getMsg());
        }
    }

    private void setNavRequestWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.navRequestWriter = this.findWriters(writers, "navRequest");
        if (this.navRequestWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_NAV_REQUEST_WRITER.getMsg());
        }
    }

    private void setNavRequestFlagWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.navRequestFlagWriter = this.findWriters(writers, "navRequestFlag");
        if (this.navRequestFlagWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_NAV_REQUEST_FLAG_WRITER.getMsg());
        }
    }

    private void setDataSourceCredentialsWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.dataSourceCredentialsWriter = this.findWriters(writers, "dataSourceCredentials");
        if (this.dataSourceCredentialsWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_CREDENTIALS_WRITER.getMsg());
        }
    }

    private void readDataSourceCredentials() throws J2HTMLException {
        try {
            this.dataSourceCredentials = DataSourceCredential.fromXmlStreamReader(this.dataSourceCredentialsReader);
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.READING_DATA_SOURCE_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }

    private void validateDataSourceCredential(DataSourceCredential dataSourceCredential) throws J2HTMLException {
        if (!dataSourceCredential.isDataSourceNameSet() || !dataSourceCredential.isDataSourceConnectionNameSet()) {
            throw new J2HTMLException(Error.INVALID_DATA_SOURCE_CREDENTIAL.getMsg());
        }
    }

    private void generateOutput() throws J2HTMLException {
        if (!this.doDataSourceCredentialsExists()) {
            this.writeNoNavRequestFlag(this.navRequestFlagWriter);
            this.writeEmptyDataSourceCredentials();
        } else {
            this.writeSoapEnvelope(this.navRequestWriter);
            this.writeDataSourceCredentials();
            this.writeNavRequestFlag(this.navRequestFlagWriter);
        }
    }

    private boolean doDataSourceCredentialsExists() {
        return this.dataSourceCredentials != null && !this.dataSourceCredentials.isEmpty();
    }

    private void writeEmptyDataSourceCredentials() throws J2HTMLException {
        try {
            this.dataSourceCredentialsWriter.writeStartElement("dataSourceCredentials");
            this.dataSourceCredentialsWriter.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_EMPTY_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }

    private void writeDataSourceCredentials() throws J2HTMLException {
        try {
            this.dataSourceCredentialsWriter.writeStartElement("dataSourceCredentials");
            for (DataSourceCredential dataSourceCredential : this.dataSourceCredentials) {
                dataSourceCredential.toXmlStreamWriter(this.dataSourceCredentialsWriter);
            }
            this.dataSourceCredentialsWriter.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }
}

