/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.userpreferences.datasourcecredentials;

import com.cognos.portal.xml.stream.PathIterator;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DataSourceCredential {
    private String dataSourceConnectionName = "";
    private String dataSourceName = "";
    private String storeId = "";
    private int dataSourceNavIndex = -1;
    private int dataSourceConnectionNavIndex = -1;

    private boolean isStoreIdDefined() {
        return this.getStoreId() != null;
    }

    private boolean isDataSourceNameDefined() {
        return this.getDataSourceName() != null;
    }

    private boolean isDataSourceConnectionNameDefined() {
        return this.getDataSourceConnectionName() != null;
    }

    private boolean isXmlWriterDefined(XMLStreamWriter writer) {
        return writer != null;
    }

    boolean isStoreIdSet() {
        return this.getStoreId() != null && this.getStoreId().length() > 0;
    }

    boolean isDataSourceNameSet() {
        return this.getDataSourceName() != null && this.getDataSourceName().length() > 0;
    }

    boolean isDataSourceNavIndexSet() {
        return this.getDataSourceNavIndex() >= 0;
    }

    boolean isDataSourceConnectionNameSet() {
        return this.getDataSourceConnectionName() != null && this.getDataSourceConnectionName().length() > 0;
    }

    boolean isDataSourceConnectionNavIndexSet() {
        return this.getDataSourceConnectionNavIndex() >= 0;
    }

    String getStoreId() {
        return this.storeId;
    }

    void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    String getDataSourceConnectionName() {
        return this.dataSourceConnectionName;
    }

    void setDataSourceConnectionName(String dataSourceConnectionName) {
        this.dataSourceConnectionName = dataSourceConnectionName;
    }

    String getDataSourceName() {
        return this.dataSourceName;
    }

    void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    int getDataSourceNavIndex() {
        return this.dataSourceNavIndex;
    }

    void setDataSourceNavIndex(int dataSourceNavIndex) {
        this.dataSourceNavIndex = dataSourceNavIndex;
    }

    int getDataSourceConnectionNavIndex() {
        return this.dataSourceConnectionNavIndex;
    }

    void setDataSourceConnectionNavIndex(int dataSourceConnectionNavIndex) {
        this.dataSourceConnectionNavIndex = dataSourceConnectionNavIndex;
    }

    String generateDataSourcePath() {
        if (!this.isDataSourceNameSet()) {
            throw new IllegalArgumentException("Undefined data source name");
        }
        return "//dataSource[@name='" + this.getDataSourceName() + "']";
    }

    String generateDataSourceConnectionPath() {
        if (!this.isDataSourceConnectionNameSet()) {
            throw new IllegalArgumentException("Undefined data source connection name");
        }
        return this.generateDataSourcePath() + "/dataSourceConnection[@name='" + this.getDataSourceConnectionName() + "']";
    }

    public void toXmlStreamWriter(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (!this.isXmlWriterDefined(xmlStreamWriter)) {
            throw new IllegalArgumentException("Undefined writer");
        }
        xmlStreamWriter.writeStartElement("dataSourceCredential");
        if (this.isStoreIdDefined()) {
            xmlStreamWriter.writeStartElement("storeID");
            xmlStreamWriter.writeCharacters(this.getStoreId());
            xmlStreamWriter.writeEndElement();
        }
        if (this.isDataSourceConnectionNameDefined()) {
            xmlStreamWriter.writeStartElement("dataSourceConnectionName");
            xmlStreamWriter.writeCharacters(this.getDataSourceConnectionName());
            xmlStreamWriter.writeEndElement();
        }
        if (this.isDataSourceNameDefined()) {
            xmlStreamWriter.writeStartElement("dataSourceName");
            xmlStreamWriter.writeCharacters(this.getDataSourceName());
            xmlStreamWriter.writeEndElement();
        }
        if (this.isDataSourceNavIndexSet()) {
            xmlStreamWriter.writeStartElement("dataSourceNavIndex");
            xmlStreamWriter.writeCharacters("" + this.getDataSourceNavIndex());
            xmlStreamWriter.writeEndElement();
        }
        if (this.isDataSourceConnectionNavIndexSet()) {
            xmlStreamWriter.writeStartElement("dataSourceConnectionNavIndex");
            xmlStreamWriter.writeCharacters("" + this.getDataSourceConnectionNavIndex());
            xmlStreamWriter.writeEndElement();
        }
        xmlStreamWriter.writeEndElement();
    }

    static List<DataSourceCredential> fromXmlStreamReader(XMLStreamReader reader) throws XMLStreamException {
        PathIterator pathIterator = null;
        ArrayList<DataSourceCredential> list = new ArrayList<DataSourceCredential>();
        int index = -1;
        DataSourceCredential dataSourceCredential = null;
        pathIterator = new PathIterator(reader, new String[]{"/dataSourceCredentials/dataSourceCredential", "/dataSourceCredentials/dataSourceCredential/dataSourceName", "/dataSourceCredentials/dataSourceCredential/dataSourceConnectionName", "/dataSourceCredentials/dataSourceCredential/dataSourceNavIndex", "/dataSourceCredentials/dataSourceCredential/dataSourceConnectionNavIndex", "/dataSourceCredentials/dataSourceCredential/storeID"});
        block8: while ((index = pathIterator.moveToNextPath()) != -1) {
            switch (index) {
                case 0: {
                    if (dataSourceCredential != null) {
                        list.add(dataSourceCredential);
                    }
                    dataSourceCredential = new DataSourceCredential();
                    continue block8;
                }
                case 1: {
                    dataSourceCredential.setDataSourceName(pathIterator.getElementText());
                    continue block8;
                }
                case 2: {
                    dataSourceCredential.setDataSourceConnectionName(pathIterator.getElementText());
                    continue block8;
                }
                case 3: {
                    dataSourceCredential.setDataSourceNavIndex(Integer.parseInt(pathIterator.getElementText()));
                    continue block8;
                }
                case 4: {
                    dataSourceCredential.setDataSourceConnectionNavIndex(Integer.parseInt(pathIterator.getElementText()));
                    continue block8;
                }
                case 5: {
                    dataSourceCredential.setStoreId(pathIterator.getElementText());
                    continue block8;
                }
            }
        }
        if (dataSourceCredential != null) {
            list.add(dataSourceCredential);
        }
        return list;
    }
}

