/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.userpreferences.datasourcecredentials;

import com.cognos.admin.j2html.Attributes;
import com.cognos.admin.j2html.Component;
import com.cognos.admin.j2html.ControlledComponent;
import com.cognos.admin.j2html.DefaultTableCellRenderer;
import com.cognos.admin.j2html.DefaultTableLayoutHandler;
import com.cognos.admin.j2html.ITableLayoutHandler;
import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.Link;
import com.cognos.admin.j2html.Panel;
import com.cognos.admin.j2html.SectionPane;
import com.cognos.admin.j2html.Table;
import com.cognos.admin.j2html.TableColumn;
import com.cognos.admin.j2html.TableLayoutConstraint;
import com.cognos.admin.j2html.TableLayoutPane;
import com.cognos.admin.j2html.actions.AbstractAction;
import com.cognos.admin.j2html.actions.CheckBoxTogglerAction;
import com.cognos.admin.j2html.actions.IAction;
import com.cognos.admin.j2html.control.DefaultControlledComponentFactory;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IControlledComponentFactory;
import com.cognos.admin.j2html.table.DefaultTableModel;
import com.cognos.admin.j2html.table.ITableCellRenderer;
import com.cognos.admin.j2html.table.ITableModel;
import com.cognos.admin.j2html.table.ITableRowRenderer;
import com.cognos.admin.j2html.table.TableRowSeparator;
import com.cognos.admin.portal.common.CommonError;
import com.cognos.admin.userpreferences.datasourcecredentials.DataSourceCredential;
import com.cognos.admin.userpreferences.datasourcecredentials.DataSourceCredentialAction;
import com.cognos.admin.userpreferences.datasourcecredentials.Error;
import com.cognos.admin.userpreferences.datasourcecredentials.Utils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataSourceCredentialsComponentFactory
extends DefaultControlledComponentFactory
implements IControlledComponentFactory {
    static final int COLUMN_NBR = 3;
    static final int DATA_COL_IDX = 2;
    static final int DATA_SOURCE_NAME_COL_IDX = 0;
    static final int DATA_SOURCE_CONN_NAME_COL_IDX = 1;
    private XMLStreamReader dataSourceCredentialsReader = null;
    private IContext context;
    private boolean canWrite = false;

    public ControlledComponent createControlledComponent(IContext context, Map<String, XMLStreamReader> readers) throws J2HTMLException {
        ControlledComponent controlledComponent = null;
        this.setContext(context);
        this.setDataSourceCreadentialReader(readers);
        controlledComponent = this.createControlledComponent();
        return controlledComponent;
    }

    void setContext(IContext context) throws J2HTMLException {
        if (context == null) {
            throw new J2HTMLException(CommonError.UNDEFINED_CONTEXT.getMsg());
        }
        this.context = context;
        this.canWrite = Utils.getWriteAccess(this.context);
    }

    void setDataSourceCreadentialReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        if (readers != null) {
            this.dataSourceCredentialsReader = readers.get("dataSourceCredentials");
        }
        if (this.dataSourceCredentialsReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_CREDENTIALS_READER.getMsg());
        }
    }

    ControlledComponent createControlledComponent() throws J2HTMLException {
        DefaultTableModel tableModel = null;
        ControlledComponent controlledComponent = null;
        tableModel = this.createTableModel();
        controlledComponent = this.createControlledComponent(tableModel);
        this.setClientStateVariable(controlledComponent);
        return controlledComponent;
    }

    DefaultTableModel createTableModel() throws J2HTMLException {
        List<DataSourceCredential> list = null;
        DataSourceCredentialsTableModel tableModel = null;
        try {
            tableModel = new DataSourceCredentialsTableModel();
            tableModel.addColumn("dataSourceName");
            tableModel.addColumn("dataSourceConnectionName");
            tableModel.addColumn("data");
            tableModel.setSummary(this.context.localize("IDS_DSC_TABLE_SUMMARY"));
            list = DataSourceCredential.fromXmlStreamReader(this.dataSourceCredentialsReader);
            for (DataSourceCredential dataSourceCredential : list) {
                this.validateDataSourceCredential(dataSourceCredential);
                this.addNewDataSourceCredentialInModel(dataSourceCredential, tableModel);
            }
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.READING_DATA_SOURCE_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
        catch (J2HTMLException j2thmle) {
            throw j2thmle;
        }
        return tableModel;
    }

    private void setClientStateVariable(ControlledComponent controlledComponent) throws J2HTMLException {
        String toBeDeletedList = null;
        JSONArray jsonArray = null;
        JSONObject jsonObject = null;
        try {
            toBeDeletedList = this.context.getStateParameter("m_deletedIds");
            if (this.isDeletedListDefined(toBeDeletedList)) {
                jsonArray = JSONArray.parse((String)toBeDeletedList);
                jsonObject = new JSONObject();
                jsonObject.put((Object)"m_deletedIds", (Object)jsonArray);
                controlledComponent.addClientPublicVariable(jsonObject, true);
            }
        }
        catch (IOException ioe) {
            throw new J2HTMLException(Error.INVALID_DELETED_DATA_SOURCE_CREDENTIAL_LIST.getMsg(), (Throwable)ioe);
        }
    }

    private boolean isDeletedListDefined(String toBeDeletedList) {
        return toBeDeletedList != null && toBeDeletedList.length() > 0;
    }

    private boolean hasWritePermission() {
        return this.canWrite;
    }

    private boolean doesSupportSelectableActions(DefaultTableModel model) {
        return model.getRowCount() > 0 && this.hasWritePermission();
    }

    private void validateDataSourceCredential(DataSourceCredential dataSourceCredential) throws J2HTMLException {
        if (!(dataSourceCredential.isDataSourceNameSet() && dataSourceCredential.isDataSourceConnectionNameSet() && dataSourceCredential.isStoreIdSet())) {
            throw new J2HTMLException(Error.INVALID_DATA_SOURCE_CREDENTIAL.getMsg());
        }
    }

    private void addNewDataSourceCredentialInModel(DataSourceCredential dataSourceCredential, DefaultTableModel model) {
        Object[] newRow = new Object[]{dataSourceCredential.getDataSourceName(), dataSourceCredential.getDataSourceConnectionName(), dataSourceCredential};
        model.addRow(newRow);
    }

    private ControlledComponent createControlledComponent(DefaultTableModel tableModel) {
        DataSourceCredentialsComponent controlledComponent = null;
        TableLayoutPane tableLayoutPane = null;
        SectionPane mainSection = new SectionPane();
        controlledComponent = new DataSourceCredentialsComponent(this.context);
        tableLayoutPane = this.createTableLayoutPane(this.context, tableModel);
        mainSection.setSeparator(false);
        mainSection.setDescription(this.context.localize("IDS_DSC_DESC"));
        mainSection.setPadding("15 0 0 0");
        mainSection.add((Component)tableLayoutPane);
        controlledComponent.add((Component)mainSection);
        return controlledComponent;
    }

    private TableLayoutPane createTableLayoutPane(IContext context, DefaultTableModel tableModel) {
        TableLayoutPane tableLayoutPane = null;
        DefaultTableLayoutHandler defaultTableLayoutHandler = null;
        Table table = null;
        Panel buttonPanel = null;
        tableLayoutPane = tableModel.getRowCount() > 0 ? new TableLayoutPane(2, 2) : new TableLayoutPane(1, 1);
        defaultTableLayoutHandler = new DefaultTableLayoutHandler();
        table = this.createTable(tableModel);
        this.addTableToTableLayout(table, defaultTableLayoutHandler);
        if (this.doesSupportSelectableActions(tableModel)) {
            buttonPanel = this.createButtonPanel();
            this.addButtonPanelToTableLayout(buttonPanel, defaultTableLayoutHandler);
        }
        tableLayoutPane.setTableLayoutHandler((ITableLayoutHandler)defaultTableLayoutHandler);
        return tableLayoutPane;
    }

    private void addTableToTableLayout(Table table, DefaultTableLayoutHandler tableLayoutHandler) {
        tableLayoutHandler.add((Component)table, 0, 0, null);
        tableLayoutHandler.getDefaultConstraint().setPadding("5 0 0 0");
    }

    private void addButtonPanelToTableLayout(Panel buttonPanel, DefaultTableLayoutHandler tableLayoutHandler) {
        TableLayoutConstraint constraints = new TableLayoutConstraint();
        constraints.setAlign("right");
        tableLayoutHandler.add((Component)buttonPanel, 1, 0, constraints);
    }

    private Table createTable(DefaultTableModel model) {
        Table table = null;
        boolean doesSupportSelectableActions = this.doesSupportSelectableActions(model);
        table = new Table((ITableModel)model);
        if (model.getRowCount() == 0) {
            table.setWidth("400");
        }
        table.createDefaultColumnsFromModel();
        table.setSortable(true);
        table.setSupportsGroupActions(doesSupportSelectableActions, doesSupportSelectableActions);
        table.setRowRenderer((ITableRowRenderer)new DataSourceCredentialsRowRenderer());
        table.setSortedColumn(0, true, true);
        this.formatDataColumn(table);
        this.formatDataSourceNameColumn(table);
        this.formatDataSourceConnectionNameColumn(table);
        return table;
    }

    private Panel createButtonPanel() {
        Panel buttonPanel = null;
        Link removeLink = null;
        buttonPanel = new Panel();
        removeLink = new Link(this.context.localize("IDS_REMOVE"));
        removeLink.setAction((IAction)DataSourceCredentialAction.createRemoveAction());
        buttonPanel.add((Component)removeLink);
        return buttonPanel;
    }

    private void formatDataSourceNameColumn(Table table) {
        TableColumn dataSourceColumn = null;
        dataSourceColumn = table.getColumn(0);
        dataSourceColumn.setHeaderValue((Object)this.context.localize("IDS_DSC_DATA_SOURCE_NAME"));
        dataSourceColumn.setAlign("left");
        dataSourceColumn.setHeaderRenderer((ITableCellRenderer)new DefaultTableCellRenderer());
        dataSourceColumn.setWordWrap(true);
        dataSourceColumn.setSortable(true, false);
    }

    private void formatDataSourceConnectionNameColumn(Table table) {
        TableColumn dataSourceConnColumn = null;
        dataSourceConnColumn = table.getColumn(1);
        dataSourceConnColumn.setHeaderValue((Object)this.context.localize("IDS_DSC_DATA_SOURCE_CONN_NAME"));
        dataSourceConnColumn.setAlign("left");
        dataSourceConnColumn.setHeaderRenderer((ITableCellRenderer)new DefaultTableCellRenderer());
        dataSourceConnColumn.setWordWrap(true);
        dataSourceConnColumn.setSortable(true, false);
    }

    private void formatDataColumn(Table table) {
        TableColumn dataColumn = null;
        dataColumn = table.getColumn(2);
        dataColumn.setHeaderValue((Object)"");
        dataColumn.setVisible(false);
    }

    public class DataSourceCredentialsRowRenderer
    implements ITableRowRenderer {
        DataSourceCredential dataSourceCredential = null;
        CheckBoxTogglerAction checkBoxTogglerAction = new CheckBoxTogglerAction(null, null);

        public AbstractAction getGroupAction() {
            return this.checkBoxTogglerAction;
        }

        public String getGroupActionKey() {
            return this.getDataSourceCredential().getStoreId();
        }

        public String getSelectedRowStateKey() {
            return this.getDataSourceCredential().getStoreId();
        }

        public AbstractAction getSelectionAction() {
            return null;
        }

        public TableRowSeparator getTableRowSeparator(boolean isAfter) {
            return null;
        }

        public void init(Table table, int row) {
            this.dataSourceCredential = (DataSourceCredential)table.getValue(row, 2);
        }

        private DataSourceCredential getDataSourceCredential() {
            return this.dataSourceCredential;
        }

        public Attributes getRowAttributes() {
            return null;
        }
    }

    public class DataSourceCredentialsComponent
    extends ControlledComponent {
        public DataSourceCredentialsComponent(IContext context) {
            super(context);
        }

        public int getDepth() {
            return 0;
        }

        public int getNumRow() {
            return 0;
        }

        public String getTargetURI() {
            return null;
        }
    }

    public class DataSourceCredentialsTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 4939642682078790843L;
    }
}

