/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.userpreferences.datasourcecredentials;

import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IJ2HTMLXmlProcessor;
import com.cognos.admin.portal.common.CommonError;
import com.cognos.admin.userpreferences.datasourcecredentials.DataSourceCredential;
import com.cognos.admin.userpreferences.datasourcecredentials.Error;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class FilterDataSourceCredentials
implements IJ2HTMLXmlProcessor {
    static final String DELETED_DATA_SOURCE_CREDENTIALS = "m_deletedIds";
    static final String STORED_ID_KEY = "storeID";
    private XMLStreamReader dataSourceCredentialsReader = null;
    private XMLStreamWriter dataSourceCredentialsWriter = null;
    private List<DataSourceCredential> dataSourceCredentials = null;
    private List<DataSourceCredential> dataSourceCredentialsToBeDeleted = null;
    private IContext context = null;

    public void writeToXMLWriterStream(IContext context, Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.setContext(context);
        this.setWritersAndReaders(readers, writers);
        this.setDataSourcesCredentialsToBeDeleted();
        this.filterDataSourceCredentials();
        this.generateOutput();
    }

    private void setContext(IContext context) throws J2HTMLException {
        if (context == null) {
            throw new J2HTMLException(CommonError.UNDEFINED_CONTEXT.getMsg());
        }
        if (context.getEnv() == null) {
            throw new J2HTMLException(CommonError.UNDEFINED_ENVIRONMENT.getMsg());
        }
        this.context = context;
    }

    private void setWritersAndReaders(Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.setDataSourceCreadentialReader(readers);
        this.setDataSourceCredentialsWriter(writers);
    }

    private void setDataSourceCreadentialReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        if (readers != null) {
            this.dataSourceCredentialsReader = readers.get("dataSourceCredentials");
        }
        if (this.dataSourceCredentialsReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_CREDENTIALS_READER.getMsg());
        }
    }

    private void setDataSourceCredentialsWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        if (writers != null) {
            this.dataSourceCredentialsWriter = writers.get("dataSourceCredentials");
        }
        if (this.dataSourceCredentialsWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_CREDENTIALS_WRITER.getMsg());
        }
    }

    private void setDataSourcesCredentialsToBeDeleted() throws J2HTMLException {
        String ids = null;
        ids = this.getDataSourcesCredentialsToBeDeletedFromContext();
        this.dataSourceCredentialsToBeDeleted = this.generateListFromContextValue(ids);
    }

    private List<DataSourceCredential> generateListFromContextValue(String stateValue) throws J2HTMLException {
        ArrayList<DataSourceCredential> list = null;
        JSONArray jsonArray = null;
        DataSourceCredential dataSourceCredential = null;
        JSONObject jsonObject = null;
        String storeId = null;
        try {
            if (stateValue != null && stateValue.length() > 0) {
                jsonArray = JSONArray.parse((String)stateValue);
                list = new ArrayList<DataSourceCredential>(jsonArray.size());
                for (Object object : jsonArray) {
                    jsonObject = (JSONObject)object;
                    storeId = this.retrieveStoreIdDefinedInJsonObject(jsonObject);
                    if (!this.isStoreIdDefined(storeId)) continue;
                    dataSourceCredential = new DataSourceCredential();
                    dataSourceCredential.setStoreId(storeId);
                    list.add(dataSourceCredential);
                }
            }
        }
        catch (IOException ioe) {
            throw new J2HTMLException(Error.INVALID_DELETED_DATA_SOURCE_CREDENTIAL_LIST.getMsg(), (Throwable)ioe);
        }
        catch (ClassCastException cce) {
            throw new J2HTMLException(Error.INVALID_DELETED_DATA_SOURCE_CREDENTIAL_LIST.getMsg(), (Throwable)cce);
        }
        return list;
    }

    private String retrieveStoreIdDefinedInJsonObject(JSONObject jsonObject) {
        String storeId = null;
        Object value = jsonObject.get((Object)STORED_ID_KEY);
        if (value != null && value instanceof String) {
            storeId = value.toString();
        }
        return storeId;
    }

    private boolean isStoreIdDefined(String storeId) {
        return storeId != null && storeId.length() > 0;
    }

    private String getDataSourcesCredentialsToBeDeletedFromContext() {
        String ids = null;
        ids = this.isListOfDeletedDataSourcesCredentialsSubmitted() ? this.context.getEnv().getParameter(DELETED_DATA_SOURCE_CREDENTIALS) : this.context.getStateParameter(DELETED_DATA_SOURCE_CREDENTIALS);
        return ids;
    }

    private boolean isListOfDeletedDataSourcesCredentialsSubmitted() {
        String parameter = this.context.getEnv().getParameter(DELETED_DATA_SOURCE_CREDENTIALS);
        return parameter != null && parameter.length() > 0;
    }

    private void updateDataSourcesCredentialsToBeDeletedInContext() throws J2HTMLException {
        String ids = null;
        JSONObject jsonObject = null;
        JSONArray jsonArray = null;
        try {
            if (this.areDataSourceCredentialsToDeleted()) {
                jsonArray = new JSONArray(this.dataSourceCredentialsToBeDeleted.size());
                for (DataSourceCredential toBeDeleted : this.dataSourceCredentialsToBeDeleted) {
                    jsonObject = new JSONObject();
                    jsonObject.put((Object)STORED_ID_KEY, (Object)toBeDeleted.getStoreId());
                    jsonArray.add((Object)jsonObject);
                }
                ids = jsonArray.serialize();
            }
            this.context.setStateParameter(DELETED_DATA_SOURCE_CREDENTIALS, ids);
        }
        catch (IOException ioe) {
            throw new J2HTMLException(Error.SERIALIZING_DATA_SOURCE_CREDENTENTIAL_TO_BE_DELETED.getMsg(), (Throwable)ioe);
        }
    }

    private void filterDataSourceCredentials() throws J2HTMLException {
        ArrayList<DataSourceCredential> listToDisplay = null;
        ArrayList<DataSourceCredential> listToBeDeleted = null;
        boolean delete = false;
        try {
            this.dataSourceCredentials = DataSourceCredential.fromXmlStreamReader(this.dataSourceCredentialsReader);
            if (!this.doDataSourceCredentialsExists()) {
                this.dataSourceCredentialsToBeDeleted = new ArrayList<DataSourceCredential>(0);
            } else if (this.areDataSourceCredentialsToDeleted()) {
                listToDisplay = new ArrayList<DataSourceCredential>(this.dataSourceCredentials.size());
                listToBeDeleted = new ArrayList<DataSourceCredential>(this.dataSourceCredentialsToBeDeleted.size());
                for (DataSourceCredential existing : this.dataSourceCredentials) {
                    delete = false;
                    for (DataSourceCredential toBeDeleted : this.dataSourceCredentialsToBeDeleted) {
                        delete = this.haveSameStoreId(toBeDeleted, existing);
                        if (!delete) continue;
                        listToBeDeleted.add(toBeDeleted);
                        break;
                    }
                    if (delete) continue;
                    listToDisplay.add(existing);
                }
                this.dataSourceCredentials = listToDisplay;
                this.dataSourceCredentialsToBeDeleted = listToBeDeleted;
            }
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.READING_DATA_SOURCE_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }

    private boolean haveSameStoreId(DataSourceCredential toBeDeleted, DataSourceCredential existing) {
        return toBeDeleted != null && existing != null && toBeDeleted.getStoreId() != null && toBeDeleted.getStoreId().equals(existing.getStoreId());
    }

    private void generateOutput() throws J2HTMLException {
        this.writeDataSourceCredentials();
        this.updateDataSourcesCredentialsToBeDeletedInContext();
    }

    private boolean doDataSourceCredentialsExists() {
        return this.dataSourceCredentials != null && !this.dataSourceCredentials.isEmpty();
    }

    private boolean areDataSourceCredentialsToDeleted() {
        return this.dataSourceCredentialsToBeDeleted != null && !this.dataSourceCredentialsToBeDeleted.isEmpty();
    }

    private void writeDataSourceCredentials() throws J2HTMLException {
        try {
            this.dataSourceCredentialsWriter.writeStartElement("dataSourceCredentials");
            if (this.doDataSourceCredentialsExists()) {
                for (DataSourceCredential dataSourceCredential : this.dataSourceCredentials) {
                    dataSourceCredential.toXmlStreamWriter(this.dataSourceCredentialsWriter);
                }
            }
            this.dataSourceCredentialsWriter.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }
}

