/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.admin.userpreferences.datasourcecredentials;

import com.cognos.admin.j2html.J2HTMLException;
import com.cognos.admin.j2html.control.IContext;
import com.cognos.admin.j2html.control.IJ2HTMLXmlProcessor;
import com.cognos.admin.portal.common.NavRequestProcessor;
import com.cognos.admin.portal.common.NavResponseItem;
import com.cognos.admin.userpreferences.datasourcecredentials.DataSourceCredential;
import com.cognos.admin.userpreferences.datasourcecredentials.Error;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ParseNavResponse
extends NavRequestProcessor
implements IJ2HTMLXmlProcessor {
    private XMLStreamReader dataSourceCredentialsReader = null;
    private XMLStreamReader navResponseReader = null;
    private XMLStreamWriter dataSourceCredentialsWriter = null;
    private List<DataSourceCredential> dataSourceCredentials = null;
    private List<NavResponseItem> navResponseItems = null;
    private IContext context;

    public void writeToXMLWriterStream(IContext context, Map<String, XMLStreamReader> readers, Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.setContext(context);
        this.setDataSourceCreadentialReader(readers);
        this.setDataSourceCredentialsWriter(writers);
        this.readDataSourceCredentials();
        if (!this.areDataSourceCredentialsDefined()) {
            this.writeEmptyDataSourceCredentials();
        } else {
            this.setNavResponseReader(readers);
            this.readNavResponse();
            this.updateDataSourceCredentials();
            this.writeDataSourceCredentials();
        }
    }

    private void setContext(IContext context) throws J2HTMLException {
        this.checkContext(context);
        this.context = context;
    }

    private void setDataSourceCreadentialReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        this.dataSourceCredentialsReader = this.findReader(readers, "dataSourceCredentials");
        if (this.dataSourceCredentialsReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_CREDENTIALS_READER.getMsg());
        }
    }

    private void setNavResponseReader(Map<String, XMLStreamReader> readers) throws J2HTMLException {
        this.navResponseReader = this.findReader(readers, "navResponse");
        if (this.navResponseReader == null) {
            throw new J2HTMLException(Error.UNDEFINED_NAV_RESPONSE_READER.getMsg());
        }
    }

    private void setDataSourceCredentialsWriter(Map<String, XMLStreamWriter> writers) throws J2HTMLException {
        this.dataSourceCredentialsWriter = this.findWriters(writers, "dataSourceCredentials");
        if (this.dataSourceCredentialsWriter == null) {
            throw new J2HTMLException(Error.UNDEFINED_DATA_SOURCE_CREDENTIALS_WRITER.getMsg());
        }
    }

    private void readDataSourceCredentials() throws J2HTMLException {
        try {
            this.dataSourceCredentials = DataSourceCredential.fromXmlStreamReader(this.dataSourceCredentialsReader);
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.READING_DATA_SOURCE_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }

    private boolean areDataSourceCredentialsDefined() {
        return this.dataSourceCredentials != null && !this.dataSourceCredentials.isEmpty();
    }

    private void writeEmptyDataSourceCredentials() throws J2HTMLException {
        try {
            this.dataSourceCredentialsWriter.writeStartElement("dataSourceCredentials");
            this.dataSourceCredentialsWriter.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_EMPTY_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }

    private void readNavResponse() throws J2HTMLException {
        try {
            this.navResponseItems = NavResponseItem.fromXmlReader(this.navResponseReader, null);
        }
        catch (Exception e) {
            throw new J2HTMLException(Error.READING_NAV_RESPONSE.getMsg(), (Throwable)e);
        }
    }

    private void updateDataSourceCredentials() throws J2HTMLException {
        NavResponseItem navResponseItem = null;
        try {
            for (DataSourceCredential dataSourceCredential : this.dataSourceCredentials) {
                this.validateDataSourceCredential(dataSourceCredential);
                navResponseItem = this.navResponseItems.get(dataSourceCredential.getDataSourceNavIndex());
                if (!navResponseItem.isNameDefined()) {
                    dataSourceCredential.setDataSourceName(this.context.localize("IDS_ADM_DATA_SOURCE_UNAVAILABLE", (Object[])new String[]{dataSourceCredential.getDataSourceName()}));
                } else {
                    dataSourceCredential.setDataSourceName(navResponseItem.getName());
                }
                navResponseItem = this.navResponseItems.get(dataSourceCredential.getDataSourceConnectionNavIndex());
                if (!navResponseItem.isNameDefined()) {
                    dataSourceCredential.setDataSourceConnectionName(this.context.localize("IDS_ADM_DATA_SOURCE_UNAVAILABLE", (Object[])new String[]{dataSourceCredential.getDataSourceConnectionName()}));
                    continue;
                }
                dataSourceCredential.setDataSourceConnectionName(navResponseItem.getName());
            }
        }
        catch (J2HTMLException j2htmle) {
            throw j2htmle;
        }
        catch (Exception e) {
            throw new J2HTMLException(Error.UPDATING_DATA_SOURCE_CREDENTIAL.getMsg(), (Throwable)e);
        }
    }

    private void validateDataSourceCredential(DataSourceCredential dataSourceCredential) throws J2HTMLException {
        if (!(dataSourceCredential.isDataSourceNameSet() && dataSourceCredential.isDataSourceConnectionNameSet() && dataSourceCredential.isDataSourceNavIndexSet() && dataSourceCredential.isDataSourceConnectionNavIndexSet())) {
            throw new J2HTMLException(Error.INVALID_DATA_SOURCE_CREDENTIAL.getMsg());
        }
    }

    private void writeDataSourceCredentials() throws J2HTMLException {
        try {
            this.dataSourceCredentialsWriter.writeStartElement("dataSourceCredentials");
            for (DataSourceCredential dataSourceCredential : this.dataSourceCredentials) {
                dataSourceCredential.toXmlStreamWriter(this.dataSourceCredentialsWriter);
            }
            this.dataSourceCredentialsWriter.writeEndElement();
        }
        catch (XMLStreamException xmle) {
            throw new J2HTMLException(Error.WRITING_CREDENTIALS.getMsg(), (Throwable)xmle);
        }
    }
}

