/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.request;

import com.cognos.atom.request.AtomException;
import com.cognos.atom.service.AtomEnvironment;
import com.cognos.atom.utils.ErrorUtils;
import com.cognos.atom.utils.JSONUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class ARequestHandler {
    protected ServiceLogger logger;

    public ARequestHandler(ServiceLogger logger) {
        this.logger = logger;
    }

    protected abstract InputStream handleImpl(AtomEnvironment var1, IContext var2, Parameters var3) throws AtomException;

    public InputStream handle(AtomEnvironment env, IContext context, Parameters parameters) throws AtomException {
        InputStream is = this.handleImpl(env, context, parameters);
        if (parameters.getValue("json") != null) {
            env.setResponseContentType("application/javascript");
            return JSONUtils.transformToJSON(is, this.logger);
        }
        return is;
    }

    protected InputStream processError(AtomEnvironment env, Exception exception, Parameters parameters) throws AtomException {
        try {
            SharedByteArrayOutputStream os = new SharedByteArrayOutputStream(4096);
            XMLStreamWriter xsw = XMLStreamFactory.createXMLStreamWriter((OutputStream)os);
            ErrorUtils.writeError((Environment)env, exception, xsw, this.logger);
            InputStream is = os.toStream();
            return is;
        }
        catch (XMLStreamException e) {
            throw new AtomException("atomfeed.buildresponse.failed", e);
        }
    }
}

