/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.request;

import com.cognos.atom.request.ARequestHandler;
import com.cognos.atom.request.AtomException;
import com.cognos.atom.request.CM.pipeline.ProcessPipelineProvider;
import com.cognos.atom.request.RequestFactory;
import com.cognos.atom.service.AtomEnvironment;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.MessagesManager;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.pipeline.IPipelineProvider;
import com.cognos.portal.xml.pipeline.PipelineFactory;
import java.io.InputStream;
import java.util.ArrayList;

public class AtomProcessor {
    private IContext context;
    private ServiceLogger logger;

    public AtomProcessor(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(AtomProcessor.class) : null;
    }

    public void init(IContext context) throws AtomException {
        this.context = context;
        RequestFactory.configureHandlers(context);
    }

    public void terminate() throws AtomException {
        this.context = null;
    }

    public InputStream process(AtomEnvironment env) throws AtomException {
        try {
            String target = env.getTarget();
            Parameters parameters = env.createParameters();
            ARequestHandler reqHdlr = RequestFactory.createHandler((Environment)env, target, this.logger);
            return reqHdlr.handle(env, this.context, parameters);
        }
        catch (Throwable e) {
            throw new AtomException("atomfeed.request.failed", e);
        }
    }

    static {
        ArrayList<String> msgFileList = new ArrayList<String>();
        msgFileList.add("pfmsgs");
        msgFileList.add("cpsstringsmsgs");
        MessagesManager.getInstance().initialize(msgFileList);
        PipelineFactory.getInstance().registerProvider(ProcessPipelineProvider.ATOM_FACTORY, (IPipelineProvider)new ProcessPipelineProvider());
    }
}

