/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.request.CM.pipeline;

import com.cognos.atom.utils.ErrorUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.meta.ErrorWrapper;
import com.cognos.portal.xml.pipeline.IProcess;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ErrorProcess
implements IProcess {
    private ServiceLogger logger;
    private String name;

    public ErrorProcess(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(ErrorProcess.class) : null;
    }

    public void initialize(Map inputs) throws PipelineException {
    }

    protected ErrorWrapper getRequest(PipelineContext context) throws PipelineException {
        return (ErrorWrapper)context.getParam("error");
    }

    public void execute(PipelineContext context) throws PipelineException {
        ErrorWrapper exception;
        Object prepareTimer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            prepareTimer = this.logger.startTimer(4, "execute", "prepare operation", null);
        }
        if ((exception = this.getRequest(context)) == null) {
            if (prepareTimer != null) {
                this.logger.stopTimer(prepareTimer);
            }
            return;
        }
        IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
        XMLStreamWriter writer = output.getXMLStreamWriter();
        if (prepareTimer != null) {
            this.logger.stopTimer(prepareTimer);
        }
        try {
            ErrorUtils.writeError(context.getEnv(), exception.getException(), writer, this.logger);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new PipelineException("XMLStreamException", (Throwable)e);
        }
        Object responseTimer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            responseTimer = this.logger.startTimer(4, "execute", "Setting up response", null);
        }
        context.addOutput("output", output);
        if (responseTimer != null) {
            this.logger.stopTimer(responseTimer);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean canShare() {
        return true;
    }
}

