/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.request.ECMRepository;

import com.cognos.atom.request.ARequestHandler;
import com.cognos.atom.request.AtomException;
import com.cognos.atom.request.AtomParseException;
import com.cognos.atom.request.ECMRepository.op.GetReportVersions;
import com.cognos.atom.request.ECMRepository.op.GetVersionOutputs;
import com.cognos.atom.request.ECMRepository.op.Operation;
import com.cognos.atom.service.AtomEnvironment;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.Parameters;
import com.cognos.xts.XTSEnvironment;
import com.cognos.xts.util.LocaleUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class ECMHandler
extends ARequestHandler {
    private static String CALLER_ID = "CRN";
    private static String TARGET_SEARCHPATH = "targetSearchPath";
    public static String COMMAND_REPORTVERSIONS = "versions";
    public static String COMMAND_VERSIONOUTPUTS = "versionoutputs";
    private static String RETURNTYPE_VERSION = "version";
    private static String RETURNTYPE_OUTPUT = "output";
    AtomEnvironment atomEnv;
    XTSEnvironment xtsEnv;
    Parameters requestParameters;
    List<String> requestRestParts;
    IContext context;

    public ECMHandler(ServiceLogger logger) {
        super(logger);
        this.logger = logger != null ? logger.cloneForClass(ECMHandler.class) : null;
    }

    @Override
    protected InputStream handleImpl(AtomEnvironment atomEnv, IContext context, Parameters parameters) throws AtomException {
        this.atomEnv = atomEnv;
        this.context = context;
        this.requestParameters = parameters;
        try {
            this.xtsEnv = this.createXTSEnv();
            this.parseRequest();
            Operation op = this.getRequestOperation();
            return op.execute();
        }
        catch (Exception e) {
            return this.processError(atomEnv, e, this.requestParameters);
        }
    }

    private Operation getRequestOperation() throws AtomException {
        String opName = this.requestRestParts.get(1);
        if (COMMAND_REPORTVERSIONS.equals(opName)) {
            return new GetReportVersions(this, this.logger);
        }
        if (COMMAND_VERSIONOUTPUTS.equals(opName)) {
            return new GetVersionOutputs(this, this.logger);
        }
        throw new AtomParseException("atomfeed.request.failed");
    }

    private void parseRequest() throws AtomException {
        this.requestRestParts = new ArrayList<String>();
        String target = this.atomEnv.getTarget();
        StringTokenizer tkn = new StringTokenizer(target, "/");
        while (tkn.hasMoreElements()) {
            String part = tkn.nextToken();
            this.requestRestParts.add(part);
        }
    }

    private XTSEnvironment createXTSEnv() {
        XTSEnvironment env = new XTSEnvironment(CALLER_ID);
        Locale locale = new Locale(this.atomEnv.getProductLocale());
        env.setLocale(locale);
        env.setLookupList(LocaleUtils.createLookupList((Locale)locale, (boolean)false));
        env.setRequestContext("");
        env.setSessionContext("");
        env.setStepContext("");
        env.setSubRequestContext("");
        return env;
    }

    public AtomEnvironment getAtomEnvironment() {
        return this.atomEnv;
    }

    public XTSEnvironment getXTSEnvironment() {
        return this.xtsEnv;
    }

    public Parameters getRequestRestParameters() {
        return this.requestParameters;
    }

    public List<String> getRequestRestParts() {
        return this.requestRestParts;
    }
}

