/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.request.ECMRepository.op;

import com.cognos.atom.request.AtomException;
import com.cognos.atom.request.AtomParseException;
import com.cognos.atom.request.ECMRepository.ECMHandler;
import com.cognos.atom.request.ECMRepository.op.Operation;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cps.bseries.xts.repository.QueryParameter;
import com.cognos.cps.bseries.xts.repository.QueryParameters;
import com.cognos.cps.bseries.xts.repository.RepositoryAPIException;
import com.cognos.cps.bseries.xts.repository.XTSRepositoryRequest;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.schemas.atom.Entry;
import com.cognos.portal.schemas.atom.Feed;
import com.cognos.portal.utils.Parameters;
import com.cognos.xts.ext.XTSExt;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GetReportVersions
extends Operation {
    private static int REQUEST_REST_REPORTID = 2;

    public GetReportVersions(ECMHandler ecmHandler, ServiceLogger logger) {
        super(ecmHandler, logger);
        this.logger = logger != null ? logger.cloneForClass(GetReportVersions.class) : null;
    }

    @Override
    protected void verifyRequestParams() throws AtomException {
        List<String> restParameters = this.ecmHandler.getRequestRestParts();
        if (restParameters.size() < 3) {
            throw new AtomParseException("atomfeed.request.failed");
        }
    }

    @Override
    protected String getCommand() {
        return ECM_REQUEST_COMMAND_GET_REPORT_VERSIONS_BETWEEN_TIME;
    }

    @Override
    protected QueryParameters buildRequestQueryParameters() throws AtomException {
        QueryParameters queryParameters = new QueryParameters();
        try {
            String sortOrder;
            String reportStoreID = this.ecmHandler.getRequestRestParts().get(REQUEST_REST_REPORTID);
            queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_REPORT_ID, (Object)reportStoreID, "STRING"));
            String dateBefore = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_DATE_BEFORE);
            String dateAfter = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_DATE_AFTER);
            String connectionTenantID = this.ecmHandler.getRequestRestParameters().getValue("connectionTenantID");
            String tz = this.atomEnv.getEnvelope().getUserPreferenceValue("timeZoneID");
            if (dateAfter != null && !("$" + ATOM_REQUEST_DATE_AFTER).equals(dateAfter)) {
                queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_AFTERDATE, (Object)XTSExt.formatDateToUTC((String)dateAfter, (String)tz), "DATETIME"));
            }
            if (dateBefore != null && !("$" + ATOM_REQUEST_DATE_BEFORE).equals(dateBefore)) {
                queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_BEFOREDATE, (Object)XTSExt.formatDateToUTC((String)dateBefore, (String)tz), "DATETIME"));
            }
            String ecmSortOrder = ATOM_REQUEST_SORT_SORTORDER_ASC.equals(sortOrder = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_SORT_SORTORDER)) ? ECM_REQUEST_SORTINGORDER_ASC : ECM_REQUEST_SORTINGORDER_DESC;
            queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_SORTINGORDER, (Object)ecmSortOrder, "STRING"));
            if (connectionTenantID != null) {
                queryParameters.put((IQueryParameter)new QueryParameter("connectionTenantID", (Object)connectionTenantID, "STRING"));
            }
            this.buildRequestPaginationParams(queryParameters);
        }
        catch (RepositoryAPIException e) {
            throw new AtomParseException(e.getKey(), e.copyArgs(), e);
        }
        catch (Exception e) {
            throw new AtomParseException("atomfeed.request.failed", e);
        }
        return queryParameters;
    }

    @Override
    protected ArrayList<String> buildRequestQueryProperties() {
        ArrayList<String> queryProperties = new ArrayList<String>();
        queryProperties.add(ECM_PROP_REPOSITORY_OBJECT_ID);
        queryProperties.add(ECM_PROP_CREATIONTIME);
        queryProperties.add(ECM_PROP_MODIFICATIONTIME);
        queryProperties.add(ECM_PROP_DESCRIPTION);
        return queryProperties;
    }

    @Override
    String getReportSearchPath() {
        return this.ecmHandler.getRequestRestParts().get(REQUEST_REST_REPORTID);
    }

    @Override
    protected void writeEntryContent(Entry entry, XTSRepositoryRequest rRequest, IQueryResultObjects rResults) throws XMLStreamException, ParseException, Exception {
        String repositoryObjectId = XTSRepositoryRequest.getQueryResultString((Object)rResults.getPropertyValue("repositoryObjectId"));
        String creationTime = XTSRepositoryRequest.getQueryResultString((Object)rResults.getPropertyValue("creationTime"));
        String description = XTSRepositoryRequest.getQueryResultString((Object)rResults.getPropertyValue("defaultDescription"));
        this.writeEntryId(entry, repositoryObjectId);
        this.writeEntryTitle(entry, XTSExt.formatDateFromUTC((String)creationTime, (int)2, (int)3, (String)this.atomEnv.getEnvelope().getUserPreferenceValue("timeZoneID"), (String)this.atomEnv.getContentLocale()), this.atomEnv.getContentLocale());
        this.writeDate(entry, "published", creationTime);
        this.writeSummary(entry, description, this.atomEnv.getContentLocale());
        String jsonParam = "";
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_RESPONSETYPE_JSON) != null) {
            jsonParam = "&json";
        }
        String containingClass = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_CONTAINING_CLASS);
        String link = this.gateway + "/atom/ecm/" + ECMHandler.COMMAND_VERSIONOUTPUTS + "/" + this.getReportSearchPath() + "/" + EncodingUtils.urlEncode((String)repositoryObjectId, (String)"UTF-8", (boolean)false) + "?" + ATOM_REQUEST_CONTAINING_CLASS + "=" + containingClass + jsonParam;
        this.writeEntryLink(entry, "alternate", "application/atom+xml", link);
        this.writeEntryLink(entry, "alternate", "text/html", link);
    }

    @Override
    protected void writeFeedHeader(Feed feed, XTSRepositoryRequest rRequest, IQueryResultObjects rResults) throws XMLStreamException {
        this.writeFeedHeaderCommonInfo(feed, this.getReportSearchPath(), this.atomEnv.getProductLocale(), this.getReportSearchPath());
        Parameters reqParams = new Parameters();
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_DATE_BEFORE) != null) {
            reqParams.add(ATOM_REQUEST_DATE_BEFORE, this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_DATE_BEFORE));
        }
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_DATE_AFTER) != null) {
            reqParams.add(ATOM_REQUEST_DATE_AFTER, this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_DATE_AFTER));
        }
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_SORT_SORTFIELDS) != null) {
            reqParams.add(ATOM_REQUEST_SORT_SORTFIELDS, this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_SORT_SORTFIELDS));
        }
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_SORT_SORTORDER) != null) {
            reqParams.add(ATOM_REQUEST_SORT_SORTORDER, this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_SORT_SORTORDER));
        }
        this.writeLinks(feed, rResults, null, reqParams);
    }

    @Override
    protected boolean isSupportingLink(String linkType) {
        return ATOM_REQUEST_LINK_GOTO.equals(linkType) || ATOM_REQUEST_LINK_DATESELECTION.equals(linkType) || ATOM_REQUEST_LINK_SORT.equals(linkType);
    }
}

