/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.request.ECMRepository.op;

import com.cognos.atom.request.AtomException;
import com.cognos.atom.request.AtomParseException;
import com.cognos.atom.request.ECMRepository.ECMHandler;
import com.cognos.atom.request.ECMRepository.op.Operation;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.identity.ExternalIdentityProvider;
import com.cognos.cps.bseries.xts.repository.QueryParameter;
import com.cognos.cps.bseries.xts.repository.QueryParameters;
import com.cognos.cps.bseries.xts.repository.RepositoryAPIException;
import com.cognos.cps.bseries.xts.repository.XTSRepositoryRequest;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.cps.bseries.xts.request.nav.helpers.NavHelper;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.schemas.atom.Entry;
import com.cognos.portal.schemas.atom.Feed;
import com.cognos.portal.utils.Parameters;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class GetVersionOutputs
extends Operation {
    private static int REQUEST_REST_REPORTID = 2;
    private static int REQUEST_REST_REPORTOUTPUTID = 3;

    public GetVersionOutputs(ECMHandler ecmHandler, ServiceLogger logger) {
        super(ecmHandler, logger);
        this.logger = logger != null ? logger.cloneForClass(GetVersionOutputs.class) : null;
    }

    @Override
    public void verifyRequestParams() throws AtomException {
        List<String> restParameters = this.ecmHandler.getRequestRestParts();
        if (restParameters.size() < 3) {
            throw new AtomParseException("atomfeed.request.parseerror");
        }
    }

    @Override
    protected QueryParameters buildRequestQueryParameters() throws AtomException {
        QueryParameters queryParameters = new QueryParameters();
        try {
            String[] formats;
            String containingClass;
            String locale;
            ExternalIdentityProvider provider = this.getIdentityProvider();
            Identity identity = provider.getIdentity(this.ecmHandler.getAtomEnvironment().getPassportCookie());
            String reportOutputStoreID = this.ecmHandler.getRequestRestParts().get(REQUEST_REST_REPORTOUTPUTID);
            queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_REPORTVERSION_ID, (Object)reportOutputStoreID, "STRING"));
            queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_IDENTITY, (Object)identity, "OBJECT"));
            queryParameters.put((IQueryParameter)new QueryParameter("sortResultsPageBy", (Object)"burstKey", "STRING"));
            String connectionTenantID = this.ecmHandler.getRequestRestParameters().getValue("connectionTenantID");
            if (connectionTenantID != null) {
                queryParameters.put((IQueryParameter)new QueryParameter("connectionTenantID", (Object)connectionTenantID, "STRING"));
            }
            if ((locale = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_LOCALE)) != null && !"".equals(locale) && !("$" + ATOM_REQUEST_LOCALE).equals(ATOM_REQUEST_LOCALE)) {
                ArrayList<String> localeList = new ArrayList<String>();
                localeList.add(locale);
                queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_LOCALEFILTER, localeList, "STRINGLIST"));
            }
            if ((containingClass = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_CONTAINING_CLASS)) != null && (formats = NavHelper.getViewerOutputFormatsList((String)containingClass)).length > 0) {
                List<String> formatList = Arrays.asList(formats);
                queryParameters.put((IQueryParameter)new QueryParameter(ECM_REQUEST_FORMATFILTER, formatList, "STRINGLIST"));
            }
            this.buildRequestPaginationParams(queryParameters);
        }
        catch (RepositoryException ex) {
            throw new AtomException("atomfeed.request.failed", ex);
        }
        catch (RepositoryAPIException e) {
            throw new AtomParseException(e.getKey(), e.copyArgs(), e);
        }
        return queryParameters;
    }

    private ExternalIdentityProvider getIdentityProvider() {
        String cmURL = this.ecmHandler.getAtomEnvironment().getProperty("cmRestURL").toString();
        ExternalIdentityProvider provider = new ExternalIdentityProvider();
        provider.setCommandFactory(this.getHttpCommandFactory(cmURL));
        return provider;
    }

    @Override
    protected ArrayList<String> buildRequestQueryProperties() {
        ArrayList<String> queryProperties = new ArrayList<String>();
        queryProperties.add(ECM_PROP_REPOSITORY_OBJECT_ID);
        queryProperties.add(ECM_PROP_FORMAT);
        queryProperties.add(ECM_PROP_LOCALE);
        queryProperties.add(ECM_PROP_BURSTKEY);
        queryProperties.add(ECM_PROP_OURPUT_URL);
        queryProperties.add(ECM_PROP_CREATIONTIME);
        queryProperties.add(ECM_PROP_MODIFICATIONTIME);
        queryProperties.add(ECM_PROP_DESCRIPTION);
        return queryProperties;
    }

    @Override
    protected String getCommand() {
        return ECM_REQUEST_COMMAND_GET_VERSION_OUTPUTS;
    }

    @Override
    String getReportSearchPath() {
        return this.ecmHandler.getRequestRestParts().get(REQUEST_REST_REPORTID);
    }

    @Override
    protected void writeEntryContent(Entry entry, XTSRepositoryRequest rRequest, IQueryResultObjects rResults) throws XMLStreamException, ParseException, Exception {
        String repositoryObjectId = XTSRepositoryRequest.getQueryResultString((Object)rResults.getPropertyValue("repositoryObjectId"));
        String creationTime = XTSRepositoryRequest.getQueryResultString((Object)rResults.getPropertyValue("creationTime"));
        String format = null;
        if (rResults != null) {
            format = XTSRepositoryRequest.getQueryResultString((Object)rResults.getPropertyValue("format"));
        }
        this.writeEntryId(entry, repositoryObjectId);
        String title = format != null ? NavHelper.getOutputFormatDisplayName((String)format, (String)this.atomEnv.getProductLocale()) : repositoryObjectId;
        this.writeEntryTitle(entry, title, this.atomEnv.getProductLocale());
        this.writeDate(entry, "published", creationTime);
        String outputResourceURL = rRequest.buildOutputURL(this.gateway, repositoryObjectId, this.getReportSearchPath(), rResults, false);
        this.writeEntryLink(entry, "alternate", "application/octet-stream", outputResourceURL);
        if (format != null) {
            String icon = NavSystem.getInstance().getUiFormatGraphics(format);
            boolean isDocument = NavSystem.getInstance().isUiFormatGraphicsDocument(format);
            if (isDocument) {
                String iconBase = NavSystem.getInstance().getPSObjectIcon("document");
                icon = iconBase + icon;
            }
            String iconURL = this.atomEnv.getWebContent() + "/ps/portal/images/icon_" + icon + ".gif";
            this.writeIcon(entry, "icon", "image/gif", iconURL);
        }
    }

    @Override
    protected void writeFeedHeader(Feed feed, XTSRepositoryRequest rRequest, IQueryResultObjects rResults) throws XMLStreamException {
        String id = this.ecmHandler.getRequestRestParts().get(REQUEST_REST_REPORTOUTPUTID);
        this.writeFeedHeaderCommonInfo(feed, id, this.atomEnv.getProductLocale(), id);
        Parameters reqParams = new Parameters();
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_LOCALE) != null) {
            reqParams.add(ATOM_REQUEST_LOCALE, this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_LOCALE));
        }
        this.writeLinks(feed, rResults, null, reqParams);
    }

    @Override
    protected boolean isSupportingLink(String linkType) {
        return ATOM_REQUEST_LINK_GOTO.equals(linkType) || ATOM_REQUEST_LINK_LOCALESELECTION.equals(linkType);
    }
}

