/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.request.ECMRepository.op;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.atom.request.AtomException;
import com.cognos.atom.request.AtomParseException;
import com.cognos.atom.request.ECMRepository.ECMHandler;
import com.cognos.atom.request.ECMRepository.op.PluginResourceLoader;
import com.cognos.atom.request.InsufficientPrivilegeFault;
import com.cognos.atom.service.AtomEnvironment;
import com.cognos.cm.client.cmapi.HttpCommand;
import com.cognos.cm.client.cmapi.HttpCommandFactory;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginFramework.IPluginResourceLoader;
import com.cognos.cmutils.http.HttpClientFactory;
import com.cognos.cmutils.http.HttpClientFactoryProvider;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cps.bseries.xts.repository.QueryParameter;
import com.cognos.cps.bseries.xts.repository.QueryParameters;
import com.cognos.cps.bseries.xts.repository.RepositoryAPIException;
import com.cognos.cps.bseries.xts.repository.XTSRepositoryConnection;
import com.cognos.cps.bseries.xts.repository.XTSRepositoryRequest;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.schemas.AnyElement;
import com.cognos.portal.schemas.atom.Date;
import com.cognos.portal.schemas.atom.Entry;
import com.cognos.portal.schemas.atom.Feed;
import com.cognos.portal.schemas.atom.Icon;
import com.cognos.portal.schemas.atom.Id;
import com.cognos.portal.schemas.atom.Link;
import com.cognos.portal.schemas.atom.Person;
import com.cognos.portal.schemas.atom.Text;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.xts.XTSEnvironment;
import com.ibm.json.java.JSONArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class Operation {
    protected static String NS_CM = "xmlns:cm='http://developer.cognos.com/schemas/xts-cm/1/'";
    protected static String ATOM_ID_PREFIX = "tag:ibm.com,";
    protected static String DEFAULT_LINES_PER_PAGE = "15";
    protected static String ATOM_REQUEST_STARTINDEX = "startindex";
    protected static String ATOM_REQUEST_ENDINDEX = "endindex";
    protected static String ATOM_REQUEST_MAXOBJS = "maxresults";
    protected static String ATOM_REQUEST_DATE_BEFORE = "datebefore";
    protected static String ATOM_REQUEST_DATE_AFTER = "dateafter";
    protected static String ATOM_REQUEST_CONNECTION_TENANTID = "connectionTenantID";
    protected static String ATOM_REQUEST_SORT_SORTFIELDS = "sortfields";
    protected static String ATOM_REQUEST_SORT_SORTFIELDS_NAME = "name";
    protected static String ATOM_REQUEST_SORT_SORTORDER = "sortorder";
    protected static String ATOM_REQUEST_SORT_SORTORDER_ASC = "0";
    protected static String ATOM_REQUEST_SORT_SORTORDER_DESC = "1";
    protected static String ATOM_REQUEST_LOCALE = "locale";
    protected static String ATOM_REQUEST_RESPONSETYPE_JSON = "json";
    protected static String ATOM_REQUEST_CONTAINING_CLASS = "containingClass";
    protected static String ATOM_REQUEST_LINK_FIRST = "first";
    protected static String ATOM_REQUEST_LINK_LAST = "last";
    protected static String ATOM_REQUEST_LINK_NEXT = "next";
    protected static String ATOM_REQUEST_LINK_PREVIOUS = "previous";
    protected static String ATOM_REQUEST_LINK_SELF = "self";
    protected static String ATOM_REQUEST_LINK_PARENT = "up";
    protected static String ATOM_REQUEST_LINK_GOTO = "goto";
    protected static String ATOM_REQUEST_LINK_LOCALESELECTION = "localeselection";
    protected static String ATOM_REQUEST_LINK_DATESELECTION = "dateselection";
    protected static String ATOM_REQUEST_LINK_SORT = "sort";
    protected static String ECM_REQUEST_COMMAND_GET_REPORT_VERSIONS_BETWEEN_TIME = "getReportVersionsBetweenTime";
    protected static String ECM_REQUEST_REPORT_ID = "reportStoreID";
    protected static String ECM_REQUEST_AFTERDATE = "afterCreationTime";
    protected static String ECM_REQUEST_BEFOREDATE = "beforeCreationTime";
    protected static String ECM_REQUEST_SORTINGORDER = "sortingOrder";
    protected static String ECM_REQUEST_SORTINGORDER_ASC = "ASC";
    protected static String ECM_REQUEST_SORTINGORDER_DESC = "DESC";
    protected static String ECM_REQUEST_COMMAND_GET_VERSION_OUTPUTS = "getVersionOutputs";
    protected static String ECM_REQUEST_REPORTVERSION_ID = "versionObjectID";
    protected static String ECM_REQUEST_LOCALEFILTER = "localeList";
    protected static String ECM_REQUEST_FORMATFILTER = "formatList";
    protected static String ECM_REQUEST_IDENTITY = "identity";
    protected static String ECM_PROP_REPOSITORY_OBJECT_ID = "repositoryObjectId";
    protected static String ECM_PROP_CREATIONTIME = "creationTime";
    protected static String ECM_PROP_MODIFICATIONTIME = "modificationTime";
    protected static String ECM_PROP_DESCRIPTION = "defaultDescription";
    protected static String ECM_PROP_FORMAT = "format";
    protected static String ECM_PROP_LOCALE = "locale";
    protected static String ECM_PROP_BURSTKEY = "burstKey";
    protected static String ECM_PROP_BURSTKEY_DISPLAY = "burstKeyDisplayString";
    protected static String ECM_PROP_OURPUT_URL = "outputURL";
    protected static final String TENANT_REQUEST = "/1.0/objects/~~/tenantID";
    ECMHandler ecmHandler;
    StringWriter output;
    protected QueryParameters queryParameters;
    protected ArrayList<String> queryProperties;
    protected String gateway;
    protected ServiceLogger logger;
    protected AtomEnvironment atomEnv;
    private static final String[] PAGINATION_PARAM_EXCLUDE = new String[]{ATOM_REQUEST_STARTINDEX, ATOM_REQUEST_ENDINDEX};
    private static final String[] SORT_PARAM_EXCLUDE = new String[]{ATOM_REQUEST_SORT_SORTFIELDS, ATOM_REQUEST_SORT_SORTORDER};
    private static final String[] DATA_SELECTION_PARAM_EXCLUDE = new String[]{ATOM_REQUEST_DATE_BEFORE, ATOM_REQUEST_DATE_AFTER, ATOM_REQUEST_STARTINDEX, ATOM_REQUEST_ENDINDEX};
    private static final String[] LOCALE_SELECTION_PARAM_EXCLUDE = new String[]{ATOM_REQUEST_LOCALE, ATOM_REQUEST_STARTINDEX, ATOM_REQUEST_ENDINDEX};

    protected Operation(ECMHandler ecmHandler, ServiceLogger logger) {
        this.logger = logger;
        this.ecmHandler = ecmHandler;
        this.output = new StringWriter();
        this.gateway = ecmHandler.getAtomEnvironment().getGatewayURI();
        this.atomEnv = ecmHandler.getAtomEnvironment();
    }

    protected abstract void verifyRequestParams() throws AtomException;

    protected abstract String getCommand();

    protected abstract QueryParameters buildRequestQueryParameters() throws AtomException;

    protected abstract ArrayList<String> buildRequestQueryProperties();

    abstract String getReportSearchPath();

    public InputStream execute() throws AtomException {
        InputStream is = null;
        try {
            Object overallTimer = null;
            if (this.logger != null && this.logger.isPerfLevelEnabled(0)) {
                overallTimer = this.logger.startTimer(0, "execute", "Request Time", null);
            }
            this.verifyRequestParams();
            XTSEnvironment xtsEnv = this.ecmHandler.getXTSEnvironment();
            BIBusEnvelope busEnv = this.atomEnv.getEnvelope();
            if (!this.atomEnv.hasCapabilities("canViewContentInRepository")) {
                throw new InsufficientPrivilegeFault(InsufficientPrivilegeFault.INSUFFICIENT_CAPABILITY, "atomfeed.request.insufficient.capability");
            }
            String reportSearchPath = this.getReportSearchPath();
            this.queryParameters = this.buildRequestQueryParameters();
            this.queryProperties = this.buildRequestQueryProperties();
            XTSRepositoryRequest rRequest = this.sendRequest(xtsEnv, busEnv, this.getCommand(), reportSearchPath, this.queryParameters);
            is = this.processResults(rRequest, rRequest.getResult());
            if (overallTimer != null) {
                this.logger.stopTimer(overallTimer);
            }
        }
        catch (RepositoryAPIException e) {
            throw new AtomException(e.getKey(), e.copyArgs(), e);
        }
        catch (InvalidCredentialsFault e) {
            throw new AtomException("atomfeed.request.failed", e);
        }
        return is;
    }

    private XTSRepositoryRequest sendRequest(XTSEnvironment xtsEnv, BIBusEnvelope busEnv, String command, String reportSearchPath, QueryParameters queryParameters) throws RepositoryAPIException, AtomException {
        Object overallTimer = null;
        if (this.logger != null && this.logger.isPerfLevelEnabled(0)) {
            overallTimer = this.logger.startTimer(0, "sendRequest", "Request Time", null);
        }
        PluginResourceLoader aLoader = new PluginResourceLoader(this.atomEnv);
        XTSRepositoryConnection rConnection = new XTSRepositoryConnection((IPluginResourceLoader)aLoader, xtsEnv, busEnv, reportSearchPath);
        XTSRepositoryRequest rRequest = new XTSRepositoryRequest(rConnection, this.atomEnv.getGatewayURI());
        String userTenantID = this.getTenantID(this.ecmHandler.getAtomEnvironment().getPassportCookie(), this.ecmHandler.getAtomEnvironment().getProperty("cmRestURL").toString());
        rRequest = new XTSRepositoryRequest(rConnection, this.gateway);
        rRequest.executeRepositoryRequest(command, "dummyReturnType", 0, (IQueryParameters)queryParameters, userTenantID);
        if (overallTimer != null) {
            this.logger.stopTimer(overallTimer);
        }
        return rRequest;
    }

    protected InputStream processResults(XTSRepositoryRequest rRequest, IQueryResultObjects rResults) throws AtomException {
        try {
            int nIteratorCount;
            Object overallTimer = null;
            if (this.logger != null && this.logger.isPerfLevelEnabled(0)) {
                overallTimer = this.logger.startTimer(0, "writeAtomFeed", "Response Time", null);
            }
            this.atomEnv.setResponseContentType("application/atom+xml");
            this.atomEnv.setResponseStatus(200);
            XMLStreamWriter xwr = XMLStreamFactory.createXMLStreamWriter((Writer)this.output);
            Feed feed = new Feed();
            this.writeFeedHeader(feed, rRequest, rResults);
            int count = 0;
            int nResultSize = rResults != null ? rResults.size() : 0;
            int nRequestedCount = (Integer)this.queryParameters.getParameter("maxCount").getValue();
            int n = nIteratorCount = nResultSize < nRequestedCount ? nResultSize : nRequestedCount - 1;
            if (rResults != null) {
                while (rResults.next()) {
                    Entry entry = new Entry();
                    this.writeEntryContent(entry, rRequest, rResults);
                    for (int index = 0; index < this.queryProperties.size(); ++index) {
                        String propName = this.queryProperties.get(index);
                        String propValue = XTSRepositoryRequest.getQueryResultString((Object)rResults.getPropertyValue(propName));
                        this.writeCMExtension(entry, propName, propValue);
                        if (!propName.equals(ECM_PROP_BURSTKEY)) continue;
                        this.writeCMExtension(entry, ECM_PROP_BURSTKEY_DISPLAY, propValue);
                    }
                    feed.addEntry(entry);
                    if (++count < nIteratorCount) continue;
                    break;
                }
            }
            int nStartIndex = 0;
            if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_STARTINDEX) != null) {
                nStartIndex = Integer.parseInt(this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_STARTINDEX));
            }
            this.writeOpenSearchInfo(feed, nIteratorCount, nStartIndex);
            feed.write(xwr);
            xwr.flush();
            xwr.close();
            if (overallTimer != null) {
                this.logger.stopTimer(overallTimer);
            }
            this.output.flush();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.output.getBuffer().toString().getBytes("utf-8"));
            return bais;
        }
        catch (Exception e) {
            throw new AtomException("atomfeed.buildresponse.failed", e);
        }
    }

    protected Link createLink(String rel, String type, String href) {
        Link link = new Link();
        link.setRel(rel);
        link.setType(type);
        link.setHref(href);
        return link;
    }

    protected void writeDate(Entry entry, String dateType, String dateTimeString) throws ParseException {
        if (dateTimeString == null || "".equals(dateTimeString)) {
            return;
        }
        Date atomDate = new Date();
        java.util.Date date = QueryParameter.createDateFormatter().parse(dateTimeString);
        Calendar parmDate = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        parmDate.setTimeInMillis(date.getTime());
        atomDate.setValue(parmDate);
        if ("published".equals(dateType)) {
            entry.setPublished(atomDate);
        } else if ("updated".equals(dateType)) {
            entry.setUpdated(atomDate);
        }
    }

    protected void writeSummary(Entry entry, String description, String lang) {
        Text summary = new Text();
        summary.setValue(description);
        summary.setLang(lang);
        entry.setSummary(summary);
    }

    protected void writeFeedHeaderCommonInfo(Feed feed, String titleString, String titleLang, String idString) {
        Person author = new Person();
        author.setName("None");
        feed.addAuthor(author);
        Person contributor = new Person();
        contributor.setName("None");
        feed.addContributor(contributor);
        Text title = new Text();
        title.setValue(titleString);
        feed.setTitle(title);
        title.setLang(titleLang);
        Id id = new Id();
        id.setValue(ATOM_ID_PREFIX + idString);
        feed.setId(id);
    }

    protected void writeEntryId(Entry entry, String value) {
        Id id = new Id();
        id.setValue(ATOM_ID_PREFIX + value);
        entry.setId(id);
    }

    protected void writeEntryTitle(Entry entry, String value, String lang) {
        Text title = new Text();
        title.setLang(lang);
        title.setValue(value);
        entry.setTitle(title);
    }

    protected void writeEntryLink(Entry entry, String rel, String type, String href) {
        entry.addLink(this.createLink(rel, type, href));
    }

    protected void writeIcon(Entry entry, String rel, String type, String href) {
        Icon icon = new Icon();
        icon.setRel(rel);
        icon.setType(type);
        icon.setHref(href);
        entry.addIcon(icon);
    }

    protected void writeCMExtension(Entry atomEntry, String cmPropertyName, String cmPropertyValue) throws XMLStreamException, UnsupportedEncodingException {
        StringBuilder extensions = new StringBuilder();
        extensions.append("<cm:");
        extensions.append(cmPropertyName);
        extensions.append(" " + NS_CM + ">");
        StringBuffer out = new StringBuffer();
        EncodingUtils.xmlEncode((String)cmPropertyValue, (StringBuffer)out);
        extensions.append(out.toString());
        extensions.append("</cm:" + cmPropertyName + ">");
        AnyElement anAny = new AnyElement();
        ByteArrayInputStream in = new ByteArrayInputStream(extensions.toString().getBytes("UTF-8"));
        anAny.read(XMLStreamFactory.createXMLStreamReader((Reader)new InputStreamReader(in)));
        atomEntry.addValue13(anAny);
    }

    protected void writeLinks(Feed feed, IQueryResultObjects results, String parentHref, Parameters otherParams) throws XMLStreamException {
        String connectionTenantID;
        String maxObjs;
        int nResultSize;
        int n = nResultSize = results != null ? results.size() : 0;
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_RESPONSETYPE_JSON) != null) {
            otherParams.add(ATOM_REQUEST_RESPONSETYPE_JSON, "");
        }
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_STARTINDEX) != null) {
            otherParams.add(ATOM_REQUEST_STARTINDEX, this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_STARTINDEX));
        }
        if (this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_ENDINDEX) != null) {
            otherParams.add(ATOM_REQUEST_ENDINDEX, this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_ENDINDEX));
        }
        if ((maxObjs = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_MAXOBJS)) != null && !"".equals(maxObjs)) {
            otherParams.add(ATOM_REQUEST_MAXOBJS, maxObjs);
        }
        if ((connectionTenantID = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_CONNECTION_TENANTID)) != null) {
            otherParams.add(ATOM_REQUEST_CONNECTION_TENANTID, connectionTenantID);
        }
        int nStart = (Integer)this.queryParameters.getParameter("skipItems").getValue();
        int nMaxObjs = (Integer)this.queryParameters.getParameter("maxCount").getValue() - 1;
        int maxResults = this.getMaxResults();
        boolean hasMoreData = nMaxObjs < nResultSize;
        String escapedTargetPath = this.escapePath(this.getTarget());
        if (hasMoreData) {
            String nextPageHref = escapedTargetPath + "?" + otherParams.toString(PAGINATION_PARAM_EXCLUDE);
            nextPageHref = nextPageHref + "&startindex=" + (nStart + nMaxObjs);
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_NEXT, "application/atom+xml", nextPageHref));
        }
        if (nStart > 0) {
            int startIndex = nStart - maxResults;
            String previousPageHref = escapedTargetPath + "?" + otherParams.toString(PAGINATION_PARAM_EXCLUDE);
            previousPageHref = previousPageHref + "&startindex=" + (startIndex > 0 ? startIndex : 0);
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_PREVIOUS, "application/atom+xml", previousPageHref));
        }
        if (nStart > 0) {
            String firstPageHref = escapedTargetPath + "?" + otherParams.toString(PAGINATION_PARAM_EXCLUDE) + "&startindex=0";
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_FIRST, "application/atom+xml", firstPageHref));
        }
        boolean lastPageSupported = false;
        if (hasMoreData && lastPageSupported) {
            String lastPageHref = escapedTargetPath + "?" + otherParams.toString(PAGINATION_PARAM_EXCLUDE) + "&startindex=-" + String.valueOf(maxResults);
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_LAST, "application/atom+xml", lastPageHref));
        }
        String selfHref = escapedTargetPath;
        selfHref = selfHref + "?" + this.ecmHandler.getRequestRestParameters().toString();
        feed.addLink(this.createLink(ATOM_REQUEST_LINK_SELF, "application/atom+xml", selfHref));
        if (parentHref != null) {
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_PARENT, "application/atom+xml", parentHref));
        }
        if (this.isSupportingLink(ATOM_REQUEST_LINK_GOTO)) {
            String gotoHref = escapedTargetPath + "?" + otherParams.toString(PAGINATION_PARAM_EXCLUDE);
            gotoHref = gotoHref + "&" + ATOM_REQUEST_STARTINDEX + "=$" + ATOM_REQUEST_STARTINDEX;
            gotoHref = gotoHref + "&" + ATOM_REQUEST_ENDINDEX + "=$" + ATOM_REQUEST_ENDINDEX;
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_GOTO, "application/atom+xml", gotoHref));
        }
        if (this.isSupportingLink(ATOM_REQUEST_LINK_SORT)) {
            String sortHref = escapedTargetPath + "?" + otherParams.toString(SORT_PARAM_EXCLUDE);
            sortHref = sortHref + "&" + ATOM_REQUEST_SORT_SORTFIELDS + "=$" + ATOM_REQUEST_SORT_SORTFIELDS;
            sortHref = sortHref + "&" + ATOM_REQUEST_SORT_SORTORDER + "=$" + ATOM_REQUEST_SORT_SORTORDER;
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_SORT, "application/atom+xml", sortHref));
        }
        if (this.isSupportingLink(ATOM_REQUEST_LINK_DATESELECTION)) {
            String dateSelectionHref = escapedTargetPath + "?" + otherParams.toString(DATA_SELECTION_PARAM_EXCLUDE);
            dateSelectionHref = dateSelectionHref + "&" + ATOM_REQUEST_DATE_BEFORE + "=$" + ATOM_REQUEST_DATE_BEFORE;
            dateSelectionHref = dateSelectionHref + "&" + ATOM_REQUEST_DATE_AFTER + "=$" + ATOM_REQUEST_DATE_AFTER;
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_DATESELECTION, "application/atom+xml", dateSelectionHref));
        }
        if (this.isSupportingLink(ATOM_REQUEST_LINK_LOCALESELECTION)) {
            String localeSelectionHref = escapedTargetPath + "?" + otherParams.toString(LOCALE_SELECTION_PARAM_EXCLUDE);
            localeSelectionHref = localeSelectionHref + "&" + ATOM_REQUEST_LOCALE + "=$" + ATOM_REQUEST_LOCALE;
            feed.addLink(this.createLink(ATOM_REQUEST_LINK_LOCALESELECTION, "application/atom+xml", localeSelectionHref));
        }
    }

    private String escapePath(String path) {
        String newPath = path.replace("$", "%24");
        return newPath;
    }

    protected boolean isSupportingLink(String linkType) {
        return false;
    }

    protected abstract void writeFeedHeader(Feed var1, XTSRepositoryRequest var2, IQueryResultObjects var3) throws XMLStreamException;

    protected abstract void writeEntryContent(Entry var1, XTSRepositoryRequest var2, IQueryResultObjects var3) throws XMLStreamException, ParseException, Exception;

    private void writeOpenSearchInfo(Feed feed, int nIteratorCount, int nStartIndex) throws XMLStreamException {
        StringBuilder totalResults = new StringBuilder();
        totalResults.append("<opensearch:totalResults xmlns:opensearch=\"http://a9.com/-/spec/opensearch/1.1/\">");
        totalResults.append(nIteratorCount);
        totalResults.append("</opensearch:totalResults>");
        AnyElement totalResultsAE = new AnyElement();
        totalResultsAE.read(XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(totalResults.toString())));
        feed.addValue14(totalResultsAE);
        StringBuilder startIndex = new StringBuilder();
        startIndex.append("<opensearch:startIndex xmlns:opensearch=\"http://a9.com/-/spec/opensearch/1.1/\">");
        startIndex.append(nStartIndex);
        startIndex.append("</opensearch:startIndex>");
        AnyElement startIndexAE = new AnyElement();
        startIndexAE.read(XMLStreamFactory.createXMLStreamReader((Reader)new StringReader(startIndex.toString())));
        feed.addValue14(startIndexAE);
    }

    protected void buildRequestPaginationParams(QueryParameters queryParameters) throws AtomException, RepositoryAPIException {
        String start = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_STARTINDEX);
        if (start == null || ("$" + ATOM_REQUEST_STARTINDEX).equals(start)) {
            start = "0";
        }
        int maxResults = this.getMaxResults();
        String end = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_ENDINDEX);
        if ("".equals(end)) {
            end = null;
        }
        if (end != null && !("$" + ATOM_REQUEST_ENDINDEX).equals(end)) {
            int nEnd;
            int nStart = Integer.parseInt(start);
            if (nStart > (nEnd = Integer.parseInt(end))) {
                throw new AtomParseException("atomfeed.request.parseerror.goto");
            }
            maxResults = nEnd - nStart + 1;
        }
        queryParameters.put((IQueryParameter)new QueryParameter("skipItems", (Object)start, "INTEGER"));
        queryParameters.put((IQueryParameter)new QueryParameter("maxCount", (Object)String.valueOf(maxResults + 1), "INTEGER"));
    }

    private int getMaxResults() {
        String maxObjs = this.ecmHandler.getRequestRestParameters().getValue(ATOM_REQUEST_MAXOBJS);
        if (maxObjs == null || "".equals(maxObjs)) {
            maxObjs = this.getDefaultLinesPerPage();
        }
        return Integer.parseInt(maxObjs);
    }

    protected String getTarget() {
        return this.gateway + "/atom" + this.atomEnv.getTarget();
    }

    protected String getDefaultLinesPerPage() {
        String lpp = this.atomEnv.getEnvelope().getUserPreferenceValue("linesPerPage");
        if (lpp == null || "".equals(lpp)) {
            lpp = DEFAULT_LINES_PER_PAGE;
        }
        return lpp;
    }

    private String getTenantID(String camPassportValue, String cmURL) throws AtomException {
        try {
            HttpCommandFactory factory = this.getHttpCommandFactory(cmURL);
            Cookie camPassport = new Cookie("cam_passport", camPassportValue);
            HttpCommand command = factory.getCommand(camPassport, TENANT_REQUEST);
            int responseCode = command.execute();
            if (200 == responseCode) {
                JSONArray response = JSONArray.parse((String)command.getResponseBody());
                return response.get(0).toString();
            }
            if (401 == responseCode) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error("ECM  op: error retrieving tenant id, return code was=" + responseCode);
                }
                throw new InvalidCredentialsFault("atomfeed.request.failed", null, null);
            }
            throw new AtomException("atomfeed.request.failed");
        }
        catch (IOException e) {
            throw new AtomException("atomfeed.request.failed", e);
        }
        catch (CAMCryptoException e) {
            throw new AtomException("atomfeed.request.failed", e);
        }
    }

    protected HttpCommandFactory getHttpCommandFactory(String cmURL) {
        HttpClientFactory factory = HttpClientFactoryProvider.getInstance();
        HttpMethodFactory cmMethodFactory = factory.getHttpMethodFactory(cmURL);
        return new HttpCommandFactory(cmMethodFactory);
    }
}

