/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.service;

import com.cognos.atom.request.AtomException;
import com.cognos.atom.request.AtomProcessor;
import com.cognos.atom.service.AtomEnvironment;
import com.cognos.atom.service.ResourceLoaderImpl;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cps.bseries.xts.request.nav.NavSystem;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.BIBusEnvelopeUtils;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import com.cognos.portal.soap.impl.BusConnectionImpl;
import com.cognos.portal.soap.impl.SOAPConnectionFactoryImpl;
import com.cognos.portal.soap.impl.TrustedSOAPConnectionFactoryImpl;
import com.cognos.portal.utils.ContextImpl;
import com.cognos.portal.utils.IContext;
import com.cognos.portal.utils.ReadWriteLock;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class AtomService
extends BasicHandler {
    private static final Logger category = Hierarchy.getDefaultHierarchy().getLoggerFor(AtomService.class.getName());
    private ICCLConfiguration cclConfiguration;
    private AtomProcessor atomProcessor;
    private IContext context;
    private ServiceLogger logger = new ServiceLoggerImpl(AtomService.class);
    private PogoEngine engine;
    private Exception initializeException = null;
    private static ReadWriteLock mutex = new ReadWriteLock();
    private static final String CM_REST_PREFIX = "/cm";
    private static final String CM_SERVLET_PREFIX = "/servlet";

    public AtomService() {
        super(category);
    }

    public AtomService(Logger logger) {
        super(logger);
    }

    public void initialize() {
        try {
            this.atomProcessor = new AtomProcessor(this.logger);
            this.atomProcessor.init(this.context);
        }
        catch (AtomException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("cannot initialize atom processor", (Throwable)((Object)e));
            }
            this.initializeException = e;
        }
    }

    public void dispose() {
        block9: {
            try {
                mutex.acquireWriteLock();
                try {
                    if (this.atomProcessor != null) {
                        this.atomProcessor.terminate();
                    }
                    this.atomProcessor = null;
                }
                catch (AtomException e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("cannot terminate atom processor", (Throwable)((Object)e));
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block9;
                this.logger.error("an exception was encountered when attempting acquire write lock to terminate the atom service", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration config) {
        block9: {
            try {
                mutex.acquireWriteLock();
                try {
                    this.cclConfiguration = config.getICCLConfiguration();
                    this.context = new ContextImpl();
                    String application = this.getRequiredAttribute(category, "application");
                    this.context.setProperty("application.path", (Object)"com/cognos/atom/request");
                    this.context.setProperty("application", (Object)application);
                    this.context.setProperty("dispatcherPath", (Object)new URL(this.cclConfiguration.getValue("internalDispatcher", true)).getFile());
                    this.context.setProperty("internalDispatcher", (Object)BusConnectionImpl.BUS_DISPATCHER);
                    String activeCMURL = this.cclConfiguration.getValue("contentManager", true);
                    String cmRESTURL = activeCMURL.replaceFirst(CM_SERVLET_PREFIX, CM_REST_PREFIX);
                    this.context.setProperty("cmPath", (Object)new URL(activeCMURL).getFile());
                    this.context.setProperty("cmRestURL", (Object)cmRESTURL);
                    this.context.setProperty("contentManager", (Object)BusConnectionImpl.BUS_CM);
                    this.context.setProperty("popoEngine", (Object)this.engine);
                    this.context.setProperty("SoapConnectionFactory", (Object)new SOAPConnectionFactoryImpl(this.context));
                    this.context.setProperty("trustedSoapConnectionFactory", (Object)new TrustedSOAPConnectionFactoryImpl(this.context, "CPS"));
                    this.context.setProperty("consumerTrustedSoapConnectionFactory", (Object)new TrustedSOAPConnectionFactoryImpl(this.context, "CPSConsumer"));
                    ResourceLoaderImpl resourceLoader = new ResourceLoaderImpl(this.engine, "com/cognos/atom/request");
                    this.context.setProperty("resourceLoader", (Object)resourceLoader);
                    this.context.setProperty("logdir", (Object)this.cclConfiguration.resolveEffectivePath("../logs"));
                    if (this.atomProcessor != null) {
                        this.atomProcessor.init(this.context);
                    }
                }
                catch (Throwable e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("an exception was encountered when attempting to configure the atom service", e);
                    }
                }
                finally {
                    mutex.releaseWriteLock();
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null || !this.logger.isErrorEnabled()) break block9;
                this.logger.error("an exception was encountered when attempting acquire write lock to configure the atom service", (Throwable)e);
            }
        }
    }

    public void reconfigure(Configuration config) {
        this.configure(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        try {
            mutex.acquireReadLock();
            try {
                ServiceLoggerImpl.setRequestId((String)mc.getStrProperty("requestID"));
                ServiceLoggerImpl.setSessionId((String)mc.getStrProperty("auth.passportid"));
                Object overallTimer = null;
                if (this.logger.isPerfLevelEnabled(0)) {
                    overallTimer = this.logger.startTimer(0, "invokeImpl", "Request Time", null);
                }
                try {
                    if (!NavSystem.getInstance().isInitialized()) {
                        this.initializeNAV();
                    }
                    AtomEnvironment env = new AtomEnvironment(mc, this.context, this.logger);
                    SharedByteArrayOutputStream out = new SharedByteArrayOutputStream(4096);
                    env.setOutputStream((OutputStream)out);
                    if (this.initializeException != null) {
                        throw this.initializeException;
                    }
                    InputStream result = this.atomProcessor.process(env);
                    BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
                    BIBusEnvelope responseEnvelope = new BIBusEnvelope();
                    responseEnvelope.setBIBusHeader(requestEnvelope.getBIBusHeader().createCopy());
                    BIBusEnvelopeUtils.copyNamespacesTo((BIBusEnvelope)requestEnvelope, (BIBusEnvelope)responseEnvelope);
                    mc.setResponseName("response");
                    mc.setProperty("response.envelope", (Object)responseEnvelope);
                    mc.setProperty("response.status_code", (Object)Integer.toString(env.getResponseStatus()));
                    String header = "Content-Type: " + env.getResponseContentType() + "\r\n\r\n";
                    InputStream inStream = result != null ? new SequenceInputStream(new ByteArrayInputStream(header.getBytes()), result) : new ByteArrayInputStream(header.getBytes());
                    ArrayList<ByteArrayInputStream> attachments = new ArrayList<ByteArrayInputStream>();
                    attachments.add((ByteArrayInputStream)inStream);
                    mc.setProperty("response.attachments", attachments.iterator());
                    mc.setProperty("response.boundary", (Object)"---=_MIME_BOUNDARY_Q739K9UU82UDLK73");
                }
                catch (Exception e) {
                    if (this.logger != null && this.logger.isErrorEnabled()) {
                        this.logger.error("Failed to handle atom request", (Throwable)e);
                    }
                    throw new PogoException("Failed to handle atom request", e);
                }
                if (overallTimer != null) {
                    this.logger.stopTimer(overallTimer);
                }
            }
            finally {
                mutex.releaseReadLock();
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an exception was encountered when attempting acquire read lock to handle request", (Throwable)e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        try {
            mutex.acquireWriteLock();
            try {
                this.engine = engine;
                super.compose_impl(engine);
            }
            finally {
                mutex.releaseWriteLock();
            }
        }
        catch (InterruptedException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("an exception was encountered when attempting acquire write lock to compose the atom service", (Throwable)e);
            }
            throw new PogoException(e.getMessage());
        }
    }

    private void initializeNAV() throws Exception {
        NavSystem.getInstance().initialize();
    }
}

