/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.utils;

import com.cognos.atom.request.AtomParseException;
import com.cognos.atom.request.InsufficientPrivilegeFault;
import com.cognos.cps.services.pagelet.objects.v1.types.Fault;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.soap.SOAPFault;
import com.cognos.portal.utils.LocalizableException;
import com.cognos.portal.utils.LocalizableRuntimeException;
import com.cognos.portal.utils.exceptions.InvalidCredentialsFault;
import com.cognos.xts.XTSException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ErrorUtils {
    public static void writeError(Environment env, Throwable exception, XMLStreamWriter xsw, ServiceLogger logger) throws XMLStreamException {
        env.setResponseStatus(500);
        env.setResponseContentType("text/html");
        Throwable rootCause = ErrorUtils.getRootCause(exception);
        boolean isInvalidCredentialException = ErrorUtils.isInvalidCredentialError(rootCause);
        boolean isCMError = ErrorUtils.isCMError(rootCause);
        if (isCMError) {
            env.setResponseStatus(404);
        } else if (exception instanceof AtomParseException) {
            env.setResponseStatus(400);
        }
        String code = ErrorUtils.getErrorCode(rootCause);
        StringWriter details = new StringWriter();
        PrintWriter pw = new PrintWriter(details);
        exception.printStackTrace(pw);
        xsw.writeStartDocument();
        xsw.writeStartElement("error");
        xsw.writeStartElement("code");
        xsw.writeCharacters(code);
        xsw.writeEndElement();
        xsw.writeStartElement("message");
        if (exception.getLocalizedMessage() != null) {
            xsw.writeCharacters(exception.getLocalizedMessage());
        } else if (exception.getMessage() != null) {
            xsw.writeCharacters(exception.getMessage());
        }
        xsw.writeEndElement();
        xsw.writeStartElement("details");
        String padding = new String(new char[512]).replace("\u0000", " ");
        xsw.writeCharacters("Error in XTS processing" + padding);
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndDocument();
        xsw.flush();
        if (logger != null && logger.isErrorEnabled()) {
            logger.error(details.getBuffer().toString());
        }
    }

    private static boolean isInvalidCredentialError(Throwable e) {
        if (e instanceof SOAPFault) {
            String faultString = ((SOAPFault)e).getFaultString();
            return faultString != null ? faultString.indexOf("InvalidCredentials") != -1 : false;
        }
        return e instanceof InvalidCredentialsFault;
    }

    private static boolean isCMError(Throwable e) {
        if (e instanceof SOAPFault) {
            String faultString = ((SOAPFault)e).getFaultString();
            return faultString != null ? faultString.startsWith("CM-") : false;
        }
        return false;
    }

    private static String getErrorCode(Throwable rc) {
        String code = "";
        if (rc != null) {
            if (rc instanceof InvalidCredentialsFault) {
                code = "camAuthUserRecoverable";
            } else if (rc instanceof SOAPFault) {
                code = ((SOAPFault)rc).getFaultCode().getLocalPart();
            } else if (rc instanceof XTSException) {
                code = ((XTSException)rc).getKey();
            } else if (rc instanceof InsufficientPrivilegeFault) {
                code = "InsufficientPrivilegeFault";
            } else {
                code = rc.getClass().getName();
                int index = code.lastIndexOf(46);
                if (index != -1) {
                    code = code.substring(index + 1);
                }
            }
        }
        return code;
    }

    private static Throwable getRootCause(Throwable t) {
        XTSException xtsEx;
        if (t instanceof InvalidCredentialsFault) {
            return t;
        }
        if (t instanceof SOAPFault) {
            return t;
        }
        if (t instanceof LocalizableException) {
            LocalizableException locEx = (LocalizableException)t;
            if (locEx.getRootCause() != null) {
                return ErrorUtils.getRootCause(locEx.getRootCause());
            }
        } else if (t instanceof LocalizableRuntimeException) {
            LocalizableRuntimeException locEx = (LocalizableRuntimeException)t;
            if (locEx.getRootCause() != null) {
                return ErrorUtils.getRootCause(locEx.getRootCause());
            }
        } else if (t instanceof Fault) {
            Fault cpsEx = (Fault)t;
            if (cpsEx.getRootCause() != null) {
                return ErrorUtils.getRootCause(cpsEx.getRootCause());
            }
        } else if (t instanceof XTSException && (xtsEx = (XTSException)t).getDetail() != null) {
            return ErrorUtils.getRootCause(xtsEx.getDetail());
        }
        return t;
    }
}

