/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.atom.utils;

import com.cognos.atom.request.AtomException;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.XSLTFactory;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jd.xml.util.XmlSource;
import jd.xml.xslt.Stylesheet;
import jd.xml.xslt.XsltResult;

public abstract class JSONUtils {
    public static InputStream transformToJSON(InputStream inputXML, ServiceLogger logger) throws AtomException {
        try {
            Object overallTimer = null;
            if (logger != null && logger.isPerfLevelEnabled(0)) {
                overallTimer = logger.startTimer(0, "transformToJSON", "Transform Time", null);
            }
            String atom2jsonFN = "com/cognos/atom/utils/atom2json.xslt";
            if (overallTimer != null) {
                logger.stopTimer(overallTimer);
            }
            SharedByteArrayOutputStream result = new SharedByteArrayOutputStream(4096);
            Stylesheet ss = XSLTFactory.getInstance().getStylesheet(atom2jsonFN, null);
            ss.setParameter("tagsAsStrings", (Object)",burstKeyDisplayString,");
            XmlSource xmlSource = new XmlSource("", inputXML, true);
            XsltResult xsltResult = new XsltResult("", (OutputStream)result, false);
            ss.transform(xmlSource, xsltResult);
            if (overallTimer != null) {
                logger.stopTimer(overallTimer);
            }
            return result.toStream();
        }
        catch (Exception e) {
            throw new AtomException("atomfeed.transform.json", e);
        }
    }

    public static InputStream transformToJSON(String inputXML, ServiceLogger logger) throws AtomException {
        try {
            return JSONUtils.transformToJSON(new ByteArrayInputStream(inputXML.getBytes("UTF-8")), logger);
        }
        catch (Exception e) {
            throw new AtomException("atomfeed.transform.json", e);
        }
    }
}

