<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2014

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
	Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
	Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
   -->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:bus="http://developer.cognos.com/schemas/bibus/3/"
	xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/"
	xmlns:encodingUtils="com.cognos.portal.utils.EncodingUtils">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>
	
	<xsl:variable name="busHeader" select="/root/bus:biBusHeader"/>
	<xsl:variable name="http-env" select="$busHeader/*[local-name()='hdrSession']/*[local-name()='environmentVars']"/>
	<xsl:variable name="pathInfo" select="$http-env/item[name='PATH_INFO']/value"/>
	<xsl:variable name="webContent" select="$http-env/item[name='WEB_CONTENT_ROOT']/value"/>
	<xsl:variable name="gateway" select="$http-env/item[name='SCRIPT_NAME']/value"/>
	
	<xsl:variable name="parameters" select="/root/parameters/param"/>
	<xsl:variable name="soapAction">
		<xsl:choose>
			<xsl:when test="string($busHeader/bus:dispatcherTransportVars/item[name='originalSOAPAction']/value) != ''">
				<xsl:value-of select="$busHeader/bus:dispatcherTransportVars/item[name='originalSOAPAction']/value"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'atom'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="is-toplevel-request" select="$pathInfo = concat('/', $soapAction)"/>
	<xsl:variable name="filter" select="string($parameters[@name='filter'])"/>
	<xsl:variable name="searchText" select="string($parameters[@name='searchText'])"/>
	<xsl:variable name="locale" select="string($parameters[@name='locale'])"/>
	<xsl:variable name="sortfields" select="string($parameters[@name='sortfields'])"/>
	<xsl:variable name="sortorder" select="string($parameters[@name='sortorder'])"/>
	
	<xsl:template match="/">
		<xsl:variable name="specified-path">
			<xsl:call-template name="buildPath">
				<xsl:with-param name="pathInfo" select="$pathInfo"/>
				<xsl:with-param name="soapAction" select="$soapAction"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="nav-path">
			<xsl:choose>
				<xsl:when test="$specified-path != ''"><xsl:value-of select="$specified-path"/></xsl:when>
				<xsl:otherwise>/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="nav-path-children">
			<xsl:choose>
				<xsl:when test="$specified-path != ''">
					<xsl:text/><xsl:value-of select="$nav-path"/>/*<xsl:text/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text/>/content | ~/folder<xsl:text/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<SOAP-ENV:Envelope 
			xmlns:bus="http://developer.cognos.com/schemas/bibus/3/" 
			xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/" 
			xmlns:xsd="http://www.w3.org/2001/XMLSchema" 
			xmlns:SOAP-ENC="http://schemas.xmlsoap.org/soap/encoding/" 
			xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" 
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
			xmlns:xs="http://www.w3.org/2001/XMLSchema">
			<SOAP-ENV:Header>
				<xsl:copy-of select="/root/bus:biBusHeader"/>
			</SOAP-ENV:Header>
			<SOAP-ENV:Body>
				<nav:request>
					<nav:queries>
						<xsl:if test="$nav-path != ''">
							<nav:query>
								<nav:getItem>
									<nav:recursive>false</nav:recursive>
									<nav:id>
										<xsl:text/>path:<xsl:value-of select="$nav-path"/><xsl:text/>
									</nav:id>
									<xsl:call-template name="object-properties"/>
								</nav:getItem>
							</nav:query>
							<xsl:if test="$nav-path-children != ''">
								<nav:query>
									<nav:search>
									
										<xsl:choose>
										<xsl:when test="$searchText">
											<nav:string><xsl:value-of select="$searchText"/></nav:string>
											<nav:scope>
												<xsl:text/><xsl:value-of select="$nav-path"/><xsl:text/>
												<xsl:call-template name="build-filter"/>
											</nav:scope>
										
										</xsl:when>
										<xsl:otherwise>
											<nav:scope>
												<xsl:text/>path:<xsl:value-of select="$nav-path-children"/><xsl:text/>
												<xsl:call-template name="build-filter"/>
											</nav:scope>
										</xsl:otherwise>	
										</xsl:choose>	
										
										
										<xsl:call-template name="object-properties"/>
										<xsl:call-template name="build-pagination-params"/>
										<xsl:call-template name="build-sort"/>
										<xsl:call-template name="build-extra-params"/>
										
										<nav:property name="action"/>
										<nav:property name="actionsURL"/>
										<nav:property name="formatName"/>
									</nav:search>
								</nav:query>
							</xsl:if>
						</xsl:if>
					</nav:queries>
					
					<!-- nav options -->
					<nav:param name="gatewayURL"><xsl:value-of select="$gateway"/></nav:param>
					<nav:param name="webContentURL"><xsl:value-of select="$webContent"/></nav:param>
					<nav:validateTag fault="true"/>
					<nav:param name="browserAgent">
						<xsl:variable name="user-agent" select="string($http-env/item[name='HTTP_USER_AGENT']/value)"/>
						<xsl:choose>
							<xsl:when test="contains($user-agent , 'MSIE')">ie</xsl:when>		<!-- IE 4.xx and above -->
							<xsl:when test="contains($user-agent , 'Safari')">safari</xsl:when>
							<xsl:when test="contains($user-agent , 'Mozilla/5.0')">
								<xsl:choose>
									<xsl:when test="contains($user-agent , 'Netscape/7.1')">ns71</xsl:when>
									<xsl:when test="contains($user-agent , 'Netscape/7.0')">ns70</xsl:when>
									<xsl:when test="contains($user-agent , 'AOL/7.0')">ns70</xsl:when>
									<xsl:when test="contains($user-agent , 'CS 2000 7.0/7.0')">ns70</xsl:when>
									<xsl:when test="contains($user-agent , 'Netscape6')">ns6</xsl:when>
									<xsl:otherwise>moz</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="contains($user-agent , 'Mozilla/4.')">ns4</xsl:when>	<!-- NS 4.xx -->
							<xsl:otherwise>other</xsl:otherwise>
						</xsl:choose>
					</nav:param>
				</nav:request>
			</SOAP-ENV:Body>
		</SOAP-ENV:Envelope>
	</xsl:template>
	
	<xsl:template name="build-filter">
		<!-- Handle locale filter -->
		<xsl:if test="$locale != '' and $locale != '$locale'">
			<xsl:text/>[@locale = '<xsl:value-of select="$locale"/>']<xsl:text/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="build-sort">

		<xsl:choose>
			<xsl:when test="$filter = 'content-version'">
				<xsl:variable name="sortspecs">
					<xsl:if test="$sortfields != '$sortfield'">
						<xsl:choose>
							<xsl:when test="$sortfields = 'name'">
								<xsl:variable name="order">
									<xsl:choose>
										<xsl:when test="$sortorder = '0' and $sortorder != '$sortorder'"><xsl:text>ascending</xsl:text></xsl:when>
										<xsl:otherwise><xsl:text>descending</xsl:text></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<nav:sort order="{$order}">name</nav:sort>
							</xsl:when>
						</xsl:choose>
					</xsl:if>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$sortspecs/*">
						<xsl:copy-of select="$sortspecs"/>
					</xsl:when>
					<xsl:otherwise>
						<nav:sort order="descending">name</nav:sort>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$filter = 'content-output'">
				<nav:sort order="ascending">burstKey</nav:sort>
				<nav:sort order="ascending">locale</nav:sort>
			</xsl:when>
			<xsl:otherwise>				
				<xsl:if test="$sortfields != '$sortfields'">
					<xsl:variable name="order">
						<xsl:choose>
							<xsl:when test="$sortorder = '0'"><xsl:text>ascending</xsl:text></xsl:when>
							<xsl:when test="$sortorder = '1'"><xsl:text>descending</xsl:text></xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:if test="not($order = '')">
						<nav:sort order="{$order}"><xsl:value-of select="$sortfields"/></nav:sort>
					</xsl:if>						
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="build-extra-params">
		<nav:param name="documentType"><xsl:value-of select="$parameters[@name='documentType']"/></nav:param>
		<nav:param name="documentName"><xsl:value-of select="$parameters[@name='documentName']"/></nav:param>
		<nav:param name="containingClass"><xsl:value-of select="$parameters[@name='containingClass']"/></nav:param>
		<nav:param name="filter"><xsl:value-of select="$parameters[@name='filter']"/></nav:param>
		<nav:param name="download"/>
	</xsl:template>
	
	<xsl:template name="object-properties">
		<nav:property name="screenTip"/>
		<nav:property name="icons"/>
		<nav:property name="description"/>
		<nav:property name="parentId"/>
		<nav:property name="creationTime"/>
		<nav:property name="modificationTime"/>
		<nav:property name="asOfDate"/>
		<nav:property name="ancestors"/>
		
		<xsl:choose>
			<xsl:when test="$searchText">
				<nav:property name="fullName"/>
			</xsl:when>
			<xsl:otherwise>
				<nav:property name="fullPath"/>
			</xsl:otherwise>
		</xsl:choose>
	
		
		<nav:property name="internalId"/>
		<nav:property name="searchPath"/>
		<nav:property name="position"/>
		<nav:property name="format"/>
		<nav:property name="documentType"/>
		<nav:property name="dataType"/>
		<nav:property name="burstKey"/>
		<nav:property name="locale"/>
		<nav:property name="portalPagesInfo"/>
	</xsl:template>
	
	<xsl:template name="build-pagination-params">
		<xsl:variable name="startindex" select="string($parameters[@name='startindex'])"/>
		<xsl:variable name="endindex" select="string($parameters[@name='endindex'])"/>
		<xsl:variable name="maxresults" select="string($parameters[@name='maxresults'])"/>
		
		<xsl:variable name="maxObjects">
			<xsl:choose>
				<xsl:when test="$startindex != '' and $endindex != '' and $startindex != '$startindex' and $endindex != '$endindex'">
					<xsl:value-of select="number($endindex) - number($startindex) + 1"/>
				</xsl:when>
				<xsl:when test="$maxresults != ''">
					<xsl:value-of select="$maxresults"/>
				</xsl:when>
				<xsl:when test="$busHeader/bus:userPreferenceVars/item[name='linesPerPage']/value">
					<xsl:value-of select="$busHeader/bus:userPreferenceVars/item[name='linesPerPage']/value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'15'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="skipObjects">
			<xsl:choose>
				<xsl:when test="$startindex != '' and $startindex != '$startindex'">
					<xsl:value-of select="$startindex"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'0'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<nav:maxObjects><xsl:value-of select="$maxObjects"/></nav:maxObjects>
		<nav:skipObjects><xsl:value-of select="$skipObjects"/></nav:skipObjects>
	</xsl:template>
	
	<!--
		Path syntax to retrieve content
			../cognos.cgi/atom/id/{id}	returns content of object pointed by object id {id}
			../cognos.cgi/atom/id/{id}/{objname}/../{objname} returns content of object pointed by object {id}/{objname}...
			../cognos.cgi/atom/path/{objname}/../{objname} returns content of object pointed {objname}/../{objname}
			../cognos.cgi/atom		returns Public folder and my folder
			../cognos.cgi/atom/~	returns content of my folder
	-->
	<xsl:template name="buildPath">
		<xsl:param name="pathInfo"/>
		<xsl:param name="soapAction"/>
			<!-- discard the leading 'service' part -->
			<xsl:variable name="path">
				<xsl:variable name="sa" select="concat('/', $soapAction, '/')"/>
				<xsl:choose>
					<xsl:when test="starts-with($pathInfo, $sa)">
						<xsl:value-of select="substring-after($pathInfo, $sa)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$pathInfo"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<!-- extract the 'type' part -->
			<xsl:variable name="type" select="substring-before($path, '/')"/>
			
			<xsl:call-template name="outputPath">
				<xsl:with-param name="path" select="substring-after($path, '/')"/>
				<xsl:with-param name="type" select="$type"/>
			</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="outputPath">
		<xsl:param name="path"/>
		<xsl:param name="type"/>

		<xsl:if test="$type='cm' or $type='id' or $type='path'">
			<xsl:variable name="name">
				<xsl:choose>
					<xsl:when test="$type='cm'">
						<xsl:value-of select="substring-after($pathInfo, '/id/')"/>
					</xsl:when>
					<xsl:when test="contains($path, '/')">
						<xsl:value-of select="substring-before($path, '/')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$path"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<xsl:choose>
				<xsl:when test="$type='cm'">
					<xsl:text/>storeID('<xsl:value-of select="$name"/>')<xsl:text/>
				</xsl:when>
				<xsl:when test="$type='id'">
					<xsl:text/>storeID('<xsl:value-of select="$name"/>')<xsl:text/>
				</xsl:when>
				<xsl:when test="$type='path'">
					<xsl:choose>
						<xsl:when test="$name = '~'">
							<xsl:text/>~/folder<xsl:text/>
						</xsl:when>
						<xsl:when test="$name = 'myfavorites'">
							<xsl:text/>~/favoritesFolder<xsl:text/>
						</xsl:when>
						<xsl:when test="$name = 'myaccount'">
							<xsl:text/>~<xsl:text/>
						</xsl:when>
						<xsl:when test="$name = 'mru'">
							<xsl:text/>~/mruFolder<xsl:text/>
						</xsl:when>
						<xsl:when test="$name = 'mysubscriptions'">
							<xsl:text/>~/subscriptionFolder<xsl:text/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text/>/*[@name='<xsl:text/><xsl:value-of select="$name"/>']<xsl:text/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
			
			<xsl:if test="$type='path'">
				<xsl:if test="contains($path, '/')">
					<xsl:call-template name="outputPath">
						<xsl:with-param name="path" select="substring-after($path, '/')"/>
						<xsl:with-param name="type" select="'path'"/> <!-- treated as 'path' from here on -->
					</xsl:call-template>
				</xsl:if>
			</xsl:if>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>












