<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2014

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
/*
 * $Header: //cps4/blacksea/main/src/java/src/com/cognos/portal/fragment/producer/xslt/fragment.xslt#3 $
 * $Change: 14470 $
 * $DateTime: 2006/06/13 10:43:22 $
 *
 * Copyright (C) 2008 Cognos ULC, an IBM Company.
 * 3755 Riverside Drive, Ottawa, Ontario, K1G 4K9, Canada
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of Cognos
 * Incorporated ("Confidential Information").  You shall not disclose such
 * Confidential Information and shall use it only in accordance with the
 * terms of the license agreement you entered into with Cognos.
 */
-->
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:bus="http://developer.cognos.com/schemas/bibus/3/"
	xmlns:nav="http://developer.cognos.com/schemas/cps/navigation/1/"
	xmlns:cm="http://developer.cognos.com/schemas/xts-cm/1/" 
	xmlns:ps="http://www.ibm.com/xmlns/prod/cognos" 
	xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt" 
	xmlns:encodingUtils="com.cognos.portal.utils.EncodingUtils"
	xmlns:atom="http://www.w3.org/2005/Atom" exclude-result-prefixes="nav">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>
	
	<xsl:variable name="busHeader" select="/root/bus:biBusHeader"/>
	<xsl:variable name="http-env" select="$busHeader/*[local-name() = 'hdrSession']/bus:environmentVars"/>
	<xsl:variable name="pathInfo" select="$http-env/item[name='PATH_INFO']/value"/>
	<xsl:variable name="webContent" select="$http-env/item[name='WEB_CONTENT_ROOT']/value"/>
	<xsl:variable name="gateway" select="$http-env/item[name='SCRIPT_NAME']/value"/>
	
	<xsl:variable name="parameters" select="/root/parameters/param"/>
	<xsl:variable name="soapAction">
		<xsl:choose>
			<xsl:when test="string($busHeader/bus:dispatcherTransportVars/item[name='originalSOAPAction']/value) != ''">
				<xsl:value-of select="$busHeader/bus:dispatcherTransportVars/item[name='originalSOAPAction']/value"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'atom'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="is-toplevel-request" select="$pathInfo = concat('/', $soapAction)"/>
	
	<xsl:variable name="response-root" select="/root//nav:requestResponse"/>
	<xsl:variable name="self" select="$response-root/nav:queryReplies/nav:queryReply[1]/nav:getItemResponse/*"/>
	<xsl:variable name="children" select="$response-root/nav:queryReplies/nav:queryReply[2]/nav:searchResponse/nav:content/*"/>
	
	<xsl:variable name="atom-gateway">
		<xsl:value-of select="$gateway"/>/<xsl:value-of select="$soapAction"/>
	</xsl:variable>
	
	<xsl:variable name="timeZone" select="$busHeader/bus:userPreferenceVars/item[name='timeZoneID']/value"/>
	<xsl:variable name="contentLocale" select="$busHeader/bus:userPreferenceVars/item[name='contentLocale']/value"/>
	
	<xsl:variable name="cognos-namespace" select="'http://www.ibm.com/xmlns/prod/cognos/rel'"/>
	
	<xsl:variable name="request-params">
		<xsl:call-template name="generate-request-params"/>
	</xsl:variable>
	
	<xsl:template match="/root">
		<xsl:call-template name="start-feeds"/>
	</xsl:template>
	
	<xsl:template name="start-feeds">
		<atom:feed xmlns:atom="http://www.w3.org/2005/Atom" 
			xmlns:app="http://www.w3.org/2007/app" 
			xmlns:openSearch="http://a9.com/-/spec/opensearchrss/1.0/" 
			xmlns:cm="http://developer.cognos.com/schemas/bibus/3/">
			
			<xsl:apply-templates select="$self" mode="self"/>
			<xsl:apply-templates select="$children"/>
			
			<!-- Note: to turn on atom debug, use &frag-debug=pipeline -->

			<!-- Render open search params-->
			<xsl:variable name="resultSetCount" select="number($children/../@end) - number($children/../@start) + 1"/>
			<xsl:variable name="startindex" select="number($children/../@start) - 1"/>
			<opensearch:totalResults xmlns:opensearch="http://a9.com/-/spec/opensearch/1.1/"><xsl:value-of select="$resultSetCount"/></opensearch:totalResults>
			<opensearch:startIndex xmlns:opensearch="http://a9.com/-/spec/opensearch/1.1/"><xsl:value-of select="$startindex"/></opensearch:startIndex>
		</atom:feed>
	</xsl:template>
	
	<xsl:template match="nav:container | nav:item | nav:shortcut" mode="self">
		<xsl:if test="./*">
			<xsl:call-template name="atom-common-properties">
				<xsl:with-param name="node" select="."/>
			</xsl:call-template>
			<xsl:call-template name="links">
				<xsl:with-param name="node" select="."/>
				<xsl:with-param name="parent-node"/>
				<xsl:with-param name="mode" select="'self'"/>
			</xsl:call-template>
			<xsl:call-template name="cm-extensions">
				<xsl:with-param name="node" select="."/>
			</xsl:call-template>
			<xsl:call-template name="nav-extensions">
				<xsl:with-param name="node" select="."/>
			</xsl:call-template>
			<xsl:if test="$parameters[@name='toolbar'] = 'true'">
				<xsl:call-template name="generate-toolbar">
					<xsl:with-param name="node" select="."/>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="nav:container">
		<xsl:call-template name="atom-entry">
			<xsl:with-param name="node" select="."/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="nav:item">
		<xsl:call-template name="atom-entry">
			<xsl:with-param name="node" select="."/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="nav:shortcut">
		<xsl:call-template name="atom-entry">
			<xsl:with-param name="node" select="."/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="atom-entry">
		<xsl:param name="node"/>
		
		<atom:entry>
			<xsl:call-template name="atom-common-properties">
				<xsl:with-param name="node" select="."/>
			</xsl:call-template>
			<xsl:call-template name="links">
				<xsl:with-param name="node" select="."/>
				<xsl:with-param name="parent-node" select="$self"/>
			</xsl:call-template>
			<xsl:call-template name="cm-extensions">
				<xsl:with-param name="node" select="."/>
			</xsl:call-template>
			<xsl:call-template name="nav-extensions">
				<xsl:with-param name="node" select="."/>
			</xsl:call-template>
		</atom:entry>
	</xsl:template>
	
	<xsl:template name="atom-common-properties">
		<xsl:param name="node"/>
		
		<atom:id>
			<xsl:call-template name="generate-atom-id">
				<xsl:with-param name="object-id" select="$node/nav:id"/>
			</xsl:call-template>
		</atom:id>
		<atom:title xml:lang="{$contentLocale}">
			<xsl:choose>
				<xsl:when test="$node/nav:type = 'reportVersion' or $node/nav:type = 'documentVersion'">
					<xsl:value-of select="xtsext:formatDateFromUTC(string($node/nav:creationTime), number('2'), number('3'), string($timeZone),  string($contentLocale))"/>
				</xsl:when>
				<xsl:when test="$node/nav:type = 'output' or $node/nav:type = 'documentContent'">
					<xsl:value-of select="$node/nav:formatName"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$node/nav:name"/>
				</xsl:otherwise>
			</xsl:choose>
		</atom:title>
		<atom:updated><xsl:value-of select="xtsext:formatDateFromUTC(string($node/nav:modificationTime), number('2'), number('3'), string($timeZone),  string($contentLocale))"/></atom:updated>
		<atom:published><xsl:value-of select="xtsext:formatDateFromUTC(string($node/nav:creationTime), number('2'), number('3'), string($timeZone),  string($contentLocale))"/></atom:published>
		<atom:content type="text"><xsl:value-of select="$node/nav:description"/></atom:content>
		<atom:link rel="icon" type="image/gif" href="{$node/nav:imgURL}"/>
	</xsl:template>
	
	<xsl:template name="links">
		<xsl:param name="node"/>
		<xsl:param name="parent-node"/>
		<xsl:param name="mode"/>
		
		<xsl:variable name="class" select="$node/nav:type"/>
		<xsl:variable name="canRender" select="$node[nav:defaultAction] or ($class='reportVersion' or $class='documentVersion')"/>
		
		<xsl:if test="$canRender">
			<xsl:variable name="name" select="$node/nav:name"/>
			<xsl:variable name="id" select="$node/nav:internalId"/>
			<xsl:variable name="parent-id">
				<xsl:if test="starts-with(nav:parentId, '_')"><xsl:value-of select="substring-after(nav:parentId, '_')"/></xsl:if>
			</xsl:variable>
			
			
			<xsl:variable name="request-params">
				<xsl:for-each select="$parameters">
					<xsl:if test="position() > 1">&amp;</xsl:if>
					<xsl:value-of select="@name"/>=<xsl:value-of select="encodingUtils:urlencode(normalize-space (.), 'UTF-8', 'false')"/>
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test="$node[local-name()='container' or (local-name()='shortcut' and ./container)] ">  		
				<atom:link rel="alternate" type="application/atom+xml" href="{$atom-gateway}/cm/id/{$id}?{$request-params}"/>
			</xsl:if>
			<xsl:variable name="containingClass-firstArg">
				<xsl:if test="$parameters[@name='containingClass']">
					<xsl:text>?containingClass=</xsl:text>
					<xsl:value-of select="normalize-space($parameters[@name='containingClass'])"/>
				</xsl:if>
			</xsl:variable>
			<xsl:variable name="containingClass-middleArg">
				<xsl:value-of select="xtsext:replace($containingClass-firstArg,'?','&amp;')"/>
			</xsl:variable>
			
			<xsl:if test="$mode = 'self'">
				<atom:link rel="self" type="application/atom+xml" href="{$atom-gateway}/cm/id/{$id}?{$request-params}"/>
				<xsl:call-template name="render-pagination-links">
					<xsl:with-param name="id" select="$id"/>
					<xsl:with-param name="containingClass" select="$containingClass-middleArg"/>
				</xsl:call-template>				
			</xsl:if>
			<atom:link rel="parent" type="application/atom+xml">
				<xsl:attribute name="href">
					<xsl:choose>
						<xsl:when test="$parent-id != ''">
							<xsl:value-of select="$atom-gateway"/>/cm/id/<xsl:value-of select="$parent-id"/><xsl:value-of select="$containingClass-firstArg"/>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="$atom-gateway"/>/cm</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="$parameters[@name='json'] or $parameters[@name='toolbar']">
						<xsl:text>?</xsl:text>
						<xsl:if test="$parameters[@name='json']">
							<xsl:text/>json&amp;<xsl:text/>
						</xsl:if>
						<xsl:if test="$parameters[@name='toolbar']">
							<xsl:text/>toolbar=<xsl:text/><xsl:value-of select="$parameters[@name='toolbar']"/>							
						</xsl:if>
					</xsl:if>					
				</xsl:attribute>
			</atom:link>
			
			
			<!-- go over the actions and generate links -->
			<xsl:for-each select="$node/nav:action">
			
				<atom:link rel="action.{nav:name}" type="application/octet-stream" href="{nav:url}">
					<ps:link rel="icon" type="image/gif" href="{nav:imgURL}"/>
					<ps:tooltip xml:lang="{$contentLocale}"><xsl:value-of select="nav:alt"/></ps:tooltip>
					<xsl:if test="nav:windowProperties">
						<ps:windowProperties><xsl:value-of select="nav:windowProperties"/></ps:windowProperties>
					</xsl:if>
					<xsl:if test="nav:usePost">
						<ps:usePost><xsl:value-of select="nav:usePost"/></ps:usePost>
					</xsl:if>
				</atom:link>
			</xsl:for-each>
			<!-- Generate other links -->
			<xsl:choose>
				<xsl:when test="$class='reportVersion' or $class='documentVersion'">
					<xsl:variable name="content-output-params">
						<xsl:if test="($class='documentVersion' or $class='reportVersion' )and $parent-node">
							<xsl:text/>&amp;documentType=<xsl:value-of select="encodingUtils:urlencode(string($parent-node/nav:documentType), 'UTF-8', 'false')"/>
							<xsl:text/>&amp;documentName=<xsl:value-of select="encodingUtils:urlencode(string($parent-node/nav:name), 'UTF-8', 'false')"/>
						</xsl:if>
						<xsl:if test="$parameters[@name='json']">
							<xsl:text/>&amp;json<xsl:text/>
						</xsl:if>
					</xsl:variable>
					<atom:link rel="alternate" type="application/atom+xml" href="{$atom-gateway}/cm/id/{$id}?filter=content-output{$content-output-params}{$containingClass-middleArg}"/>
				</xsl:when>
				<xsl:when test="$class='output' or $class='documentContent'">
					<atom:link rel="alternate" type="application/octet-stream" href="{$node/nav:defaultAction/nav:url}"/>
					<xsl:variable name="action_download" select="$node/nav:action[nav:name='action_download']"/>
					<xsl:if test="$action_download">
						<atom:link rel="action.download" type="application/octet-stream" href="{$action_download/nav:url}">
							<ps:link rel="icon" type="image/gif" href="{$action_download/nav:imgURL}"/>
							<ps:tooltip xml:lang="{$contentLocale}"><xsl:value-of select="$action_download/nav:alt"/></ps:tooltip>
						</atom:link>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$class = 'report' or $class = 'reportView' or $class = 'powerPlayReport' or $class = 'powerPlay8Report' or $class = 'analysis' or $class = 'query'">
					<atom:link rel="alternate" type="application/x-ldx+xml" href="{$gateway}/rds/output/id/{$id}"/>
					<atom:link rel="alternate" type="application/x-prompt-description+xml" href="{$gateway}/rds/describePrompts/id/{$id}"/>
					<atom:link rel="alternate" type="application/x-layout+xml" href="{$gateway}/rds/reportInfo/id/{$id}"/>					
					<atom:link rel="alternate" type="application/octet-stream" href="{$node/nav:defaultAction/nav:url}"/>
				</xsl:when>
				<xsl:otherwise>
					<atom:link rel="alternate" type="application/octet-stream" href="{$node/nav:defaultAction/nav:url}"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="generate-atom-id">
		<xsl:param name="object-id"/>
		<xsl:text/>tag:ibm.com,<xsl:text/>
		<xsl:value-of select="$object-id"/>
	</xsl:template>
	
	<xsl:template name="cm-extensions">
		<xsl:param name="node"/>
		<cm:searchPath><xsl:value-of select="$node/nav:searchPath"/></cm:searchPath>
		<cm:storeID>storeID('<xsl:value-of select="$node/nav:internalId"/>')</cm:storeID>
		<cm:objectClass><xsl:value-of select="$node/nav:type"/></cm:objectClass>
		<cm:burstKey><xsl:value-of select="$node/nav:burstKey"/></cm:burstKey>
		<cm:burstKeyDisplayString><xsl:value-of select="$node/nav:burstKey"/></cm:burstKeyDisplayString>
		<cm:locale><xsl:value-of select="$node/nav:locale"/></cm:locale>
		<cm:asOfDate><xsl:value-of select="$node/nav:asOfDate"/></cm:asOfDate>
		
		<xsl:if test="$node[local-name() = 'shortcut']">		
			<cm:targetName><xsl:value-of select="$node/*[local-name()='item' or local-name()='container']/nav:name"/></cm:targetName>
			<cm:targetSearchPath><xsl:value-of select="$node/*[local-name()='item' or local-name()='container']/nav:searchPath"/></cm:targetSearchPath>
			<cm:targetStoreID>StoreID('<xsl:value-of select="$node/*[local-name()='item' or local-name()='container']/nav:internalId"/>')</cm:targetStoreID>
			<cm:targetObjectClass><xsl:value-of select="$node/*[local-name()='item' or local-name()='container']/nav:type"/></cm:targetObjectClass>	
		</xsl:if>
	</xsl:template>	
	
	<xsl:template name="nav-extensions">
		<xsl:param name="node"/>
		<xsl:copy-of select="$node/nav:portalPages"/>
		<xsl:copy-of select="$node/nav:fullName"/>			
	</xsl:template>
	
	<xsl:template name="render-pagination-links">
		<xsl:param name="id" select="id"/>
		<xsl:param name="containingClass"/>
		
		<xsl:variable name="startindex" select="number($children/../@start) - 1"/>
		<xsl:variable name="endindex" select="number($children/../@end) - 1"/>
		<xsl:variable name="more" select="$children/../@more = 'true'"/>
		<xsl:variable name="maxresults" select="$parameters[@name='maxresults']"/>
		<xsl:variable name="resultSetCount" select="number($children/../@end) - number($children/../@start) + 1"/>
		<xsl:variable name="linesPerPage">
			<xsl:choose>
				<xsl:when test="$maxresults != ''">
					<xsl:value-of select="$maxresults"/>
				</xsl:when>
				<xsl:when test="$busHeader/bus:userPreferenceVars/item[name='linesPerPage']/value">
					<xsl:value-of select="$busHeader/bus:userPreferenceVars/item[name='linesPerPage']/value"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'15'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="is-empty-result" select= "not(boolean($resultSetCount))"/>
		<xsl:variable name="is-first-page-request" select= " not($parameters[@name='startindex']) or number($parameters[@name='startindex']) =  number('0')"/>

		<!-- first -->
		<!-- This link is also available when we have no results and we are not on the first page-->
		<xsl:if test="($is-empty-result and not($is-first-page-request)) or number($startindex) > number('0')">
			<xsl:call-template name="generate-pagination-link">
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="link-name" select="'first'"/>
				<xsl:with-param name="startindex" select="'0'"/>
				<xsl:with-param name="maxresults" select="$maxresults"/>
				<xsl:with-param name="containingClass" select="$containingClass" />
			</xsl:call-template>
		</xsl:if>
		
		<!-- previous -->
		<xsl:if test="number($startindex) > number('0')">
			<xsl:call-template name="generate-pagination-link">
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="link-name" select="'previous'"/>
				<xsl:with-param name="startindex">
					<xsl:choose>
						<xsl:when test="number($startindex) - number($linesPerPage) > 0">
							<xsl:value-of select="number($startindex) - number($linesPerPage)"/>
						</xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="maxresults" select="$maxresults"/>
				<xsl:with-param name="containingClass" select="$containingClass"/>
			</xsl:call-template>
		</xsl:if>
		
		<!-- next -->
		<xsl:if test="$more">
			<xsl:call-template name="generate-pagination-link">
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="link-name" select="'next'"/>
				<xsl:with-param name="startindex" select="$endindex + 1"/>
				<xsl:with-param name="maxresults" select="$maxresults"/>
				<xsl:with-param name="containingClass" select="$containingClass"/>
			</xsl:call-template>
		</xsl:if>
		
		<!-- last -->
		<!-- This link is also available when we have no results and we are not on the first page-->
		<xsl:if test="($is-empty-result and not($is-first-page-request)) or $more">
			<xsl:call-template name="generate-pagination-link">
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="link-name" select="'last'"/>
				<xsl:with-param name="startindex" select="-1 * number($linesPerPage)"/>
				<xsl:with-param name="maxresults" select="$maxresults"/>
				<xsl:with-param name="containingClass" select="$containingClass"/>
			</xsl:call-template>
		</xsl:if>
		
		<!-- goto -->
		<xsl:variable name="request-params-goto">
			<xsl:call-template name="generate-request-params">
				<xsl:with-param name="excludes" select="'startindex endindex'"/>
			</xsl:call-template>
		</xsl:variable>
		<atom:link rel="goto" type="application/atom+xml" href="{$atom-gateway}/cm/id/{$id}?startindex=$startindex&amp;endindex=$endindex{$request-params-goto}{$containingClass}"/>
		
		<!-- sort -->
		<xsl:variable name="request-params-sort">
			<xsl:call-template name="generate-request-params">
				<xsl:with-param name="excludes" select="'sortfields sortorder'"/>
			</xsl:call-template>
		</xsl:variable>
		<atom:link rel="sort" type="application/atom+xml" href="{$atom-gateway}/cm/id/{$id}?sortfields=$sortfields&amp;sortorder=$sortorder{$request-params-sort}{$containingClass}"/>
		
		<!-- locale selection -->
		<xsl:variable name="request-params-localeselection">
			<xsl:call-template name="generate-request-params">
				<xsl:with-param name="excludes" select="'locale startindex endindex'"/>
			</xsl:call-template>
		</xsl:variable>
		<atom:link rel="localeselection" type="application/atom+xml" href="{$atom-gateway}/cm/id/{$id}?locale=$locale{$request-params-localeselection}{$containingClass}"/>
	</xsl:template>
	
	<xsl:template name="generate-pagination-link">
		<xsl:param name="id"/>
		<xsl:param name="link-name"/>
		<xsl:param name="startindex"/>
		<xsl:param name="maxresults"/>
		<xsl:param name="containingClass"/>
		
		<xsl:variable name="pagination-params">
			<xsl:text/>startindex=<xsl:value-of select="$startindex"/><xsl:text/>
			<xsl:if test="string($maxresults) != ''">
				<xsl:text disable-output-escaping="yes">&amp;</xsl:text>maxresults=<xsl:value-of select="$maxresults"/><xsl:text/>
			</xsl:if>
		</xsl:variable>
		<xsl:variable name="request-params-pagination">
			<xsl:call-template name="generate-request-params">
				<xsl:with-param name="excludes" select="'startindex endindex'"/>
			</xsl:call-template>
		</xsl:variable>
		<atom:link rel="{$link-name}" type="application/atom+xml" href="{$atom-gateway}/cm/id/{$id}?{$pagination-params}{$request-params-pagination}{$containingClass}"/>
	</xsl:template>
	
	
	<!--  	
		Code used by the getting started prototype
		The toolbar is not really used by the real product for now	
	 -->	
	<xsl:template name="generate-toolbar">
		<xsl:param name="node"/>
			
		<xsl:variable name="passport" select="/root/bus:biBusHeader/*[local-name()='CAM']/CAMPassport/id"/>
		<xsl:variable name="cafContextId" select="xtsext:cafaction(concat('get_contextid_settemplatename_atomresponsexslt_setcomponent_ps_setpassportid_', $passport), '')"/>
		
		
		
		<ps:toolbar>
		
			<xsl:variable name="new-folder">
				<xsl:call-template name="generate-new-tool-url">
					<xsl:with-param name="node" select="$node"/>
					<xsl:with-param name="cafContextId" select="$cafContextId"/>
					<xsl:with-param name="class" select="'folder'"/>
				</xsl:call-template>
			</xsl:variable>
			<item name="newFolder">
				<action href="{$new-folder}"/>
				<icon href="{$webContent}/ps/portal/images/action_new_folder.gif"/>
				<tooltip xml:lang="{$contentLocale}">New Folder</tooltip>			
			</item>
			
			<item name="newWorkspace">			
				<action href="{$gateway}?xts.run&amp;m=portal%2Flaunch.xts&amp;ui.gateway={encodingUtils:urlencode(string($gateway),'UTF-8', false())}&amp;ui.tool=DashboardConsole&amp;ui.action=new&amp;launch.launchInWindow=true"/>
				<icon href="{$webContent}/ps/portal/images/action_new_dashboard.gif"/>
				<tooltip xml:lang="{$contentLocale}">New Workspace</tooltip>
			</item>
			


			<xsl:variable name="new-job">
				<xsl:call-template name="generate-new-tool-url">
					<xsl:with-param name="node" select="$node"/>
					<xsl:with-param name="cafContextId" select="$cafContextId"/>
					<xsl:with-param name="class" select="'jobDefinition'"/>
				</xsl:call-template>
			</xsl:variable>		
			<item name="newJob">
				<action href="{$new-job}"/>
				<icon href="{$webContent}/ps/portal/images/action_new_job.gif"/>
				<tooltip xml:lang="{$contentLocale}">New Job</tooltip>
			</item>
							
			<xsl:variable name="new-url">
				<xsl:call-template name="generate-new-tool-url">
					<xsl:with-param name="node" select="$node"/>
					<xsl:with-param name="cafContextId" select="$cafContextId"/>
					<xsl:with-param name="class" select="'URL'"/>
				</xsl:call-template>
			</xsl:variable>		
			<item name="newUrl">
				<action href="{$new-url}"/>
				<icon href="{$webContent}/ps/portal/images/action_new_url.gif"/>
				<tooltip xml:lang="{$contentLocale}">New URL</tooltip>
			</item>
			
			<xsl:variable name="new-page">
				<xsl:call-template name="generate-new-tool-url">
					<xsl:with-param name="node" select="$node"/>
					<xsl:with-param name="cafContextId" select="$cafContextId"/>
					<xsl:with-param name="class" select="'pagelet'"/>
				</xsl:call-template>
			</xsl:variable>		
			<item name="newPage">
				<action href="{$new-page}"/>
				<icon href="{$webContent}/ps/portal/images/action_new_page.gif"/>
				<tooltip xml:lang="{$contentLocale}">New Page</tooltip>
			</item>
			
			
			<item name="cut">
				<action href="{$gateway}?b_action=xts.run&amp;m_path={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}&amp;editentries=&amp;m=portal%2Fcc.xts&amp;ifrmcmd=&amp;ps_nav_op=submit&amp;ui.cafcontextid={encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())}"/>	
				<icon href="{$webContent}/ps/portal/images/action_cut.gif"/>
				<tooltip xml:lang="{$contentLocale}">Cut</tooltip>		
			</item>			
			<item name="copy" >
				<action href="{$gateway}?b_action=xts.run&amp;m_path={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}&amp;editentries=&amp;m=portal%2Fcc.xts&amp;ifrmcmd=&amp;ps_nav_op=submit&amp;ui.cafcontextid={encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())}"/>
				<icon href="{$webContent}/ps/portal/images/action_copy.gif"/>
				<tooltip xml:lang="{$contentLocale}">Copy</tooltip>
				
			</item>			
			
			<item name="paste" type="application/octet-stream">				
				<action name="copy" parameter="checkbox_" href="{$gateway}?b_action=xts.run&amp;m_path={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}&amp;editentries=&amp;m=portal%2Fsubmit.xts&amp;ifrmcmd=copy&amp;ps_nav_op=submit&amp;ui.cafcontextid={encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())}"/>
				<action name="cut" parameter="checkbox_" href="{$gateway}?b_action=xts.run&amp;m_path={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}&amp;editentries=&amp;m=portal%2Fsubmit.xts&amp;ifrmcmd=move&amp;ps_nav_op=submit&amp;ui.cafcontextid={encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())}"/>
				<icon href="{$webContent}/ps/portal/images/action_paste.gif"/>	
				<iconDisabled href="{$webContent}/ps/portal/images/action_paste_dis.gif"/>							
				<tooltip xml:lang="{$contentLocale}">Paste</tooltip>						
			</item>
			
			<item name="delete">
				<action href="{$gateway}?b_action=xts.run&amp;m_path={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}&amp;m=portal%2Fsubmit.xts&amp;ifrmcmd=delete&amp;ps_nav_op=submit&amp;ui.cafcontextid={encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())}">
					<confirmation>Deleting entries may result in broken links.

Are you sure you want to delete the selected entries?</confirmation>
				</action>								
								
				<icon href="{$webContent}/ps/portal/images/action_delete.gif"/>
				<tooltip xml:lang="{$contentLocale}">Delete</tooltip>
			</item>
			
			<item name="properties">
				<!--action href="{$gateway}?b_action=xts.run&amp;m=portal%2Fproperties_general.xts&amp;m_class={$node/nav:type}&amp;m_name={encodingUtils:urlencode(string($node/nav:name),'UTF-8', false())}&amp;m_obj={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}&amp;ui.cafcontextid={encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())}"/-->
				
				<action href="{$gateway}?b_action=xts.run&amp;m=portal%2Fproperties_general.xts&amp;m_class={$node/nav:type}&amp;m_name={encodingUtils:urlencode(string($node/nav:name),'UTF-8', false())}&amp;m_obj={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}"/>
				<icon href="{$webContent}/ps/portal/images/action_properties_path.gif"/>
				<tooltip xml:lang="{$contentLocale}">Set properties - <xsl:value-of select="$node/nav:name"/></tooltip>
			</item>

			<item name="order">
				<!--action href="{$gateway}?b_action=xts.run&amp;m=portal/sort.xts&amp;m_path={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}&amp;ui.cafcontextid={encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())}"/-->
				
				<action href="{$gateway}?b_action=xts.run&amp;m=portal/sort.xts&amp;m_path={encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())}"/>
				<icon href="{$webContent}/ps/portal/images/action_order.gif"/>
				<tooltip xml:lang="{$contentLocale}">Order</tooltip>
			</item>
					
		</ps:toolbar>
			
	</xsl:template>
	
	<xsl:template name="generate-new-tool-url">
		<xsl:param name="node"/>
		<xsl:param name="class"/>
		<xsl:param name="cafContextId"/>
		
		<xsl:value-of select="$gateway"/>
		<xsl:text>?b_action=xts.run&amp;m=portal%2Fnew_general.xts&amp;cmd=&amp;m_path=</xsl:text>
		<xsl:value-of select="encodingUtils:urlencode(string($node/nav:searchPath),'UTF-8', false())"/>
		<xsl:text>&amp;m_new_class=</xsl:text>
		<xsl:value-of select="encodingUtils:urlencode(string($class),'UTF-8', false())"/>		
		<!--
		<xsl:text>&amp;ui.cafcontextid=</xsl:text>
		<xsl:value-of select="encodingUtils:urlencode(string($cafContextId), 'UTF-8', false())"/>
		-->
		
		
	</xsl:template>
	
	<xsl:template name="generate-request-params">
		<xsl:param name="excludes" select="''"/>
		
		<xsl:if test="$parameters[@name='filter'] and not(contains($excludes, 'filter'))">
			<xsl:text/>&amp;filter=<xsl:value-of select="$parameters[@name='filter']"/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='searchText'] and not(contains($excludes, 'searchText'))">
			<xsl:text/>&amp;searchText=<xsl:value-of select="$parameters[@name='searchText']"/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='locale'] and not(contains($excludes, 'locale'))">
			<xsl:text/>&amp;locale=<xsl:value-of select="$parameters[@name='locale']"/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='sortfields'] and not(contains($excludes, 'sortfields'))">
			<xsl:text/>&amp;sortfields=<xsl:value-of select="$parameters[@name='sortfields']"/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='sortorder'] and not(contains($excludes, 'sortorder'))">
			<xsl:text/>&amp;sortorder=<xsl:value-of select="$parameters[@name='sortorder']"/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='startindex'] and not(contains($excludes, 'startindex'))">
			<xsl:text/>&amp;startindex=<xsl:value-of select="$parameters[@name='startindex']"/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='endindex'] and not(contains($excludes, 'endindex'))">
			<xsl:text/>&amp;endindex=<xsl:value-of select="$parameters[@name='endindex']"/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='json']">
			<xsl:text/>&amp;json<xsl:text/>
		</xsl:if>
		
		
		<xsl:if test="$parameters[@name='json'] and not(contains($excludes, 'json'))">
			<xsl:text/>&amp;json<xsl:text/>
		</xsl:if>
		
		<xsl:if test="$parameters[@name='documentType'] and not(contains($excludes, 'documentType'))">
			<xsl:text/>&amp;documentType=<xsl:value-of select="encodingUtils:urlencode(string($parameters[@name='documentType']), 'UTF-8', 'false')"/>
			<xsl:text/>&amp;documentName=<xsl:value-of select="encodingUtils:urlencode(string($parameters[@name='documentName']), 'UTF-8', 'false')"/>
		</xsl:if>
		
		<!--  parameter used to activate the toolbar used by the navigator prototype -->
		<xsl:if test="$parameters[@name='toolbar']">
			<xsl:text/>&amp;toolbar=<xsl:value-of select="$parameters[@name='toolbar']"/><xsl:text/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="*"/>
	<xsl:template match="*" mode="self"/>
</xsl:stylesheet>
