<?xml version="1.0" encoding="UTF-8"?>
<!--
 +========================================================================+
 | IBM Confidential
 | OCO Source Materials
 | IBM Cognos Products: BUX
 | (C) Copyright IBM Corp. 2009, 2011
 |
 | The source code for this program is not published or otherwise
 | divested of its trade secrets, irrespective of what has been deposited
 | with the U.S. Copyright Office.
 +========================================================================+
-->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:helper="com.ibm.cognos.bux.platform.helpers.XsltHelpers"
	extension-element-prefixes="helper">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="no"/>
	<xsl:param name="prefixes" select="'atom'"/>
	<xsl:param name="exclude-prefixes" select="concat(' ', $prefixes, ' ')"/>
	<xsl:param name="include-lang" select="true()"/>
	<xsl:param name="tagsAsStrings" select="''"/>
	<xsl:template match="/">
		<xsl:apply-templates select="*|@*" mode="json"/>
	</xsl:template>
	<xsl:template match="*|@*|text()" mode="json">
		<xsl:variable name="this-node" select="local-name()"/>
		<xsl:variable name="this-ns" select="namespace-uri()"/>
		<xsl:variable name="precedings" select="preceding-sibling::*[local-name() = $this-node and namespace-uri() = $this-ns]"/>
		<xsl:variable name="followings" select="following-sibling::*[local-name() = $this-node and namespace-uri() = $this-ns]"/>
		<xsl:if test="position() &gt; 1">,</xsl:if>
		<xsl:if test="not($precedings)">
			<xsl:if test="position() = 1">
				<xsl:text>{</xsl:text>
			</xsl:if>
			<xsl:text>&quot;</xsl:text>
			<xsl:choose>
				<xsl:when test="name() != '' and not(contains($exclude-prefixes, concat(' ', substring-before(name(), ':'), ' ')))">
					<xsl:value-of select="translate(name(),':','$')"/>
				</xsl:when>
				<xsl:when test="local-name() != ''">
					<xsl:value-of select="local-name()"/>
				</xsl:when>
				<xsl:otherwise>_text</xsl:otherwise>
			</xsl:choose>
			<xsl:text>&quot;:</xsl:text>
			<xsl:if test="$followings">
				<xsl:text>[</xsl:text>
			</xsl:if>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="*">
				<xsl:apply-templates select="*|@*" mode="json"/>
			</xsl:when>
			<xsl:when test="@*[$include-lang or namespace-uri()!='http://www.w3.org/XML/1998/namespace']">
				<xsl:apply-templates select="@*|text()" mode="json"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="not(contains($tagsAsStrings,concat(',', local-name() ,','))) and (.='true' or .='false' or string(number(.))!='NaN')">
					    <xsl:value-of select="."/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat('&quot;', helper:javascriptencode(string(.)), '&quot;')" disable-output-escaping="yes"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="not($followings)">
			<xsl:if test="$precedings">
				<xsl:text>]</xsl:text>
			</xsl:if>
			<xsl:if test="position() = last()">
				<xsl:text>}</xsl:text>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template match="text()"/>
</xsl:stylesheet>
<!-- $Header: //bux/main/prod/plugins/com.ibm.cognos.bux.utils/data/asJSON_compact.xslt#4 $ -->
<!-- $DateTime: 2010/07/21 13:51:32 $ -->
<!-- $Change: 12887 $ -->
