/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.conformance;

import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMChecking;
import com.ibm.cognos.conformance.CNFMItemInfo;
import com.ibm.cognos.conformance.JDBCDriver;
import java.util.ArrayList;

public class CNFMJDBCDatabaseChecking
extends CNFMChecking {
    CNFMItemInfo m_DBVersionInfo = null;

    @Override
    public String getCategory() {
        return "JDBCDatabases";
    }

    @Override
    public CNFMItemInfo getVersionInfo() {
        return this.m_DBVersionInfo;
    }

    @Override
    public CNFMCheckResult validate(CNFMItemInfo curItemObj, ArrayList<CNFMItemInfo> confList) {
        ArrayList<CNFMItemInfo> candidateList = new ArrayList<CNFMItemInfo>();
        CNFMCheckResult result = null;
        CNFMItemInfo floorItem = null;
        CNFMItemInfo ceilingItem = null;
        if (curItemObj != null && confList != null && confList.size() > 0) {
            for (int i = 0; i < confList.size(); ++i) {
                CNFMItemInfo item = confList.get(i);
                String type = item.getType();
                if (type == null || !type.equalsIgnoreCase(curItemObj.getType())) continue;
                candidateList.add(item);
                if (item.isCeilingValue()) {
                    ceilingItem = item;
                }
                if (item.isFloorValue()) {
                    floorItem = item;
                }
                if (!this.matchConformance(curItemObj, item)) continue;
                String desc = curItemObj.getDescription();
                if (desc != null && desc.length() > 0) {
                    curItemObj.setDescription(desc + " - " + item.getDescription());
                } else {
                    curItemObj.setDescription(item.getDescription());
                }
                ArrayList<CNFMItemInfo> ilist = new ArrayList<CNFMItemInfo>();
                ilist.add(item);
                String status = item.getStatus();
                result = new CNFMCheckResult(curItemObj, ilist, status);
                if (status == null || !status.equalsIgnoreCase("Active") && !status.equalsIgnoreCase("Compatible")) continue;
                return result;
            }
            if ((ceilingItem != null || floorItem != null) && this.verifyVersionOutOfRange(curItemObj, ceilingItem, floorItem)) {
                result = new CNFMCheckResult(curItemObj, candidateList, "Not Supported");
            }
        }
        if (result != null) {
            return result;
        }
        if (confList == null || confList.size() == 0 || candidateList.size() == 0) {
            return new CNFMCheckResult(curItemObj, candidateList, "NotAvaliable");
        }
        return new CNFMCheckResult(curItemObj, candidateList, "Unknown");
    }

    public void setVersionInfo(CNFMItemInfo dbItemInfo) {
        this.m_DBVersionInfo = dbItemInfo;
    }

    protected boolean matchConformance(CNFMItemInfo localInfo, CNFMItemInfo confInfo) {
        String localType = localInfo.getType();
        String confType = confInfo.getType();
        if (localType != null && confType != null && localType.equalsIgnoreCase(confType) && this.propertiesMatch(localInfo.getVersionRelease(), confInfo.getVersionRelease())) {
            if (confInfo.getJDBCDrivers() == null || confInfo.getJDBCDrivers().size() == 0) {
                return true;
            }
            JDBCDriver localDriver = localInfo.getJDBCDrivers().get(0);
            for (JDBCDriver confDriver : confInfo.getJDBCDrivers()) {
                if (!this.propertiesMatch(localDriver.getName(), confDriver.getName())) continue;
                return this.driverPropertiesMatch(localDriver.getJDBCDriverVersions(), confDriver.getJDBCDriverVersions());
            }
        }
        return false;
    }

    protected boolean driverPropertiesMatch(ArrayList<String> localDriverProperties, ArrayList<String> confDriverProperties) {
        if (confDriverProperties.size() == 0) {
            return true;
        }
        String localDriverProperty = localDriverProperties.get(0);
        for (String confDriverProperty : confDriverProperties) {
            if (!this.propertiesMatch(localDriverProperty, confDriverProperty)) continue;
            return true;
        }
        return false;
    }

    protected boolean propertiesMatch(String localRelease, String confRelease) {
        return localRelease != null && confRelease != null && confRelease.length() > 0 && localRelease.startsWith(confRelease);
    }
}

