/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.validator.api.Document;
import com.cognos.validator.api.IParameterUpdater;
import com.cognos.validator.api.ValidatorException;
import com.cognos.validator.api.ValidatorFactory;
import com.cognos.validator.api.VerifyException;
import com.cognos.validator.api.VerifySession;
import com.cognos.validator.common.ParameterUpdater;
import com.cognos.validator.util.ValidatorConfig;
import com.ibm.cognos.bux.buxservice.BUXRequestParameters;
import com.ibm.cognos.bux.buxservice.BUXServiceException;
import com.ibm.cognos.bux.buxservice.BUXServiceMessage;
import com.ibm.cognos.bux.buxservice.GlobalConfig;
import com.ibm.cognos.bux.buxservice.logging.BUXServiceIPFLogger;
import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusContext;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestValidator;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Locale;

public class BUXRequestValidator
extends BiBusRequestValidator {
    private static Locale m_theServerLocale;
    private static VerifySession m_verifySession;
    private static final String VALIDATION_RESOURCE = "data/validation/bux_validation_rules.xml";
    private static final String CAM_INITDOCUMENT = "<initializeDocument><serviceID>CAM</serviceID></initializeDocument>";
    private static final String ERR_FAILED_LOAD_VALIDATOR_DOC = "bux.error.requestvalidator.FailedLoadingValidatorDocument";
    private static final String ERR_REQUESTVALIDATOR_VERIFYEXCEPTION = "bux.error.requestvalidator.VerifyException";
    private static final String ERR_REQUESTVALIDATOR_VERIFYSESSION_NOTSET = "bux.error.requestvalidator.VerifySessionNotSet";
    private static final String ERR_REQUESTVALIDATOR_VALIDATOREXCEPTION = "bux.error.requestvalidator.ValidatorSessionNotSet";
    private static final String ERR_REQUESTVALIDATOR_AUTHTOKEN_INVALID = "bux.error.requestvalidator.AuthToken.Invalid";
    private static final String ERR_FAILED_CREATE_CAMFACTORY = "bux.error.requestvalidator.AuthToken.Invalid_CAMFactory";
    private static final String ERR_FAILED_CREATE_USERSESSION = "bux.error.requestvalidator.AuthToken.Invalid_UserSession";
    private static Logger logger;
    private static UserSessionIDSession m_usIDSession;
    private static final String AUTHENTICITY_TOKEN_KEYNAME = "COM-IBM-COGNOS-AUTHENTICITYTOKEN";
    private static final String USERSESSIONID_KEYNAME = "usersessionid";
    private static final String BUX_PROXY = "/icd/proxy/";
    private static CAMFactory m_cf;
    private static GlobalConfig m_globalConfig;
    private BUXRequestParameters m_requestParameters = new BUXRequestParameters();
    private static final String BUX_CLIENT_VALID_DOMAIN_LIST = "BUXClientValidDomainList";
    private static final String BUX_CLIENT_VALID_DOMAIN_LIST_SPLITTER = ",";
    private static final String BUX_CLIENT = "BUX";

    public static VerifySession getVerifySession() {
        return m_verifySession;
    }

    public static void setVerifySession(VerifySession session) {
        m_verifySession = session;
    }

    public static Locale getTheServerLocale() {
        return m_theServerLocale;
    }

    public static void setTheServerLocale(Locale serverLocale) {
        m_theServerLocale = serverLocale;
    }

    public static CAMFactory getCamFactory() {
        return m_cf;
    }

    public static void setCamFactory(CAMFactory m_cf) {
        BUXRequestValidator.m_cf = m_cf;
    }

    public static UserSessionIDSession getUserSession() {
        return m_usIDSession;
    }

    public static void setUserSession(UserSessionIDSession usIDSession) {
        m_usIDSession = usIDSession;
    }

    public static void initialize(GlobalConfig globalConfig) {
        m_globalConfig = globalConfig;
        m_theServerLocale = m_globalConfig.getServerLocale();
        BUXRequestValidator.createCAMFactory();
        BUXRequestValidator.loadValidatorDocument();
        BUXRequestValidator.readSafeDomainList();
    }

    public static void readSafeDomainList() {
        BUXRequestValidator.doValidatorRequiredFirstRun();
        HashSet<String> vcHosts = new HashSet<String>();
        vcHosts.addAll(ValidatorConfig.m_validHostPorts);
        m_globalConfig.setSafeDomainList(vcHosts, ValidatorConfig.validDomainsManager.getExactValidDomains(BUX_CLIENT), ValidatorConfig.validDomainsManager.getHighLevelValidDomains(BUX_CLIENT));
    }

    public static void resetBUXClientValidDomain() {
        ValidatorConfig.validDomainsManager.resetDomains(BUX_CLIENT);
        String buxValidDomainList = m_globalConfig.getValue(BUX_CLIENT_VALID_DOMAIN_LIST, true);
        if (buxValidDomainList != null) {
            String[] domainArray;
            for (String domain : domainArray = buxValidDomainList.trim().toLowerCase().split(BUX_CLIENT_VALID_DOMAIN_LIST_SPLITTER)) {
                if (BUXRequestValidator.isValidDomainSyntax(domain)) {
                    if (ValidatorConfig.validDomainsManager.addDomain(BUX_CLIENT, domain) || logger == null) continue;
                    logger.warn(BUXRequestValidator.class.getName(), "The following domain was not added to the valid domain list '" + domain + '\'', null);
                    continue;
                }
                if (logger == null) continue;
                logger.error(BUXRequestValidator.class.getName(), "Invalid Domain Name '" + domain + '\'', null);
            }
        }
        m_globalConfig.setSafeDomainList(ValidatorConfig.m_validHostPorts, ValidatorConfig.validDomainsManager.getExactValidDomains(BUX_CLIENT), ValidatorConfig.validDomainsManager.getHighLevelValidDomains(BUX_CLIENT));
    }

    private static boolean isValidDomainSyntax(String domainName) {
        if (domainName != null) {
            String domain = domainName.trim();
            return domain.startsWith("*.") || domain.startsWith(".");
        }
        return false;
    }

    private static void doValidatorRequiredFirstRun() {
        ParameterUpdater paramUpdater = new ParameterUpdater();
        paramUpdater.add("url", new String[]{"http://locahost/"});
        try {
            m_verifySession.put(0, true);
            m_verifySession.verify((IParameterUpdater)paramUpdater);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadValidatorDocument() {
        String message;
        InputStreamReader isr = null;
        try {
            ValidatorFactory validatorFactory = ValidatorFactory.newInstance();
            validatorFactory.put(0, false);
            validatorFactory.put(1, true);
            validatorFactory.put(2, true);
            Document doc = validatorFactory.createDocument();
            ClassLoader cl = BUXRequestValidator.class.getClassLoader();
            InputStream is = cl.getResourceAsStream(VALIDATION_RESOURCE);
            isr = new InputStreamReader(is);
            doc.loadFromXML(BUX_CLIENT, (Reader)isr);
            m_verifySession = validatorFactory.createVerifySession(doc);
        }
        catch (ValidatorException ex1) {
            message = BUXServiceMessage.getInstance().getMessage(m_theServerLocale, ERR_FAILED_LOAD_VALIDATOR_DOC);
            logger.error(BUXRequestValidator.class.getName(), message, (Throwable)ex1, null);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    message = BUXServiceMessage.getInstance().getMessage(m_theServerLocale, ERR_FAILED_LOAD_VALIDATOR_DOC);
                    logger.error(BUXRequestValidator.class.getName(), message, (Throwable)e, null);
                }
            }
        }
    }

    private static void createCAMFactory() {
        m_cf = new CAMFactory();
        try {
            m_cf.initialize(CAM_INITDOCUMENT.getBytes());
        }
        catch (Exception e) {
            String message = BUXServiceMessage.getInstance().getMessage(m_theServerLocale, ERR_FAILED_CREATE_CAMFACTORY);
            logger.error(BUXRequestValidator.class.getName(), message, (Throwable)e, null);
        }
    }

    private void createUserSession(BiBusContext bibusContext, Locale productLocale) throws BUXServiceException {
        try {
            m_usIDSession = m_cf.createUserSessionIDSession();
        }
        catch (CAMCryptoException e) {
            this.logAndThrow(ERR_FAILED_CREATE_USERSESSION, bibusContext, productLocale, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.logAndThrow(ERR_FAILED_CREATE_USERSESSION, bibusContext, productLocale, e);
        }
    }

    public boolean isAuthTokenVerified(MessageContext mc, BiBusContext bibusContext, Locale productLocale) throws BUXServiceException {
        boolean status = false;
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        String httpRequestMethod = requestEnvelope.getEnvironmentValue("REQUEST_METHOD");
        String goodAuthToken = requestEnvelope.getEnvironmentValue(AUTHENTICITY_TOKEN_KEYNAME);
        String goodUID = requestEnvelope.getCookieValue(USERSESSIONID_KEYNAME);
        if (goodUID == null) {
            goodUID = requestEnvelope.getSetCookieValue(USERSESSIONID_KEYNAME);
        }
        String serverPathInfo = (String)mc.getProperty("path_info");
        if (httpRequestMethod.compareToIgnoreCase("GET") == 0 || serverPathInfo != null && serverPathInfo.startsWith(BUX_PROXY)) {
            status = true;
        } else if (goodAuthToken != null && goodUID != null) {
            byte[] userSessionID = goodUID.getBytes();
            byte[] authToken = goodAuthToken.getBytes();
            try {
                this.createUserSession(bibusContext, productLocale);
                status = m_usIDSession.verifyAuthenticityToken(authToken, userSessionID) == 1;
            }
            catch (CAMCryptoException e) {
                this.logAndThrow(ERR_REQUESTVALIDATOR_AUTHTOKEN_INVALID, bibusContext, productLocale, (Exception)((Object)e));
            }
            catch (Exception e) {
                this.logAndThrow(ERR_REQUESTVALIDATOR_AUTHTOKEN_INVALID, bibusContext, productLocale, e);
            }
        }
        if (!status) {
            this.logAndThrow(ERR_REQUESTVALIDATOR_AUTHTOKEN_INVALID, bibusContext, productLocale, null);
        }
        return true;
    }

    private void logAndThrow(String msgKey, BiBusContext bibusContext, Locale productLocale, Exception exceptionObj) throws BUXServiceException {
        String message = BUXServiceMessage.getInstance().getMessage(m_theServerLocale, msgKey);
        BUXServiceException bse = new BUXServiceException(msgKey, m_theServerLocale);
        this.logException(exceptionObj, message, bse);
        if (bibusContext != null && productLocale != null) {
            BUXServiceIPFLogger bsil = new BUXServiceIPFLogger();
            bsil.logAuditRequestError(bibusContext, message, productLocale);
            throw bse;
        }
    }

    private void logException(Exception exceptionObj, String message, BUXServiceException bse) {
        if (null != logger) {
            if (exceptionObj != null) {
                logger.error(BUXRequestValidator.class.getName(), message, (Throwable)exceptionObj, null);
                logger.error(BUXRequestValidator.class.getName(), exceptionObj.getMessage(), null);
            } else {
                logger.error(BUXRequestValidator.class.getName(), message, (Throwable)bse, null);
            }
        }
    }

    public void validateRequest(MessageContext mc, BiBusContext bibusContext, Locale productLocale) throws BUXServiceException {
        BIBusEnvelope requestEnvelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (m_verifySession == null || !this.isAuthTokenVerified(mc, bibusContext, productLocale)) {
            this.logAndThrow(ERR_REQUESTVALIDATOR_VERIFYSESSION_NOTSET, bibusContext, productLocale, null);
        }
        try {
            BUXRequestParameters reqParams = new BUXRequestParameters();
            reqParams.addDispatcherParameterList(requestEnvelope.getFormFieldValues());
            this.doValidation(reqParams.getParameterUpdater());
        }
        catch (VerifyException ve) {
            this.logAndThrow(ERR_REQUESTVALIDATOR_VERIFYEXCEPTION, bibusContext, productLocale, (Exception)((Object)ve));
        }
        catch (ValidatorException ve) {
            this.logAndThrow(ERR_REQUESTVALIDATOR_VALIDATOREXCEPTION, bibusContext, productLocale, (Exception)((Object)ve));
        }
        catch (Exception ex) {
            this.logAndThrow(ERR_REQUESTVALIDATOR_VALIDATOREXCEPTION, bibusContext, productLocale, ex);
        }
    }

    private void doValidation(ParameterUpdater pu) throws ValidatorException, VerifyException {
        m_verifySession.put(0, true);
        m_verifySession.verify((IParameterUpdater)pu);
    }

    public void validateParameters() throws Exception {
        try {
            this.doValidation(this.m_requestParameters.getParameterUpdater());
        }
        catch (VerifyException ve) {
            this.logAndThrowGenericException((Exception)((Object)ve), ERR_REQUESTVALIDATOR_VERIFYEXCEPTION);
        }
        catch (ValidatorException ve) {
            this.logAndThrowGenericException((Exception)((Object)ve), ERR_REQUESTVALIDATOR_VALIDATOREXCEPTION);
        }
        catch (Exception ex) {
            this.logAndThrowGenericException(ex, ERR_REQUESTVALIDATOR_VALIDATOREXCEPTION);
        }
    }

    public void validateParameters(BUXRequestParameters reqParams) throws Exception {
        try {
            this.doValidation(reqParams.getParameterUpdater());
        }
        catch (VerifyException ve) {
            this.logAndThrowGenericException((Exception)((Object)ve), ERR_REQUESTVALIDATOR_VERIFYEXCEPTION);
        }
        catch (ValidatorException ve) {
            this.logAndThrowGenericException((Exception)((Object)ve), ERR_REQUESTVALIDATOR_VALIDATOREXCEPTION);
        }
        catch (Exception ex) {
            this.logAndThrowGenericException(ex, ERR_REQUESTVALIDATOR_VALIDATOREXCEPTION);
        }
    }

    public void logAndThrowGenericException(Exception exObj, String msgKey) throws Exception {
        this.logException(exObj, msgKey, null);
        throw exObj;
    }

    public void addParameter(String name, String value) {
        this.m_requestParameters.addParameter(name, value);
    }

    static {
        logger = IPFTraceLoggerFactory.getInstance().getLogger(BUXRequestValidator.class.getName());
        m_cf = null;
        m_globalConfig = null;
    }
}

