/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.pogo.impl.DispatcherStrings;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.Envelope;
import com.ibm.cognos.bux.buxservice.BUXRequestValidator;
import com.ibm.cognos.bux.buxservice.BUXRequestValidatorFactoryImpl;
import com.ibm.cognos.bux.buxservice.BUXServiceException;
import com.ibm.cognos.bux.buxservice.BUXServiceMessage;
import com.ibm.cognos.bux.buxservice.BiBusPlatformServicesImpl;
import com.ibm.cognos.bux.buxservice.CAMHttpClientImpl;
import com.ibm.cognos.bux.buxservice.GlobalConfig;
import com.ibm.cognos.bux.buxservice.LauncherConfigImpl;
import com.ibm.cognos.bux.buxservice.LauncherContextImpl;
import com.ibm.cognos.bux.buxservice.logging.BUXServiceIPFLogger;
import com.ibm.cognos.bux.buxservice.logging.IPFAuditLoggerFactory;
import com.ibm.cognos.bux.buxservice.logging.IPFManager;
import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.buxservice.logging.ZipiTraceLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.AuditLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusContext;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusDelegateParent;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusGlobalConfig;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusPlatformServices;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequest;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestHandler;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestValidatorFactory;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusResponse;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusResponseBase;
import com.ibm.cognos.bux.osgibridge.delegate.CAMHttpClient;
import com.ibm.cognos.bux.osgibridge.delegate.ICDStarter;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import com.ibm.cognos.bux.osgibridge.delegate.LoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.PerformanceIndicatorLoggerFactory;
import com.ibm.cognos.bux.osgibridge.handler.FrameworkLauncherMessages;
import com.ibm.cognos.bux.osgibridge.handler.LauncherConfig;
import com.ibm.cognos.bux.osgibridge.handler.LauncherContext;
import com.ibm.cognos.bux.osgibridge.handler.OSGiBridgeHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.soap.util.mime.MimeUtils;

public abstract class BUXServiceBaseHandler
extends BasicHandler {
    private static final String ICD = "/icd";
    private static final String PATHINFO = "pathinfo";
    private static final String RESOURCE_BUNDLE_PREFIX = "BUX";
    private static final String RESOURCE_BUNDLE_NAME = "buxMsg";
    private static final String TEXT_XML_CHARSET_UTF_8 = "text/xml; charset=utf-8";
    private static final String TEXT_HTML_CHARSET_UTF_8 = "text/html; charset=utf-8\r\n\r\n";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String LOG_TIMES = "logTimes";
    private static final String GET_LOGGED_TIMES = "getLoggedTimes";
    private static final String DISPATCHER_CANT_SERVICE = "BasicHandler.cantService";
    public static final String MSGCODE_BUX_REQ_ERR = "bux.error.RequestError";
    public static final String ERR_INVALID_REQUEST = "bux.error.InvalidRequest";
    public static final String ERR_NO_CAPABILITY = "bux.error.NO_CAPABILITY";
    public static final String ERR_BRIDGE_HANDLER_NOT_SET = "bux.error.BridgeHandlerNotSet";
    public static final String ERROR_ESTABLISHING_LOCATION = "bux.error.ERROR_ESTABLISHING_LOCATION";
    public static final String SPACE = " ";
    public static final String COULD_NOT_FIND_FRAMEWORK = "bux.error.COULD_NOT_FIND_FRAMEWORK";
    public static final String DOES_NOT_SUPPORT_SETTING_A_SHUTDOWN_HANDLER_RESTART_HANDLING_IS_DISABLED = "bux.error.DOES_NOT_SUPPORT_SETTING_A_SHUTDOWN_HANDLER_RESTART_HANDLING_IS_DISABLED";
    public static final String ERROR_WHILE_STARTING_FRAMEWORK = "bux.error.ERROR_WHILE_STARTING_FRAMEWORK";
    public static final String FRAMEWORK_IS_ALREADY_STARTED = "bux.msg.FRAMEWORK_IS_ALREADY_STARTED";
    public static final String COULD_NOT_START_THE_FRAMEWORK_NOT_DEPLOYED = "bux.error.COULD_NOT_START_THE_FRAMEWORK_NOT_DEPLOYED";
    public static final String REQUEST_VALIDATION_FAILED = "bux.error.REQUEST_VALIDATION_FAILED";
    public static final String OSGI_STARTUP_DONE = "bux.info.OSGI_STARTUP_DONE";
    public static final String OSGI_STARTUP_FAILED = "bux.error.OSGI_STARTUP_FAILED";
    public static final String STARTING_BUX_SERVICES = "bux.info.STARTING_BUX_SERVICES";
    private OSGiBridgeHandler theBridgeHandler;
    private LauncherContextImpl context = null;
    private final GlobalConfig globalConfig = new GlobalConfig();
    private final Locale serverLocale = this.globalConfig.getServerLocale();
    private BUXRequestValidator buxValidator;
    private static Logger logger;
    private static boolean bLogTimes;
    private static ArrayList<Date> startTimes;
    private static ArrayList<Date> endTimes;
    private BiBusPlatformServicesImpl platformServices;

    public BUXServiceBaseHandler() {
        super(null);
        BiBusGlobalConfig.setGlobalConfig((BiBusGlobalConfig)this.globalConfig);
        BiBusRequestValidatorFactory.setInstance((BiBusRequestValidatorFactory)new BUXRequestValidatorFactoryImpl());
        this.buxValidator = new BUXRequestValidator();
        this.globalConfig.setBUXValidator(this.buxValidator);
    }

    public void configure(Configuration configuration) {
        this.globalConfig.setConfiguration(configuration);
        this.globalConfig.readConfigurationParameters();
        BUXRequestValidator.initialize(this.globalConfig);
    }

    public BUXRequestValidator getBUXValidator() {
        return this.buxValidator;
    }

    public void initialize() {
        this.theBridgeHandler = new OSGiBridgeHandler();
        DispatcherStrings.getInstance().registerResourceBundle(RESOURCE_BUNDLE_PREFIX, RESOURCE_BUNDLE_NAME);
        IPFManager.start();
        IPFTraceLoggerFactory factory = IPFTraceLoggerFactory.getInstance();
        if (null != factory && null == logger) {
            logger = factory.getLogger(BUXServiceBaseHandler.class.getName());
        }
        try {
            CAMHttpClientImpl.init();
            CAMHttpClient.setInstance((CAMHttpClient)new CAMHttpClientImpl());
        }
        catch (CAMCryptoException e) {
            CAMHttpClient.setInstance(null);
            logger.error(BUXServiceBaseHandler.class.getName(), e.getLocalizedMessage(), null);
        }
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        super.compose_impl(engine);
        this.platformServices = new BiBusPlatformServicesImpl(engine);
        BiBusPlatformServices.setBiBusPlatformServices((BiBusPlatformServices)this.platformServices);
    }

    public void invokeImpl(MessageContext mc) {
        this.delegateToOSGiBridge(mc);
    }

    public void reconfigure(Configuration configuration) {
        this.globalConfig.setConfiguration(configuration);
        this.globalConfig.readConfigurationParameters();
        this.globalConfig.onReconfigure();
    }

    public void setBUXValidator(BUXRequestValidator buxRequestValidator) {
        this.buxValidator = buxRequestValidator;
    }

    public void start() {
        LauncherConfigImpl config = new LauncherConfigImpl();
        this.context = new LauncherContextImpl(IPFTraceLoggerFactory.getInstance());
        FrameworkLauncherMessages messages = new FrameworkLauncherMessages();
        messages.setMessages(this.getOSGiFrameworkLauncherMessages());
        this.setOSGiBridgeDelegateErrorMessages();
        this.theBridgeHandler.init((LauncherContext)this.context, (LauncherConfig)config, this.globalConfig.getEclipseFolderBasePath(), this.globalConfig.getTempFolderPath(), messages, (LoggerFactory)IPFTraceLoggerFactory.getInstance(), (AuditLoggerFactory)IPFAuditLoggerFactory.getInstance(), (PerformanceIndicatorLoggerFactory)ZipiTraceLoggerFactory.getInstance());
        if (ICDStarter.startICDServices()) {
            System.out.println(BUXServiceMessage.getInstance().getMessage(this.serverLocale, STARTING_BUX_SERVICES));
            logger.info(BUXServiceBaseHandler.class.getName(), OSGI_STARTUP_DONE, null);
        } else {
            logger.error(BUXServiceBaseHandler.class.getName(), OSGI_STARTUP_FAILED, null);
        }
    }

    public void stop() {
        IPFManager.stop();
        this.theBridgeHandler.destroy();
        this.globalConfig.cleanup();
    }

    protected abstract Envelope createResponse(MessageContext var1);

    protected abstract BiBusRequest getBiBusRequestImpl(MessageContext var1);

    protected abstract boolean hasCapability(BIBusEnvelope var1);

    protected abstract BiBusRequest.BiBusUserRole getCurrentUserRole(BIBusEnvelope var1);

    protected abstract void processCookies(BiBusResponseBase var1, Envelope var2);

    protected abstract BiBusContext getBiBusContext(BIBusEnvelope var1);

    protected abstract BIBusEnvelope createBusFaultResponseEnvelope(BIBusEnvelope var1, String var2, String var3, String var4, Throwable var5);

    protected BiBusResponseBase getBiBusResponseImpl(MessageContext mc) {
        return new BiBusResponseBase();
    }

    protected BiBusRequestHandler getBridgeHandler() {
        return this.theBridgeHandler;
    }

    protected GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    protected boolean isCookieSecure() {
        String cookieSecureValue = this.getGlobalConfig().getValue("cookieSecure", false);
        return cookieSecureValue != null ? Boolean.valueOf(cookieSecureValue) : false;
    }

    protected Locale getProductLocale(MessageContext mc) {
        return this.getLocale(mc, "productLocale");
    }

    protected Locale getContentLocale(MessageContext mc) {
        return this.getLocale(mc, "contentLocale");
    }

    protected BIBusEnvelope getRequestEnvelope(MessageContext mc) {
        return (BIBusEnvelope)mc.getProperty("request.envelope");
    }

    protected void handleBUXServiceNormalResponse(MessageContext mc, BiBusResponseBase response) {
        Envelope envelope = this.createResponse(mc);
        mc.setResponseName("response");
        mc.setProperty("response.status_code", (Object)Integer.toString(response.getHTTPStatusCode()));
        mc.setProperty("response.envelope", (Object)envelope);
        mc.setProperty("response.headers", (Object)new InternetHeaders());
        this.processCookies(response, envelope);
        InputStream responsePayload = response.getResponsePayload();
        Iterator<InputStream> attachments = null;
        if (null != responsePayload) {
            attachments = this.makeAttachment(responsePayload);
        }
        mc.setProperty("response.attachments", attachments);
        mc.setProperty("response.boundary", (Object)MimeUtils.getUniqueValue());
    }

    protected boolean isValidRequest(MessageContext mc, BiBusContext bibusContext) {
        try {
            this.buxValidator.validateRequest(mc, bibusContext, this.getProductLocale(mc));
        }
        catch (BUXServiceException bse) {
            this.setFault(mc, bse, REQUEST_VALIDATION_FAILED);
            if (null != logger) {
                logger.error(BUXServiceBaseHandler.class.getName(), REQUEST_VALIDATION_FAILED, bibusContext.getRequestParameters());
            }
            return false;
        }
        return true;
    }

    protected Iterator<InputStream> makeAttachment(InputStream inStream) {
        ArrayList<InputStream> attachmentList = new ArrayList<InputStream>(1);
        attachmentList.add(inStream);
        Iterator<InputStream> attachments = attachmentList.iterator();
        return attachments;
    }

    private void delegateToOSGiBridge(MessageContext mc) {
        BIBusEnvelope envelope = this.getRequestEnvelope(mc);
        if (null == envelope) {
            this.setFault(mc, ERR_INVALID_REQUEST);
            return;
        }
        if (!this.hasCapability(envelope)) {
            this.setFault(mc, ERR_NO_CAPABILITY);
            return;
        }
        if (envelope.getFormValue(LOG_TIMES) != null) {
            bLogTimes = Boolean.parseBoolean(envelope.getFormValue(LOG_TIMES));
        }
        if (bLogTimes) {
            if (envelope.getFormValue(GET_LOGGED_TIMES) != null) {
                BiBusResponseBase response = this.handleLoggedTimesRequest(mc);
                this.handleBUXServiceNormalResponse(mc, response);
                return;
            }
            startTimes.add(new Date());
        }
        BiBusContext bibusContext = this.getBiBusContext(envelope);
        BiBusRequest request = this.getBiBusRequestImpl(mc);
        if (!this.isProxyRequest(request) && !this.isValidRequest(mc, bibusContext)) {
            return;
        }
        BiBusRequestHandler bridgeHandler = this.getBridgeHandler();
        if (null == bridgeHandler) {
            this.setFault(mc, ERR_BRIDGE_HANDLER_NOT_SET);
            return;
        }
        BiBusResponseBase response = this.getBiBusResponseImpl(mc);
        bridgeHandler.service(bibusContext, request, (BiBusResponse)response);
        this.processResponse(bibusContext, mc, response);
        if (bLogTimes) {
            endTimes.add(new Date());
        }
    }

    private boolean isProxyRequest(BiBusRequest request) {
        String pathInfo = this.getPathInfo(request);
        return null != pathInfo && pathInfo.startsWith("/proxy/");
    }

    private String getPathInfo(BiBusRequest request) {
        String pathInfo = request.getPathInfo();
        if (null == pathInfo) {
            Map params = request.getRequestParameters();
            if (params != null && params.containsKey(PATHINFO)) {
                pathInfo = ((String[])request.getRequestParameters().get(PATHINFO))[0];
            }
        } else if (pathInfo.startsWith(ICD)) {
            pathInfo = pathInfo.substring(ICD.length());
        }
        return pathInfo;
    }

    private String[] getOSGiFrameworkLauncherMessages() {
        BUXServiceMessage svcMsg = BUXServiceMessage.getInstance();
        String[] messages = new String[]{svcMsg.getMessage(this.serverLocale, ERROR_ESTABLISHING_LOCATION), SPACE, svcMsg.getMessage(this.serverLocale, COULD_NOT_FIND_FRAMEWORK), svcMsg.getMessage(this.serverLocale, DOES_NOT_SUPPORT_SETTING_A_SHUTDOWN_HANDLER_RESTART_HANDLING_IS_DISABLED), svcMsg.getMessage(this.serverLocale, ERROR_WHILE_STARTING_FRAMEWORK), svcMsg.getMessage(this.serverLocale, FRAMEWORK_IS_ALREADY_STARTED), svcMsg.getMessage(this.serverLocale, COULD_NOT_START_THE_FRAMEWORK_NOT_DEPLOYED)};
        return messages;
    }

    private void handleBUXServiceErrorResponse(BiBusContext bibusContext, MessageContext mc, BiBusResponse response) {
        String msgCode = response.getExceptionMessageCode();
        String msgDetail = response.getExceptionMessageDetail();
        Throwable exceptionObj = response.getException();
        this.handleBUXServiceErrorResponse(mc, msgCode, msgDetail, exceptionObj, response.getContentType());
        BUXServiceIPFLogger bsil = new BUXServiceIPFLogger();
        bsil.logAuditRequestError(bibusContext, msgDetail, this.getProductLocale(mc));
    }

    private void handleBUXServiceErrorResponse(MessageContext mc, String msgCode, String msgDetail, Throwable exceptionObj, String contentType) {
        mc.setResponseName("response");
        mc.setProperty("response.status_code", (Object)"500");
        InternetHeaders headers = new InternetHeaders();
        String theContentType = contentType;
        if (null == theContentType) {
            theContentType = TEXT_XML_CHARSET_UTF_8;
        }
        headers.setHeader(CONTENT_TYPE, theContentType);
        mc.setProperty("request.headers", (Object)headers);
        BIBusEnvelope requestEnvelope = this.getRequestEnvelope(mc);
        String faultCodeText = BUXServiceMessage.getInstance().getMessage(this.getProductLocale(mc), MSGCODE_BUX_REQ_ERR);
        mc.setFault(new Fault(DISPATCHER_CANT_SERVICE, (SOAPEnvelope)this.createBusFaultResponseEnvelope(requestEnvelope, faultCodeText, msgCode, msgDetail, exceptionObj)));
    }

    private void processResponse(BiBusContext bibusContext, MessageContext mc, BiBusResponseBase response) {
        if (response.getStatus() < 0) {
            this.handleBUXServiceErrorResponse(bibusContext, mc, (BiBusResponse)response);
        } else {
            this.handleBUXServiceNormalResponse(mc, response);
        }
    }

    private void setFault(MessageContext mc, BUXServiceException e, String msgKey) {
        Fault fault = new Fault(DISPATCHER_CANT_SERVICE, (Exception)e);
        String msg = BUXServiceMessage.getInstance().getMessage(this.getProductLocale(mc), msgKey);
        fault.setMessageParameters((Object[])new String[]{msg});
        fault.setClientFault(true);
        mc.setFault(fault);
    }

    private void setFault(MessageContext mc, String msgKey) {
        BUXServiceException e = new BUXServiceException(msgKey, this.getProductLocale(mc));
        this.setFault(mc, e, msgKey);
        if (null != logger) {
            logger.error(BUXServiceBaseHandler.class.getName(), msgKey, null);
        }
    }

    private void setOSGiBridgeDelegateErrorMessages() {
        BUXServiceMessage svcMsg = BUXServiceMessage.getInstance();
        for (BiBusDelegateParent.BiBusDelegateErrorMessage msg : BiBusDelegateParent.BiBusDelegateErrorMessage.values()) {
            BiBusDelegateParent.setErrorMessage((BiBusDelegateParent.BiBusDelegateErrorMessage)msg, (String)svcMsg.getMessage(this.serverLocale, "bux.error." + msg.toString()));
        }
    }

    private BiBusResponseBase handleLoggedTimesRequest(MessageContext mc) {
        StringBuilder result = new StringBuilder();
        result.append(TEXT_HTML_CHARSET_UTF_8);
        result.append("[");
        int logArraySize = startTimes.size();
        for (int i = 0; i < logArraySize; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append("{\"desc\": \"BUX dispatcher handler called\",\"time\":\"");
            result.append(new SimpleDateFormat("hh:mm:ss:SSS").format(startTimes.get(i)));
            result.append("\"},");
            result.append("{\"desc\": \"BUX dispatcher handler finished\",\"time\":\"");
            result.append(new SimpleDateFormat("hh:mm:ss:SSS").format(endTimes.get(i)));
            result.append("\"}");
        }
        result.append("]");
        startTimes.clear();
        endTimes.clear();
        BiBusResponseBase response = this.getBiBusResponseImpl(mc);
        response.setResponsePayload((InputStream)new ByteArrayInputStream(result.toString().getBytes()));
        return response;
    }

    private Locale getLocale(MessageContext mc, String whichLocale) {
        BIBusEnvelope envelope = this.getRequestEnvelope(mc);
        String locale = null != envelope ? envelope.getUserPreferenceValue(whichLocale) : null;
        return GlobalConfig.toLocale(locale == null || locale.length() < 2 ? "en" : locale);
    }

    static {
        bLogTimes = false;
        startTimes = new ArrayList();
        endTimes = new ArrayList();
    }
}

