/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class BUXServiceMessage {
    private static final String MSGFILE = "buxMsg";
    private final Object mutexObj = new Object();
    private static BUXServiceMessage theInstance = new BUXServiceMessage();
    private final Map<String, ResourceBundle> msgResourceMap = new HashMap<String, ResourceBundle>();

    public static BUXServiceMessage getInstance() {
        return theInstance;
    }

    private BUXServiceMessage() {
    }

    public String getMessage(Locale locale, String key) {
        ResourceBundle bundle = this.getMsgFile(locale);
        if (bundle == null) {
            return key;
        }
        try {
            String msg = bundle.getString(key);
            if (msg != null) {
                return msg;
            }
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getMsgFile(Locale locale) {
        Locale loc = locale;
        if (loc == null) {
            return null;
        }
        String mapkey = loc.toString();
        Object object = this.mutexObj;
        synchronized (object) {
            if (!this.msgResourceMap.containsKey(mapkey)) {
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle(MSGFILE, loc);
                    this.msgResourceMap.put(mapkey, bundle);
                    return bundle;
                }
                catch (MissingResourceException e) {
                    e.printStackTrace();
                }
            }
            return this.msgResourceMap.get(mapkey);
        }
    }
}

