/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.DispatcherConnectionManager;
import com.ibm.cognos.bux.buxservice.BUXServiceBaseHandler;
import com.ibm.cognos.bux.buxservice.BUXServiceMessage;
import com.ibm.cognos.bux.buxservice.GlobalConfig;
import com.ibm.cognos.bux.buxservice.dom4j.BUXSessionHandler;
import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;

public abstract class BUXSessionBaseHandler
extends BasicHandler {
    private static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    private static final String CC_SESSION_COOKIE = "cc_session";
    private String dispatcherUrl;
    private ConnectionManager connectionManager = new ConnectionManager();
    private static Logger logger = IPFTraceLoggerFactory.getInstance().getLogger(BUXSessionHandler.class.getName());

    public BUXSessionBaseHandler() {
        super(null);
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void configure(Configuration configuration) {
        ICCLConfiguration cclConfiguration = configuration.getICCLConfiguration();
        String localeString = null;
        try {
            localeString = cclConfiguration.getValue("serverLocale", true);
            this.dispatcherUrl = cclConfiguration.getValue("internalDispatcher", true);
        }
        catch (Throwable e) {
            String message = BUXServiceMessage.getInstance().getMessage(GlobalConfig.toLocale(localeString), "bux.error.SESSIONHANDLER_CONFIG");
            logger.error(BUXServiceBaseHandler.class.getName(), message, e, null);
        }
    }

    public void reconfigure(Configuration configuration) {
        this.configure(configuration);
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        Cookie ccSession;
        BIBusEnvelope env = (BIBusEnvelope)mc.getProperty("request.envelope");
        String session = env.getCookieValue(CC_SESSION_COOKIE);
        if (session == null) {
            session = env.getSetCookieValue(CC_SESSION_COOKIE);
        }
        if (session == null && (ccSession = this.retrieveCCSessionCookie(env)) != null) {
            env.addSetCookie(ccSession);
        }
    }

    protected abstract MsgBodyGenerator createMsgBodyGenerator(BIBusEnvelope var1);

    protected abstract void addCookies(BIBusEnvelope var1, BIBusEnvelope var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cookie retrieveCCSessionCookie(BIBusEnvelope env) {
        Cookie cc_session = null;
        ServerConnection connection = null;
        try {
            BIBusEnvelope request = new BIBusEnvelope();
            request.setFormField("b_action", "xts.run");
            request.setFormField("m", "portal/main.xts");
            connection = this.connectionManager.getConnection();
            connection.setRequestBodySource(this.createMsgBodyGenerator(request));
            this.addCookies(env, request);
            connection.setRequestHeader("Content-Type", "text/xml");
            connection.setRequestHeader("SOAPAction", "xts.run");
            connection.sendRequest(this.dispatcherUrl);
            cc_session = this.scanResponseHeaders(connection.getResponseHeaders());
        }
        catch (Exception e) {
            String message = BUXServiceMessage.getInstance().getMessage(GlobalConfig.toLocale(env.getEnvironmentValue("productLocale")), "bux.error.SESSIONHANDLER_GENERAL");
            logger.error(BUXServiceBaseHandler.class.getName(), message, (Throwable)e, null);
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        return cc_session;
    }

    private Cookie scanResponseHeaders(Header[] headers) {
        for (Header header : headers) {
            HeaderElement[] headerElements;
            if (!HTTP_HEADER_SET_COOKIE.equals(header.getName())) continue;
            for (HeaderElement headerElement : headerElements = header.getElements()) {
                if (!CC_SESSION_COOKIE.equals(headerElement.getName())) continue;
                return this.readCookieHeader(headerElement);
            }
        }
        return null;
    }

    private Cookie readCookieHeader(HeaderElement headerElement) {
        Cookie cookie = new Cookie();
        cookie.setName(headerElement.getName());
        cookie.setValue(headerElement.getValue());
        return cookie;
    }

    public static class ConnectionManager {
        public ServerConnection getConnection() {
            return DispatcherConnectionManager.getLocalDispatcherConnection();
        }
    }
}

