/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.NameValuePair;
import com.ibm.cognos.bux.buxservice.BIBusEnvelopeDuplicator;
import com.ibm.cognos.bux.buxservice.BiBusRequestPartsEnumImpl;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequest;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestCookie;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestPart;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import org.w3c.dom.Element;

public abstract class BiBusBaseRequest
implements BiBusRequest,
BIBusEnvelopeDuplicator {
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private String pathInfo;
    private String host;
    private String port;
    private String servletURI;
    private String servletContext;
    private String webContentRoot;
    private Map<String, String[]> requestHeaders;
    private List<BiBusRequestCookie> cookies;
    private Map<String, String[]> requestParameters;
    private String webScriptName;
    private String originalSOAPAction;
    private String originalWebProtocol;
    private String contentType;
    private InputStream contentStream;
    private final String gatewayURL;
    private String httpRequestMethod;
    private Element biBusHeaderElement;
    private final BIBusEnvelope requestEnvelope;
    private final Locale productLocale;
    private final Locale contentLocale;
    private Iterator<InputStream> attachmentsIter;
    private BiBusRequest.BiBusUserRole currentUserRole;

    public BiBusBaseRequest(MessageContext mc, String gatewayURL, Locale productLocale, Locale contentLocale) {
        this.gatewayURL = gatewayURL;
        this.biBusHeaderElement = null;
        this.productLocale = productLocale;
        this.contentLocale = contentLocale;
        this.requestEnvelope = (BIBusEnvelope)(null == mc ? null : mc.getProperty("request.envelope"));
        if (null != mc) {
            this.populateVariables(mc);
            this.populateRequestInternetHeaders(mc);
            this.populateRequestParameters(mc);
            this.populateCookies(mc);
            this.attachmentsIter = (Iterator)mc.getProperty("request.attachments");
            this.populateContentStream(mc, this.attachmentsIter);
        }
    }

    private void populateContentStream(MessageContext mc, Iterator<InputStream> itr) {
        BiBusRequestPartsEnumImpl enumParts;
        this.contentStream = (InputStream)mc.getProperty("request.body");
        if (this.contentStream == null && (enumParts = new BiBusRequestPartsEnumImpl(itr)).hasMoreElements()) {
            BiBusRequestPart part = enumParts.nextElement();
            this.contentStream = part.getContent();
        }
    }

    protected void setCookies(List<BiBusRequestCookie> cookies) {
        this.cookies = cookies;
    }

    protected void populateVariables(MessageContext mc) {
        this.servletURI = (String)mc.getProperty("servlet.requestURI");
        this.webContentRoot = (String)mc.getProperty("WEB_CONTENT_ROOT");
        this.pathInfo = (String)mc.getProperty("path_info");
        this.servletContext = "";
        if (null != this.requestEnvelope) {
            this.httpRequestMethod = this.requestEnvelope.getEnvironmentValue("REQUEST_METHOD");
            this.host = this.requestEnvelope.getEnvironmentValue("SERVER_NAME");
            this.port = this.requestEnvelope.getEnvironmentValue("SERVER_PORT");
            this.webScriptName = this.requestEnvelope.getEnvironmentValue("SCRIPT_NAME");
            this.originalSOAPAction = this.getSoapAction(mc, this.requestEnvelope);
            this.originalWebProtocol = this.requestEnvelope.getEnvironmentValue("SERVER_PROTOCOL");
        }
    }

    protected String getSoapAction(MessageContext mc, BIBusEnvelope envelope) {
        String soapAction = envelope.getDispatcherTransportValue("originalSOAPAction");
        if (soapAction == null || soapAction.length() == 0) {
            soapAction = (String)mc.getProperty("request.soapaction");
        }
        return soapAction;
    }

    protected void populateRequestParameters(MessageContext mc) {
        this.requestParameters = new HashMap<String, String[]>();
        if (null != this.requestEnvelope) {
            List formNameValuePairs = (List)BiBusBaseRequest.cast(this.requestEnvelope.getFormFieldValues());
            for (NameValuePair param : formNameValuePairs) {
                this.requestParameters.put(param.getName(), new String[]{param.getValue()});
            }
        }
    }

    protected void populateRequestInternetHeaders(MessageContext mc) {
        this.requestHeaders = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        InternetHeaders headers = (InternetHeaders)mc.getProperty("request.headers");
        if (null != headers) {
            Enumeration headerEnum = (Enumeration)BiBusBaseRequest.cast(headers.getAllHeaders());
            while (headerEnum.hasMoreElements()) {
                Header header = (Header)headerEnum.nextElement();
                String headerName = header.getName();
                String[] valueList = headers.getHeader(headerName);
                this.requestHeaders.put(headerName, valueList);
            }
            this.readContentType(this.requestHeaders.get("Content-Type"));
        }
    }

    protected void readContentType(String[] contentTypeValues) {
        if (null != contentTypeValues && contentTypeValues.length > 0) {
            String temp = contentTypeValues[0];
            int j = temp.indexOf(59);
            if (j != -1) {
                temp = temp.substring(0, j);
            }
            this.contentType = MULTIPART_FORM_DATA.equalsIgnoreCase(temp) ? temp : contentTypeValues[0];
        }
    }

    public Map<String, String[]> getRequestParameters() {
        return this.requestParameters;
    }

    public String getContext() {
        return this.servletContext;
    }

    public String getHost() {
        return this.host;
    }

    public Map<String, String[]> getHttpRequestHeaders() {
        return this.requestHeaders;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPort() {
        return this.port;
    }

    public String getServletURI() {
        return this.servletURI;
    }

    public String getWebContentRoot() {
        return this.webContentRoot;
    }

    public List<BiBusRequestCookie> getCookies() {
        return this.cookies;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getOriginalSOAPAction() {
        return this.originalSOAPAction;
    }

    public String getOriginalWebProtocol() {
        return this.originalWebProtocol;
    }

    public String getWebScriptName() {
        return this.webScriptName;
    }

    public InputStream getPostXmlData() {
        return this.contentStream;
    }

    public String getHttpRequestMethod() {
        return this.httpRequestMethod;
    }

    public String getGatewayURL() {
        return this.gatewayURL;
    }

    public Element getBiBusHeader() {
        if (null == this.biBusHeaderElement && null != this.requestEnvelope) {
            this.biBusHeaderElement = this.getBiBusDomHeader(this.requestEnvelope);
        }
        return this.biBusHeaderElement;
    }

    public Locale getProductLocale() {
        return this.productLocale;
    }

    public Locale getContentLocale() {
        return this.contentLocale;
    }

    public Enumeration<BiBusRequestPart> getRequestParts() {
        BiBusRequestPartsEnumImpl parts = null;
        if (null != this.attachmentsIter && MULTIPART_FORM_DATA.equalsIgnoreCase(this.contentType)) {
            parts = new BiBusRequestPartsEnumImpl(this.attachmentsIter);
        }
        return parts;
    }

    public void setCurrentUserRole(BiBusRequest.BiBusUserRole userRole) {
        this.currentUserRole = userRole;
    }

    public BiBusRequest.BiBusUserRole getUserRole() {
        return this.currentUserRole;
    }

    protected abstract void populateCookies(MessageContext var1);

    public BIBusEnvelope getRequestEnvelope() {
        return this.requestEnvelope;
    }

    protected abstract Element getBiBusDomHeader(BIBusEnvelope var1);

    protected static <T> T cast(Object a) {
        return (T)a;
    }
}

