/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice;

import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.Tracking;
import com.ibm.cognos.bux.buxservice.BiBusBaseRequest;
import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusPlatformServices;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public class BiBusPlatformServicesImpl
extends BiBusPlatformServices {
    private PogoEngine engine;
    private HashMap<String, Handler> handlers = new HashMap();
    private static Logger logger = IPFTraceLoggerFactory.getInstance().getLogger(BiBusPlatformServicesImpl.class.getName());

    public BiBusPlatformServicesImpl(PogoEngine _bhPogoEngine) {
        this.engine = _bhPogoEngine;
    }

    public void invokeLocalService_dom4j(Object requestHandle, Object envelopeHandle, String handlerName, Map<String, String> params) {
        BiBusBaseRequest orgRequest = (BiBusBaseRequest)requestHandle;
        BIBusEnvelope envelope = (BIBusEnvelope)envelopeHandle;
        if (null != orgRequest && null != envelope) {
            Handler handler = this.lookupHandler(handlerName);
            if (null != handler) {
                MessageContextImpl mc = new MessageContextImpl();
                this.prepareRequest(params, (MessageContext)mc, envelope);
                try {
                    handler.invoke((MessageContext)mc);
                }
                catch (PogoException e) {
                    logger.error(BiBusPlatformServicesImpl.class.getName(), "Failure invoking handler", (Throwable)e, null);
                    throw new RuntimeException(e);
                }
            } else {
                StringBuilder msg = new StringBuilder("Handler not found: ").append(handlerName);
                logger.info(BiBusPlatformServicesImpl.class.getName(), msg.toString(), null);
            }
        }
    }

    private void prepareRequest(Map<String, String> params, MessageContext mc, BIBusEnvelope requestEnvelope) {
        this.removeUnnecessaryInfo(requestEnvelope);
        for (Map.Entry<String, String> param : params.entrySet()) {
            requestEnvelope.setFormField(param.getKey(), param.getValue());
        }
        mc.setProperty("request.envelope", (Object)requestEnvelope);
    }

    private void removeUnnecessaryInfo(BIBusEnvelope requestEnvelope) {
        Element setCookies = requestEnvelope.getSetCookieVars();
        if (null != setCookies) {
            setCookies.clearContent();
        }
        requestEnvelope.getBiBusHeader().getHdrSession().getFormFieldVars().clear();
        requestEnvelope.getBiBusHeader().getHdrSession().getFormFieldVars();
    }

    private synchronized Handler lookupHandler(String handlerName) {
        Handler handler = this.handlers.get(handlerName);
        if (null == handler) {
            handler = this.engine.lookupHandler(handlerName);
            this.handlers.put(handlerName, handler);
        }
        return handler;
    }

    public String getNodeId() {
        return Tracking.getInstance().getRequestIDBaseName();
    }

    public Object getRequestEnvelope_dom4j(Object requestHandle) {
        BIBusEnvelope envelope = null;
        BiBusBaseRequest orgRequest = (BiBusBaseRequest)requestHandle;
        if (null != orgRequest) {
            envelope = orgRequest.createDom4jEnvelopeCopy();
        }
        return envelope;
    }

    public Object copyRequestEnvelope_dom4j(Object envelopeHandle) throws Exception {
        BIBusEnvelope envelope = (BIBusEnvelope)envelopeHandle;
        BIBusEnvelope ret = (BIBusEnvelope)envelope.clone();
        ret.getHeader();
        ret.getBody();
        return ret;
    }
}

