/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.caf.CAFLibrary;
import com.cognos.caf.CAFLibraryException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.CAFFactory;
import com.cognos.pogo.pdk.Configuration;
import com.ibm.cognos.bux.buxservice.BUXRequestParameters;
import com.ibm.cognos.bux.buxservice.BUXRequestValidator;
import com.ibm.cognos.bux.buxservice.BUXServiceException;
import com.ibm.cognos.bux.buxservice.BUXServiceMessage;
import com.ibm.cognos.bux.buxservice.logging.IPFManager;
import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusConfigUpdateListener;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusGlobalConfig;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import com.ibm.cognos.i18n.util.Bidi;
import com.ibm.cognos.internal.ombridge.BridgeHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class GlobalConfig
extends BiBusGlobalConfig {
    public static final String DEFAULT_LOCALE = "en";
    private static final String URL_SEPARATOR = "/";
    private static final String DOT = ".";
    private static final String WILD_CARD = "*";
    private static final String COLON = ":";
    private static final String GATEWAY = "gateway";
    private static final String SERVER_LOCALE = "serverLocale";
    private static final String PARAMETER = "parameter";
    private static final String VALUE = "value";
    private static final String CRN = "crn";
    private static final String CAF = "CAF";
    private static final String CONTENT_MANAGERS = "contentManagers";
    private static final String EXTERNAL_DISPATCHER = "externalDispatcher";
    private static final String INTERNAL_DISPATCHER = "internalDispatcher";
    private static final String CONTROLLER_SERVER_URI = "controllerServerURI";
    private static final String SDK_URI = "sdk";
    private static final String DSSOAPSERVER_URI = "DSSOAPServerURI";
    private static final String GATEWAYDISPATCHER_URIS = "gatewayDispatcherURIList";
    private static final String CAF_ENABLED = "caf_enabled";
    private static final String PRODUCT_LOCALE_LIST = "productLocaleList";
    private static final String CONTENT_LOCALE_LIST = "contentLocaleList";
    private static final String TIME_ZONE_LIST = "timezoneList";
    private static final String LCON_FEATUREURI_KEY_PREFIX = "lc_";
    private static final String LCON_FEATUREURI_KEY_POSTFIX = "_uri";
    private static final String TEMP = "temp";
    private static Logger logger = IPFTraceLoggerFactory.getInstance().getLogger(GlobalConfig.class.getName());
    private static CAFFactory cafFactory;
    private static CAMFactory camFactory;
    private String serverLocaleStr = null;
    private Locale serverLocale = null;
    private String gatewayURL = null;
    protected List<String> safeDomainList = null;
    private List<String> contentManagerList = null;
    private String dispatcherURI = null;
    private List<BiBusConfigUpdateListener> updateListeners = new ArrayList<BiBusConfigUpdateListener>(1);
    private boolean isCAFEnabled = false;
    private boolean isXSSCheckEnabled = false;
    private String[] localHostIPAddr;
    private String[] localHostName;
    private Configuration configuration;
    private String eclipseFolderBasePath;
    private String platformBasePath;
    private BUXRequestValidator m_brv = null;
    private Set<String> allDispRelatedURIs;
    private Set<String> lcURLsHosts;
    private String tempFolderPath;
    private Properties icdProperties;

    public GlobalConfig() {
        this.readLocalhostAlternateNames();
    }

    public static Locale toLocale(String locale) {
        String _locale;
        Locale result = null;
        if (locale != null && (_locale = locale.trim()).length() > 0) {
            int idx = _locale.indexOf(45);
            result = idx != -1 ? new Locale(_locale.substring(0, idx), _locale.substring(idx + 1)) : new Locale(_locale);
        }
        return result;
    }

    private void readLocalhostAlternateNames() {
        InetAddress[] addrs = null;
        try {
            addrs = InetAddress.getAllByName(null);
            if (null != addrs) {
                this.localHostIPAddr = new String[addrs.length];
                this.localHostName = new String[addrs.length];
                for (int i = 0; i < addrs.length; ++i) {
                    this.localHostIPAddr[i] = addrs[i].getHostAddress();
                    this.localHostName[i] = addrs[i].getHostName();
                }
            }
        }
        catch (UnknownHostException e) {
            String message = BUXServiceMessage.getInstance().getMessage(this.getServerLocale(), "bux.error.UnableToGetLocalHostName");
            logger.error(((Object)((Object)this)).getClass().getName(), message, (Throwable)e, null);
        }
    }

    @Deprecated
    public boolean isSafeDomain(String domain) {
        return this.isSafeDomainUrl(domain);
    }

    public boolean isSafeDomainUrl(String url) {
        boolean isSafe = false;
        if (null != url) {
            String targetUrl = url.toLowerCase();
            if (this.isRequestDomainInLCURLList(targetUrl)) {
                isSafe = true;
            } else {
                try {
                    if (this.m_brv != null) {
                        BUXRequestParameters reqParams = new BUXRequestParameters();
                        reqParams.addParameter("url", targetUrl);
                        this.m_brv.validateParameters(reqParams);
                    }
                    isSafe = true;
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        logger.error(((Object)((Object)this)).getClass().getName(), e.getCause().getMessage(), (Throwable)e, null);
                    }
                    logger.error(((Object)((Object)this)).getClass().getName(), e.getMessage(), (Throwable)e, null);
                }
            }
        }
        return isSafe;
    }

    private synchronized boolean isRequestDomainInLCURLList(String url) {
        boolean isSafe = false;
        if (null != this.lcURLsHosts) {
            String targetHost = GlobalConfig.extractHostPort(url);
            for (String host : this.lcURLsHosts) {
                if (!GlobalConfig.isDomainMatch(targetHost, host)) continue;
                isSafe = true;
                break;
            }
        }
        return isSafe;
    }

    private synchronized void readLCURLHosts(ICCLConfiguration cclConfiguration) {
        try {
            for (LCONFeatureEnum feature : LCONFeatureEnum.values()) {
                String key = LCON_FEATUREURI_KEY_PREFIX + (Object)((Object)feature) + LCON_FEATUREURI_KEY_POSTFIX;
                String hostAndPort = GlobalConfig.extractHostPort(cclConfiguration.getValue(key, true));
                if (null == hostAndPort) continue;
                GlobalConfig.addSafelyEntry(this.lcURLsHosts, hostAndPort);
            }
        }
        catch (Exception e) {
            logger.error(((Object)((Object)this)).getClass().getName(), e.getLocalizedMessage(), (Throwable)e, null);
        }
    }

    private static String extractHostPort(String url) {
        String hostPort = null;
        if (url != null && url.length() > 0) {
            String urlStr = url.toLowerCase();
            int indexScheme = urlStr.indexOf("://");
            int indexSlash = urlStr.indexOf(URL_SEPARATOR);
            if (indexScheme > 0 && indexScheme < indexSlash) {
                indexSlash = urlStr.indexOf(47, indexScheme + 3);
                if (indexSlash == -1) {
                    indexSlash = urlStr.length();
                }
                if (indexSlash > indexScheme + 3) {
                    hostPort = urlStr.substring(indexScheme + 3, indexSlash);
                }
            }
        }
        return hostPort;
    }

    private static boolean isDomainMatch(String inputDomain, String safedomain) {
        String clean_safeDomain;
        boolean hasDot = false;
        boolean startsWithDot = false;
        boolean startsWithWildcard = false;
        int safeDomainLength = safedomain.length();
        if (safedomain.charAt(0) == DOT.charAt(0)) {
            startsWithDot = true;
            clean_safeDomain = safedomain.substring(1);
        } else if (safedomain.charAt(0) == WILD_CARD.charAt(0)) {
            startsWithWildcard = true;
            clean_safeDomain = safedomain.substring(1);
            if (clean_safeDomain.charAt(0) == DOT.charAt(0)) {
                hasDot = true;
                clean_safeDomain = clean_safeDomain.substring(1);
            }
        } else {
            clean_safeDomain = safedomain;
        }
        int pos_domain_start = inputDomain.indexOf(clean_safeDomain);
        boolean matchFound = pos_domain_start != -1;
        String clean_inputDomain = inputDomain;
        if (matchFound) {
            int inputDomain_port_pos = inputDomain.indexOf(COLON);
            int clean_safeDomain_port_pos = clean_safeDomain.indexOf(COLON);
            if (-1 != inputDomain_port_pos && -1 == clean_safeDomain_port_pos) {
                String inputDomainPort = inputDomain.substring(inputDomain_port_pos + 1);
                try {
                    if (Integer.parseInt(inputDomainPort) >= 0) {
                        clean_inputDomain = inputDomain.substring(0, inputDomain_port_pos);
                    }
                }
                catch (NumberFormatException e) {
                    matchFound = false;
                }
            }
            if (startsWithDot) {
                if (clean_inputDomain.length() == safeDomainLength - 1) {
                    matchFound = false;
                } else {
                    String clean_inputDomain_prefix = clean_inputDomain.substring(0, pos_domain_start - 1);
                    String clean_inputDomain_suffix = clean_inputDomain.substring(pos_domain_start);
                    matchFound = -1 != clean_inputDomain_prefix.indexOf(DOT) ? false : (clean_inputDomain_prefix.length() > 0 && clean_inputDomain.charAt(pos_domain_start - 1) == '.' ? clean_inputDomain_suffix.length() == safeDomainLength - 1 : false);
                }
            } else {
                matchFound = startsWithWildcard ? (hasDot && pos_domain_start > 0 && clean_inputDomain.charAt(pos_domain_start - 1) != '.' ? false : (hasDot && clean_inputDomain.length() == clean_safeDomain.length() ? false : clean_inputDomain.endsWith(clean_safeDomain))) : clean_inputDomain.length() == safeDomainLength;
            }
        }
        return matchFound;
    }

    public String getGatewayURL() {
        return this.gatewayURL;
    }

    public Locale getServerLocale() {
        if (null == this.serverLocale) {
            this.serverLocale = GlobalConfig.toLocale(null == this.serverLocaleStr ? DEFAULT_LOCALE : this.serverLocaleStr);
        }
        return this.serverLocale;
    }

    public List<String> getSafeDomainList() {
        return this.safeDomainList;
    }

    public void setSafeDomainList(Set<String> vcHosts, Set<String> exactDomainList, Set<String> highLevelDomainList) {
        int size = 0;
        HashSet<String> validatorDomainList = new HashSet<String>();
        GlobalConfig.readValidatorDomainList(validatorDomainList, exactDomainList, highLevelDomainList);
        if (vcHosts != null) {
            size = vcHosts.size();
        }
        ArrayList<String> list = new ArrayList<String>(size += validatorDomainList.size());
        GlobalConfig.readList(list, vcHosts);
        GlobalConfig.readList(list, validatorDomainList);
        this.safeDomainList = list;
    }

    private static void readList(List<String> list, Set<String> vc) {
        if (vc != null) {
            for (String entry : vc) {
                GlobalConfig.addSafelyEntry(list, entry);
            }
        }
    }

    private static void readValidatorDomainList(Set<String> vcDomains, Set<String> exactDomainList, Set<String> highLevelDomainList) {
        GlobalConfig.getValidatorDomainList(vcDomains, exactDomainList, highLevelDomainList);
    }

    private static void getValidatorDomainList(Set<String> vcDomains, Set<String> exactDomainList, Set<String> highLevelDomainList) {
        vcDomains.addAll(exactDomainList);
        for (String highLevelDomain : highLevelDomainList) {
            vcDomains.add(WILD_CARD + highLevelDomain);
        }
    }

    public void setBUXValidator(BUXRequestValidator brv) {
        this.m_brv = brv;
    }

    public List<String> getContentManagers() {
        return this.contentManagerList;
    }

    public String getDispatcherURI() {
        return this.dispatcherURI;
    }

    public void readConfigurationParameters() {
        try {
            ICCLConfiguration cclConfiguration = this.getConfiguration().getICCLConfiguration();
            IPFManager.configure(cclConfiguration);
            this.eclipseFolderBasePath = cclConfiguration.resolveEffectivePath("../webapps/p2pd/");
            this.tempFolderPath = cclConfiguration.getValue(TEMP, true);
            this.platformBasePath = cclConfiguration.resolveEffectivePath("../");
            this.gatewayURL = cclConfiguration.getValue(GATEWAY, true, true);
            this.serverLocaleStr = cclConfiguration.getValue(SERVER_LOCALE, true);
            Element section = cclConfiguration.getValueElement(CAF, false);
            this.readCafEnabledFlag(section);
            Element contentManagersElement = cclConfiguration.getValueElement(CONTENT_MANAGERS, false);
            this.readContentManagersList(contentManagersElement);
            Element externalDispatcherURI = cclConfiguration.getValueElement(EXTERNAL_DISPATCHER, false);
            this.readDispatcherURI(externalDispatcherURI);
            this.readAllDispatcherRelatedURIs(cclConfiguration);
            this.lcURLsHosts = new HashSet<String>();
            this.readLCURLHosts(cclConfiguration);
        }
        catch (CCLConfigurationException e) {
            String message = BUXServiceMessage.getInstance().getMessage(this.getServerLocale(), "bux.error.ConfigurationException");
            if (null != logger) {
                logger.error(((Object)((Object)this)).getClass().getName(), message, (Throwable)e, null);
            }
        }
        catch (Exception e) {
            logger.error(((Object)((Object)this)).getClass().getName(), e.getLocalizedMessage(), (Throwable)e, null);
        }
    }

    private void readAllDispatcherRelatedURIs(ICCLConfiguration cclConfiguration) throws CCLConfigurationException {
        this.allDispRelatedURIs = new HashSet<String>();
        GlobalConfig.addSafelyEntry(this.allDispRelatedURIs, this.dispatcherURI);
        GlobalConfig.addSafelyEntry(this.allDispRelatedURIs, this.gatewayURL);
        GlobalConfig.addSafelyEntry(this.allDispRelatedURIs, GlobalConfig.readConfigValueElement(cclConfiguration, INTERNAL_DISPATCHER));
        GlobalConfig.addSafelyEntry(this.allDispRelatedURIs, GlobalConfig.readConfigValueElement(cclConfiguration, CONTROLLER_SERVER_URI));
        GlobalConfig.addSafelyEntry(this.allDispRelatedURIs, GlobalConfig.readConfigValueElement(cclConfiguration, SDK_URI));
        GlobalConfig.addSafelyEntry(this.allDispRelatedURIs, GlobalConfig.readConfigValueElement(cclConfiguration, DSSOAPSERVER_URI));
        for (String item : this.contentManagerList) {
            GlobalConfig.addSafelyEntry(this.allDispRelatedURIs, item);
        }
        Element gatewayDispatcherURIListElement = cclConfiguration.getValueElement(GATEWAYDISPATCHER_URIS, false);
        GlobalConfig.readItemsFromElement(gatewayDispatcherURIListElement, this.allDispRelatedURIs);
    }

    private static String readConfigValueElement(ICCLConfiguration cclConfiguration, String elemName) throws CCLConfigurationException {
        Element uri = cclConfiguration.getValueElement(elemName, false);
        return GlobalConfig.getStringValue(uri);
    }

    private static String getStringValue(Element elem) {
        String val = null;
        if (null != elem) {
            val = elem.getText();
        }
        return val;
    }

    private void readCafEnabledFlag(Element section) {
        int size;
        List<Element> parameters;
        this.isCAFEnabled = false;
        if (null != section && null != (parameters = GlobalConfig.extractParameters(section)) && (size = parameters.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                Element parameterNode = parameters.get(i);
                Attribute nameAttr = (Attribute)parameterNode.selectSingleNode("@name");
                String nameAttrValue = nameAttr.getValue();
                if (CAF_ENABLED.equals(nameAttrValue)) {
                    this.isCAFEnabled = GlobalConfig.readBooleanValue(parameterNode);
                    continue;
                }
                if (!"caf_tpXSSCheckingUsed".equals(nameAttrValue)) continue;
                this.isXSSCheckEnabled = GlobalConfig.readBooleanValue(parameterNode);
            }
        }
    }

    private static boolean readBooleanValue(Element parameterNode) {
        String content;
        boolean returnValue = false;
        Namespace nsCRN = new Namespace(CRN, "http://developer.cognos.com/schemas/crconfig/1/");
        QName qnValue = new QName(VALUE, nsCRN);
        Element value = parameterNode.element(qnValue);
        if (null != value && null != (content = value.getText())) {
            returnValue = Boolean.parseBoolean(content);
        }
        return returnValue;
    }

    private static List<Element> extractParameters(Element section) {
        Namespace nsCRN = new Namespace(CRN, "http://developer.cognos.com/schemas/crconfig/1/");
        QName qnParameter = new QName(PARAMETER, nsCRN);
        return section.elements(qnParameter);
    }

    public void addConfigUpdateListener(BiBusConfigUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void cleanup() {
        this.updateListeners.clear();
    }

    public void onReconfigure() {
        if (this.m_brv != null) {
            GlobalConfig globalConfig = this;
            globalConfig.m_brv.resetBUXClientValidDomain();
        }
        this.icdProperties = this.readProperties();
        Iterator<BiBusConfigUpdateListener> iterListener = null;
        iterListener = this.updateListeners.iterator();
        while (iterListener.hasNext()) {
            iterListener.next().onReconfigure((BiBusGlobalConfig)this);
        }
    }

    private void readDispatcherURI(Element externalDispatcherURI) {
        if (null != externalDispatcherURI) {
            this.dispatcherURI = externalDispatcherURI.getText();
        }
    }

    private void readContentManagersList(Element section) {
        this.contentManagerList = new ArrayList<String>(8);
        GlobalConfig.readItemsFromElement(section, this.contentManagerList);
    }

    private static void readItemsFromElement(Element section, Collection<String> set) {
        List itemNodes;
        if (null != section && null != set && null != (itemNodes = section.selectNodes("./crn:item"))) {
            for (Node item : itemNodes) {
                GlobalConfig.addSafelyEntry(set, item.getText());
            }
        }
    }

    private static void addSafelyEntry(Collection<String> list, String value) {
        String result;
        if (value != null && value.length() > 0 && !list.contains(result = value.toLowerCase())) {
            list.add(result);
        }
    }

    public boolean isCAFEnabled() {
        return this.isCAFEnabled;
    }

    public Configuration getConfiguration() throws Exception {
        if (this.configuration == null) {
            throw new Exception("Unable to resolve Configuration information");
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration1) {
        this.configuration = configuration1;
    }

    public Map<String, String> getTimeZoneList(String locale) {
        return this.getPropList(locale, TIME_ZONE_LIST);
    }

    public Map<String, String> getProductLocaleList(String locale) {
        return this.getPropList(locale, PRODUCT_LOCALE_LIST);
    }

    public Map<String, String> getContentLocaleList(String locale) {
        return this.getPropList(locale, CONTENT_LOCALE_LIST);
    }

    private Map<String, String> getPropList(String locale, String propType) {
        Map map = null;
        try {
            ICCLConfiguration cclConfiguration;
            Configuration cfg = this.getConfiguration();
            if (cfg != null && (cclConfiguration = cfg.getICCLConfiguration()) != null) {
                if (PRODUCT_LOCALE_LIST.compareTo(propType) == 0) {
                    map = cclConfiguration.getProductLocaleList(locale);
                }
                if (CONTENT_LOCALE_LIST.compareTo(propType) == 0) {
                    map = cclConfiguration.getContentLocaleList(locale);
                }
                if (TIME_ZONE_LIST.compareTo(propType) == 0) {
                    map = cclConfiguration.getTimeZones(locale);
                }
            }
        }
        catch (CCLConfigurationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public String getValue(String name, boolean decrypt) {
        String value;
        block3: {
            value = null;
            try {
                Configuration cfg = this.getConfiguration();
                if (cfg != null) {
                    ICCLConfiguration cclConfiguration = cfg.getICCLConfiguration();
                    value = cclConfiguration.getValue(name, decrypt);
                }
            }
            catch (Exception e) {
                if (null == logger) break block3;
                logger.error(((Object)((Object)this)).getClass().getName(), "An exception occurred while getting the configuration value for '" + name + "'", (Throwable)e, null);
            }
        }
        return value;
    }

    public String getEclipseFolderBasePath() {
        return this.eclipseFolderBasePath;
    }

    public String getPlatformBasePath() {
        return this.platformBasePath;
    }

    public String getCAFJSConfig() {
        if (this.isXSSCheckEnabled && this.isCAFEnabled) {
            try {
                String result = CAFLibrary.getJavascriptConfig();
                if (result != null) {
                    return "//CAF_JS_CONFIG\n" + result.trim();
                }
            }
            catch (CAFLibraryException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public Map<String, String> getLConFeaturesCFGURI() {
        TreeMap<String, String> lConFeaturesCFGURIs = new TreeMap<String, String>();
        try {
            ICCLConfiguration cclConfiguration = this.getConfiguration().getICCLConfiguration();
            for (LCONFeatureEnum feature : LCONFeatureEnum.values()) {
                String key = LCON_FEATUREURI_KEY_PREFIX + (Object)((Object)feature) + LCON_FEATUREURI_KEY_POSTFIX;
                lConFeaturesCFGURIs.put(key, cclConfiguration.getValue(key, true));
            }
        }
        catch (CCLConfigurationException e) {
            String message = BUXServiceMessage.getInstance().getMessage(this.getServerLocale(), "bux.error.ConfigurationException");
            logger.error(((Object)((Object)this)).getClass().getName(), message, (Throwable)e, null);
        }
        catch (Exception e) {
            logger.error(((Object)((Object)this)).getClass().getName(), e.getLocalizedMessage(), (Throwable)e, null);
        }
        return lConFeaturesCFGURIs;
    }

    public Set<String> getAllDispatcherRelatedURIs() {
        return Collections.unmodifiableSet(this.allDispRelatedURIs);
    }

    public boolean isServiceActive(String serviceName) throws Exception {
        Element runningState;
        boolean isActive = false;
        Element cmResponse = this.getConfiguration().getCmResponse(serviceName);
        if (cmResponse != null && (runningState = (Element)cmResponse.selectSingleNode("./item[contains(@*[local-name()='type'], '" + serviceName + "')]/runningState/value")) != null && "running".equalsIgnoreCase(runningState.getTextTrim())) {
            isActive = true;
        }
        return isActive;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public boolean isLocaleRTL(Locale locale) {
        return Bidi.isLocaleRTL((Locale)locale);
    }

    public String cafProtect(String action, String data) {
        if (null != cafFactory) {
            return cafFactory.protect(action, data);
        }
        return data;
    }

    public synchronized Properties getICDProperties() {
        if (null == this.icdProperties) {
            this.icdProperties = this.readProperties();
        }
        return this.icdProperties;
    }

    private synchronized Properties readProperties() {
        Properties ret = new Properties();
        String path = null;
        File file = new File(GlobalConfig.getGlobalConfig().getPlatformBasePath(), "configuration/icd/icd.properties");
        if (file.exists()) {
            path = file.getPath();
        }
        this.setDefaultICDProperties(ret);
        if (null != path && path.length() > 0) {
            this.loadProperties(path, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(String filePath, Properties props) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            props.load(in);
        }
        catch (IOException e) {
            this.setDefaultICDProperties(props);
        }
        finally {
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void setDefaultICDProperties(Properties props) {
        props.put("com.ibm.cognos.bux.service.main.expeditedWidgetLoad", "false");
    }

    public String getSOAPActionVersion() throws BUXServiceException {
        List versions = BridgeHandler.getSupportedVersions();
        if (!versions.isEmpty()) {
            return (String)versions.get(0);
        }
        throw new BUXServiceException("Unable to get Soap Action version", Locale.ENGLISH);
    }

    public byte[] getTrustedRequestPayload(byte[] payload, String serviceId) {
        if (payload != null && payload.length > 0) {
            try {
                TrustedRequestSession trustedRequestSession = camFactory.createTrustedSession();
                return trustedRequestSession.setMessageTrust(serviceId, payload);
            }
            catch (CAMCryptoException e1) {
                logger.error(((Object)((Object)this)).getClass().getName(), "Unable to call CAM to sign the bytes array with service ID:" + serviceId, (Throwable)e1, null);
            }
        }
        return null;
    }

    static {
        try {
            cafFactory = (CAFFactory)Class.forName("com.cognos.caf.CAFFirewall").newInstance();
        }
        catch (Exception e) {
            cafFactory = null;
            logger.error(GlobalConfig.class.getName(), "Unable to create com.cognos.caf.CAFFirewall object.", (Throwable)e, null);
        }
        try {
            camFactory = new CAMFactory();
            camFactory.initialize("<initializeDocument><serviceID>DBV</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoException e) {
            camFactory = null;
        }
    }

    private static enum LCONFeatureEnum {
        version,
        mobile,
        activities,
        profiles,
        personTag,
        dogear,
        search,
        blogs,
        homepage,
        news,
        communities,
        wikis,
        files;

    }
}

