/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.Envelope;
import com.ibm.cognos.bux.buxservice.BUXServiceBaseHandler;
import com.ibm.cognos.bux.buxservice.dom4j.BiBusRequestImpl;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusContext;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequest;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestContextParameters;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestCookie;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusResponseBase;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import utils.BUXUtils;

public class BUXServiceHandler
extends BUXServiceBaseHandler {
    private static final String PATH = "path";
    private static final String DOMAIN = "domain";
    private static final String SECURE = "secure";
    private static final String FAULT_CODE = "Server";
    private static final String ERROR = "error";
    private static final String SESSION_CONTEXT = ".//*[local-name()='sessionContext']";
    private static final String REQUEST_CONTEXT = ".//*[local-name()='requestContext']";

    @Override
    protected Envelope createResponse(MessageContext mc) {
        BIBusEnvelope requestEnvelope = this.getRequestEnvelope(mc);
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        requestEnvelope.moveHeaderTo((SOAPEnvelope)responseEnvelope);
        return responseEnvelope;
    }

    @Override
    protected BiBusRequest getBiBusRequestImpl(MessageContext mc) {
        BiBusRequestImpl request = new BiBusRequestImpl(mc, this.getGlobalConfig().getGatewayURL(), this.getProductLocale(mc), this.getContentLocale(mc));
        request.setCurrentUserRole(this.getCurrentUserRole(this.getRequestEnvelope(mc)));
        return request;
    }

    @Override
    protected BiBusRequest.BiBusUserRole getCurrentUserRole(BIBusEnvelope envelope) {
        BiBusRequest.BiBusUserRole userRole = BiBusRequest.BiBusUserRole.CONSUME;
        Element capabiltyCache = envelope.getUserCapabilitiesCache();
        Node node = capabiltyCache.selectSingleNode("./userCapabilities/item[.='canUseAdvancedDashboardFeatures']");
        userRole = node != null ? BiBusRequest.BiBusUserRole.ASSEMBLE : ((node = capabiltyCache.selectSingleNode("./userCapabilities/item[.='canUseInteractiveDashboardFeatures']")) != null ? BiBusRequest.BiBusUserRole.INTERACT : BiBusRequest.BiBusUserRole.CONSUME);
        return userRole;
    }

    @Override
    protected boolean hasCapability(BIBusEnvelope envelope) {
        Element capabiltyCache = envelope.getUserCapabilitiesCache();
        Node canuseDashboardViewerNode = capabiltyCache.selectSingleNode("./userCapabilities/item[.='canUseDashboardViewer']");
        return canuseDashboardViewerNode != null;
    }

    @Override
    protected void processCookies(BiBusResponseBase response, Envelope envelope) {
        List cookies = response.getCookies();
        if (cookies != null) {
            BIBusEnvelope responseEnvelope = (BIBusEnvelope)envelope;
            for (BiBusRequestCookie cookie : cookies) {
                String path;
                String domain;
                Element item = responseEnvelope.setSetCookie(cookie.getName(), cookie.getValue(), cookie.getMaxAge());
                if (null == item) continue;
                if (this.isCookieSecure()) {
                    Element secureElement = item.addElement(SECURE);
                    secureElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_BOOLEAN);
                    secureElement.setText(Boolean.toString(true));
                }
                if ((domain = cookie.getDomain()) != null && domain.length() > 0) {
                    Element domainElement = item.addElement(DOMAIN);
                    domainElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                    domainElement.setText(domain);
                }
                if ((path = cookie.getPath()) == null || path.length() <= 0) continue;
                Element pathElement = item.addElement(PATH);
                pathElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                pathElement.setText(path);
            }
        }
    }

    @Override
    protected BiBusContext getBiBusContext(BIBusEnvelope envelope) {
        BiBusRequestContextParameters details = new BiBusRequestContextParameters();
        details.setRequestID(BUXServiceHandler.getRequestID(envelope));
        details.setSessionID(BUXServiceHandler.getSessionID(envelope));
        return new BiBusContext(details);
    }

    @Override
    protected BIBusEnvelope createBusFaultResponseEnvelope(BIBusEnvelope requestEnvelope, String faultCodeText, String msgCode, String msgDetail, Throwable exceptionObj) {
        return BUXServiceHandler.getBusFaultResponseEnvelope(requestEnvelope, faultCodeText, msgCode, msgDetail, exceptionObj);
    }

    private static BIBusEnvelope getBusFaultResponseEnvelope(BIBusEnvelope requestEnvelope, String faultCodeText, String msgCode, String msgDetail, Throwable exceptionObj) {
        if (null == requestEnvelope) {
            return null;
        }
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        requestEnvelope.moveHeaderTo((SOAPEnvelope)responseEnvelope);
        Element fault = responseEnvelope.createFaultElement(FAULT_CODE, faultCodeText);
        Element elementException = BUXServiceHandler.createBusException(ERROR, msgCode);
        elementException.add(BUXServiceHandler.createBusMessage(msgDetail, 1));
        if (exceptionObj != null) {
            elementException.add(BUXServiceHandler.createBusMessage(BUXUtils.stringifyThrowable(exceptionObj), 1));
        }
        Element details = fault.element("detail");
        details.add(elementException);
        return responseEnvelope;
    }

    private static Element createBusException(String severity, String errorCode) {
        Element exception = DocumentHelper.createElement((QName)BIBusEnvelope.BUS_EXCEPTION);
        exception.addElement("severity").setText(severity);
        exception.addElement("errorCode").setText(errorCode);
        return exception;
    }

    private static Element createBusMessage(String msg, Integer nestingLevel) {
        Element message = DocumentHelper.createElement((QName)BIBusEnvelope.BUS_MESSAGE);
        message.addElement("nestingLevel").addText(nestingLevel.toString());
        message.addElement("messageString").addText(msg);
        return message;
    }

    private static String getRequestID(BIBusEnvelope requestEnvelope) {
        return BUXServiceHandler.getTrackingElement(requestEnvelope, REQUEST_CONTEXT);
    }

    private static String getSessionID(BIBusEnvelope requestEnvelope) {
        return BUXServiceHandler.getTrackingElement(requestEnvelope, SESSION_CONTEXT);
    }

    private static String getTrackingElement(BIBusEnvelope requestEnvelope, String path) {
        Element pathElement;
        Element trackingElement;
        String elementText = null;
        if (null != requestEnvelope && null != (trackingElement = requestEnvelope.getTracking()) && (pathElement = (Element)trackingElement.selectSingleNode(path)) != null) {
            elementText = pathElement.getText();
        }
        return elementText;
    }
}

