/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.dom4j;

import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.bux.buxservice.BUXSessionBaseHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Element;

public class BUXSessionHandler
extends BUXSessionBaseHandler {
    private static final String TAG_COOKIE_VALUE = "value";
    private static final String TAG_COOKIE_NAME = "name";
    private static final String TAG_COOKIE_ITEM = "item";

    @Override
    protected MsgBodyGenerator createMsgBodyGenerator(final BIBusEnvelope request) {
        return new MsgBodyGenerator(){

            public boolean rewind() {
                return false;
            }

            public void writeBody(OutputStream out) throws IOException {
                out.write(request.getAsString().getBytes("UTF8"));
            }
        };
    }

    @Override
    protected void addCookies(BIBusEnvelope env, BIBusEnvelope request) {
        HashSet<String> addedCookies = new HashSet<String>();
        this.addCookies(env.getSetCookieVars(), addedCookies, request);
        this.addCookies(env.getCookieVars(), addedCookies, request);
    }

    private void addCookies(Element setCookieVars, Set<String> addedCookies, BIBusEnvelope request) {
        Iterator itemsIterator = setCookieVars.elementIterator(TAG_COOKIE_ITEM);
        while (itemsIterator.hasNext()) {
            String cookieName;
            Element item = (Element)itemsIterator.next();
            Element nameElement = item.element(TAG_COOKIE_NAME);
            if (nameElement == null || addedCookies.contains(cookieName = nameElement.getText())) continue;
            addedCookies.add(cookieName);
            Element valueElement = item.element(TAG_COOKIE_VALUE);
            if (valueElement == null) continue;
            String value = valueElement.getText();
            request.setCookie(cookieName, value);
        }
    }
}

