/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.dom4j;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.bux.buxservice.BUXServiceMessage;
import com.ibm.cognos.bux.buxservice.BiBusBaseRequest;
import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestCookie;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.w3c.dom.Element;

public class BiBusRequestImpl
extends BiBusBaseRequest {
    public BiBusRequestImpl(MessageContext mc, String theGatewayURL, Locale productLocale, Locale contentLocale) {
        super(mc, theGatewayURL, productLocale, contentLocale);
    }

    @Override
    protected void populateCookies(MessageContext mc) {
        ArrayList<BiBusRequestCookie> cookies = new ArrayList<BiBusRequestCookie>(10);
        this.setCookies(cookies);
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        if (null != envelope) {
            org.dom4j.Element cookieVarsElement = envelope.getCookieVars();
            Iterator i = (Iterator)BiBusRequestImpl.cast(cookieVarsElement.elementIterator("item"));
            while (i.hasNext()) {
                org.dom4j.Element elementItem = (org.dom4j.Element)i.next();
                org.dom4j.Element elementName = elementItem.element("name");
                org.dom4j.Element elementValue = elementItem.element("value");
                if (null == elementName || null == elementValue) continue;
                BiBusRequestCookie cookie = new BiBusRequestCookie(elementName.getStringValue(), elementValue.getStringValue());
                cookies.add(cookie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Element getBiBusDomHeader(BIBusEnvelope envelope) {
        org.dom4j.Element biBusHeader = envelope.getBIBusHeader();
        try {
            biBusHeader.detach();
            Document doc = DocumentHelper.createDocument((org.dom4j.Element)biBusHeader);
            doc.setRootElement(biBusHeader);
            DOMWriter writer = new DOMWriter();
            org.w3c.dom.Document tempDoc = writer.write(doc);
            Element element = tempDoc.getDocumentElement();
            return element;
        }
        catch (DocumentException e) {
            String message = BUXServiceMessage.getInstance().getMessage(this.getProductLocale(), "bux.error.GetBiBusHeaderFailed");
            Logger logger = IPFTraceLoggerFactory.getInstance().getLogger(BiBusRequestImpl.class.getName());
            logger.error(BiBusRequestImpl.class.getName(), message, (Throwable)e, null);
            Element element = null;
            return element;
        }
        finally {
            envelope.setBIBusHeader(biBusHeader);
        }
    }

    @Override
    public BIBusEnvelope createDom4jEnvelopeCopy() {
        BIBusEnvelope envelope = this.getRequestEnvelope();
        org.dom4j.Element header = envelope.getHeader();
        if (null != header) {
            header = header.createCopy();
        }
        return new BIBusEnvelope(header);
    }
}

