/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.bux.buxservice.logging.IPFLogDetails;
import com.ibm.cognos.bux.buxservice.logging.IPFLoggerHelper;
import com.ibm.cognos.bux.osgibridge.delegate.AuditLogBaseDetails;
import com.ibm.cognos.bux.osgibridge.delegate.AuditLogDetails;
import com.ibm.cognos.bux.osgibridge.delegate.AuditLogLevel;
import com.ibm.cognos.bux.osgibridge.delegate.AuditLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class IPFAuditLogger
implements AuditLogger {
    private static final String COMPONENT_BUX = "BUX ";
    private static final int[] IPF_AUDIT_LOGLEVELS = new int[]{50000, 30000, 10000};
    private final LogTypedLogger auditLogger;
    private final LogTypedLogger auditAccessLogger;

    public IPFAuditLogger(String name, LogTypedLogger auditLogger1, LogTypedLogger auditAccessLogger1) {
        this.auditLogger = auditLogger1;
        this.auditAccessLogger = auditAccessLogger1;
    }

    public void auditLogSystemEvent(AuditLogDetails data) {
        if (this.isAuditLoggingEnabled_(50000)) {
            this.logAuditForLevels123(data, 50000);
        }
    }

    public void auditLogRequestLevelEvent(AuditLogDetails data) {
        if (this.isAuditLoggingEnabled_(30000)) {
            this.logAuditForLevels123(data, 30000);
        }
    }

    public void auditLogDetailed(AuditLogBaseDetails data, String functionName, String functionReturnedValue) {
        if (this.isAuditLoggingEnabled_(10000)) {
            this.logAuditDetailed(data, functionName, functionReturnedValue);
        }
    }

    public boolean isAuditLoggingEnabled(AuditLogLevel loggingLevel) {
        return this.isAuditLoggingEnabled_(this.getIPFLoggingLevel(loggingLevel));
    }

    private void logAuditForLevels123(AuditLogDetails data, int loggingLevel) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication(COMPONENT_BUX, IPFLoggerHelper.getInstance().getBUXBuildNo());
        ArrayList errorMessages = data.getErrorMessages();
        if (errorMessages != null && !errorMessages.isEmpty()) {
            indication.setErrorMessage(this.getAuditLogErrorMessage(errorMessages));
        }
        indication.setObjectType(data.getObjectType());
        indication.setObjectPath(data.getObjectPath());
        String logDataMessage = this.getLogDataForLevels123(data.getLogDataParameters());
        if (null != logDataMessage) {
            indication.setLogData(logDataMessage);
        }
        indication.setStatus(data.getStatus());
        this.setCommonAuditLogParameters((AuditLogBaseDetails)data, (LogAuditIndication)indication, loggingLevel);
        this.performAccessAuditLog((LogAuditIndication)indication);
    }

    private void logAuditDetailed(AuditLogBaseDetails data, String functionName, String functionReturnedValue) {
        LogAuditIndication indication = new LogAuditIndication(COMPONENT_BUX, IPFLoggerHelper.getInstance().getBUXBuildNo());
        String logData = this.getLogDataForLevel5(data, functionName, functionReturnedValue);
        if (null != logData) {
            indication.setLogData(logData);
        }
        this.setCommonAuditLogParameters(data, indication, 10000);
        this.performAuditLog(indication);
    }

    private void setCommonAuditLogParameters(AuditLogBaseDetails data, LogAuditIndication aind, int loggingLevel) {
        aind.setRequestID(data.getRequestID());
        aind.setSessionID(data.getSessionID());
        aind.setLevel(loggingLevel);
        aind.setOperation(IPFLogDetails.getIPFOperation(data.getIPFOperation()));
    }

    private String getAuditLogErrorMessage(ArrayList<String> errorMessages) {
        String returnValue = null;
        if (null != errorMessages && !errorMessages.isEmpty()) {
            StringBuilder strBuf = new StringBuilder();
            Iterator<String> msgIterator = errorMessages.iterator();
            strBuf.append("<messages>");
            while (msgIterator.hasNext()) {
                String msg = msgIterator.next().toString();
                strBuf.append("<message>");
                strBuf.append("<messageString>");
                strBuf.append(msg);
                strBuf.append("</messageString>");
                strBuf.append("</message>");
            }
            strBuf.append("</messages>");
            returnValue = strBuf.toString();
        }
        return returnValue;
    }

    private String getLogDataForLevel5(AuditLogBaseDetails data, String functionName, String functionReturnedValue) {
        String logData = null;
        if (null != data) {
            StringBuilder strBuf = new StringBuilder();
            this.addFunctionElement(functionName, strBuf);
            this.addReturnValue(functionReturnedValue, strBuf);
            this.getLogDataForLevels123(data.getLogDataParameters(), strBuf);
            strBuf.append("</function>");
            logData = strBuf.toString();
        }
        return logData;
    }

    private void addFunctionElement(String functionName, StringBuilder strBuf) {
        if (null != functionName) {
            strBuf.append("<function name=\"").append(functionName).append("\">");
        } else {
            strBuf.append("<function>");
        }
    }

    private void addReturnValue(String functionReturnedValue, StringBuilder strBuf) {
        strBuf.append("<returnvalue>").append("<![CDATA[").append(functionReturnedValue).append("]]></returnvalue>");
    }

    private String getLogDataForLevels123(Map<String, String> params) {
        String data = null;
        if (null != params) {
            StringBuilder strBuf = new StringBuilder();
            this.getLogDataForLevels123(params, strBuf);
            data = strBuf.toString();
        }
        return data;
    }

    private void getLogDataForLevels123(Map<String, String> params, StringBuilder strBuf) {
        if (params != null) {
            Iterator<String> keyIterator = params.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next().toString();
                strBuf.append(this.makeCDataItem(key, params.get(key)));
            }
        }
    }

    private Object makeCDataItem(String key, String value) {
        String curValue = value == null ? "Null" : value;
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("<item name=\"").append(key).append("\">").append("<![CDATA[").append(curValue).append("]]></item>");
        return strBuf;
    }

    protected void performAccessAuditLog(LogAuditIndication aind) {
        this.auditAccessLogger.log((Object)aind);
    }

    protected void performAuditLog(LogAuditIndication aind) {
        this.auditLogger.log((Object)aind);
    }

    private int getIPFLoggingLevel(AuditLogLevel loggingLevel) {
        int level = 50000;
        int i = loggingLevel.ordinal();
        if (i >= 0 && i < IPF_AUDIT_LOGLEVELS.length) {
            level = IPF_AUDIT_LOGLEVELS[i];
        }
        return level;
    }

    protected boolean isAuditLoggingEnabled_(int loggingLevel) {
        return null != this.auditAccessLogger && null != this.auditLogger && this.auditLogger.isEnabled(loggingLevel) && this.auditAccessLogger.isEnabled(loggingLevel);
    }
}

