/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.bux.buxservice.logging.IPFAuditLogger;
import com.ibm.cognos.bux.buxservice.logging.IPFBase;
import com.ibm.cognos.bux.osgibridge.delegate.AuditLogger;
import com.ibm.cognos.bux.osgibridge.delegate.AuditLoggerFactory;
import java.util.HashMap;
import java.util.Map;

public class IPFAuditLoggerFactory
extends IPFBase
implements AuditLoggerFactory {
    private static final String AUDIT_BUX = "Audit.Other.BUX";
    private Map<String, AuditLogger> auditLoggers;
    private static IPFAuditLoggerFactory theLoggerFactory = null;

    public static synchronized IPFAuditLoggerFactory getInstance() {
        if (null == theLoggerFactory) {
            theLoggerFactory = new IPFAuditLoggerFactory();
        }
        return theLoggerFactory;
    }

    public IPFAuditLoggerFactory() {
        this.init();
    }

    protected void init() {
        this.auditLoggers = new HashMap<String, AuditLogger>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditLogger getAuditLogger(String loggerName) {
        AuditLogger logger = null;
        String name = loggerName;
        name = null == name ? AUDIT_BUX : ("".equals(name) ? AUDIT_BUX : "Audit.Other.BUX." + name);
        Map<String, AuditLogger> map = this.auditLoggers;
        synchronized (map) {
            logger = this.auditLoggers.get(name);
            if (null == logger) {
                LogTypedLogger auditLogger = LogTypedLogger.getInstance((String)name, LogAuditIndication.class);
                LogTypedLogger auditAccessLogger = LogTypedLogger.getInstance((String)name, LogAuditAccessIndication.class);
                logger = this.createAuditLogger(name, auditLogger, auditAccessLogger);
                this.auditLoggers.put(name, logger);
            }
        }
        return logger;
    }

    protected AuditLogger createAuditLogger(String name, LogTypedLogger auditLogger, LogTypedLogger auditAccessLogger) {
        return new IPFAuditLogger(name, auditLogger, auditAccessLogger);
    }
}

