/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.logging;

import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusGlobalConfig;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class IPFLoggerHelper {
    private static final String BUX_VER_SHORTPATH = "vers";
    private static final String BUX_VER_FILENAME = "bux-all-app-inst.ver";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String VERSION_PREFIX = "VERSION";
    private static String bux_ver_filepath = null;
    private static BiBusGlobalConfig gc = BiBusGlobalConfig.getGlobalConfig();
    private static Logger logger = IPFTraceLoggerFactory.getInstance().getLogger(IPFLoggerHelper.class.getName());
    private static IPFLoggerHelper instance = null;
    private int buildNum = 1;

    private IPFLoggerHelper() {
    }

    public static IPFLoggerHelper getInstance() {
        if (instance == null) {
            instance = new IPFLoggerHelper();
        }
        return instance;
    }

    public static void setBuxVerFilepath() {
        String platformPath;
        if (gc != null && (platformPath = gc.getPlatformBasePath()) != null) {
            bux_ver_filepath = platformPath + FILE_SEPARATOR + BUX_VER_SHORTPATH + FILE_SEPARATOR + BUX_VER_FILENAME;
        }
    }

    public static void setBuxVerFilepath(String filePath) {
        bux_ver_filepath = filePath;
    }

    public static String getBuxVerFilepath() {
        if (bux_ver_filepath == null) {
            IPFLoggerHelper.setBuxVerFilepath();
        }
        return bux_ver_filepath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getBUXBuildNo() {
        BufferedReader in = null;
        if (this.buildNum > 1) {
            return this.buildNum;
        }
        try {
            String readLn = null;
            in = new BufferedReader(new FileReader(IPFLoggerHelper.getBuxVerFilepath()));
            while ((readLn = in.readLine()) != null) {
                if (!readLn.startsWith(VERSION_PREFIX)) continue;
                int lastIndexOfDot = readLn.lastIndexOf(46);
                int secondLastIndexOfDot = readLn.lastIndexOf(46, lastIndexOfDot - 1);
                this.buildNum = Integer.parseInt(readLn.substring(secondLastIndexOfDot + 1, lastIndexOfDot));
                break;
            }
        }
        catch (Exception e) {
            logger.error(IPFLoggerHelper.class.getName(), "Unable to resolve the version file at " + bux_ver_filepath, null);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(IPFLoggerHelper.class.getName(), "Unable to close buffer reader ", null);
                }
            }
        }
        return this.buildNum;
    }

    public void setBuildNum(int bn) {
        this.buildNum = bn;
    }
}

