/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.logging;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestContextParameters;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class IPFTraceLogger
implements Logger {
    private String name;
    private LogTypedLogger traceLogger = null;
    private static final String EXIT_TAG = "[EXIT] ";
    private static final String METHOD_SCOPE = "::";
    private static final String ENTER_TAG = "[ENTER] ";
    private static final String PREFIX_DEBUG = "[DEBUG] ";
    private static final String PREFIX_INFO = "[INFO] ";
    private static final String PREFIX_WARN = "[WARN] ";
    private static final String PREFIX_FATAL = "[FATAL] ";
    private static final String PREFIX_ERROR = "[ERROR] ";
    private static final String STACKTRACE = "\nStacktrace: ";
    private static final String HYPHEN = " - ";
    private static final String COMPONENT_BUX = "BUX ";
    private static final int BUILDNUM = 1;

    public IPFTraceLogger(String category, LogTypedLogger theTraceLogger) {
        this.name = category;
        this.traceLogger = theTraceLogger;
    }

    public String getName() {
        return this.name;
    }

    public void debug(String objectClassName, String message, BiBusRequestContextParameters details) {
        if (this.isDebugLogLevelEnabled()) {
            this.logTrace(10000, objectClassName, this.getDebugMessage(objectClassName, message, null), (byte)11, details);
        }
    }

    public void enter(String objectClassName, String method, BiBusRequestContextParameters details) {
        if (this.isDebugLogLevelEnabled()) {
            this.logTrace(10000, objectClassName, ENTER_TAG + objectClassName + METHOD_SCOPE + method, (byte)5, details);
        }
    }

    public void error(String objectClassName, String message, BiBusRequestContextParameters details) {
        if (this.isErrorLogLevelEnabled()) {
            this.logTrace(40000, objectClassName, this.getErrorMessage(objectClassName, message, null), (byte)11, details);
        }
    }

    public void error(String objectClassName, String message, Throwable cause, BiBusRequestContextParameters details) {
        if (this.isErrorLogLevelEnabled()) {
            this.logTrace(40000, objectClassName, this.getErrorMessage(objectClassName, message, cause), (byte)11, details);
        }
    }

    public void exit(String objectClassName, String method, BiBusRequestContextParameters details) {
        if (this.isDebugLogLevelEnabled()) {
            this.logTrace(10000, objectClassName, EXIT_TAG + objectClassName + METHOD_SCOPE + method, (byte)6, details);
        }
    }

    public void fatal(String objectClassName, String message, BiBusRequestContextParameters details) {
        if (this.isFatalLogLevelEnabled()) {
            this.logTrace(50000, objectClassName, this.getFatalMessage(objectClassName, message, null), (byte)11, details);
        }
    }

    public void fatal(String objectClassName, String message, Throwable cause, BiBusRequestContextParameters details) {
        if (this.isFatalLogLevelEnabled()) {
            this.logTrace(50000, objectClassName, this.getFatalMessage(objectClassName, message, cause), (byte)11, details);
        }
    }

    public void info(String objectClassName, String message, BiBusRequestContextParameters details) {
        if (this.isInfoLogLevelEnabled()) {
            this.logTrace(20000, objectClassName, this.getInfoMessage(objectClassName, message, null), (byte)11, details);
        }
    }

    public boolean isDebugLogLevelEnabled() {
        boolean returnValue = true;
        if (this.isTraceLoggerNull() || !this.traceLogger.isEnabled(10000)) {
            returnValue = false;
        }
        return returnValue;
    }

    public boolean isErrorLogLevelEnabled() {
        return !this.isTraceLoggerNull() && this.traceLogger.isEnabled(40000);
    }

    public boolean isFatalLogLevelEnabled() {
        return !this.isTraceLoggerNull() && this.traceLogger.isEnabled(50000);
    }

    public boolean isInfoLogLevelEnabled() {
        return !this.isTraceLoggerNull() && this.traceLogger.isEnabled(20000);
    }

    public boolean isWarnLogLevelEnabled() {
        return !this.isTraceLoggerNull() && this.traceLogger.isEnabled(30000);
    }

    public void warn(String objectClassName, String message, BiBusRequestContextParameters details) {
        if (this.isWarnLogLevelEnabled()) {
            this.logTrace(30000, objectClassName, this.getWarnMessage(objectClassName, message, null), (byte)11, details);
        }
    }

    private boolean isTraceLoggerNull() {
        return null == this.traceLogger;
    }

    private void setDispatcherRelatedFields(LogTraceIndication aind, BiBusRequestContextParameters details) {
        String sessionID = null;
        String requestID = null;
        if (null != details) {
            sessionID = details.getSessionID();
            requestID = details.getRequestID();
        }
        aind.setSessionID(sessionID);
        aind.setRequestID(requestID);
    }

    private void logTrace(int level, String objectClassName, String message, byte action, BiBusRequestContextParameters details) {
        LogTraceIndication aind = new LogTraceIndication(COMPONENT_BUX, 1);
        aind.setObject(null != objectClassName ? objectClassName : COMPONENT_BUX);
        aind.setAction(action);
        aind.setLevel(level);
        aind.setMessage(message);
        this.setDispatcherRelatedFields(aind, details);
        this.performTraceLog(aind);
    }

    private String getErrorMessage(String className, String message, Throwable cause) {
        return this.getMessage(PREFIX_ERROR, className, message, cause);
    }

    private String getFatalMessage(String className, String message, Throwable cause) {
        return this.getMessage(PREFIX_FATAL, className, message, cause);
    }

    private String getWarnMessage(String className, String message, Throwable cause) {
        return this.getMessage(PREFIX_WARN, className, message, cause);
    }

    private String getInfoMessage(String className, String message, Throwable cause) {
        return this.getMessage(PREFIX_INFO, className, message, cause);
    }

    private String getDebugMessage(String className, String message, Throwable cause) {
        return this.getMessage(PREFIX_DEBUG, className, message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessage(String prefix, String className, String message, Throwable cause) {
        StringWriter tmp = new StringWriter();
        PrintWriter pwrt = new PrintWriter(tmp);
        StringBuffer tracemsg = new StringBuffer();
        try {
            if (null != cause) {
                cause.printStackTrace(pwrt);
            }
            tracemsg.append(prefix).append(className).append(HYPHEN).append(message);
            if (null != cause) {
                tracemsg.append(STACKTRACE).append(tmp.toString());
            }
        }
        finally {
            pwrt.close();
        }
        return tracemsg.toString();
    }

    protected void performTraceLog(LogTraceIndication aind) {
        this.traceLogger.log((Object)aind);
    }
}

