/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.stax;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.common.BodyFault;
import com.cognos.pogo.pdk.common.BodyFaultException;
import com.cognos.pogo.pdk.common.BodyFaultMessage;
import com.cognos.pogo.pdk.common.BodyHandler;
import com.cognos.pogo.pdk.common.BodyHandlerFactory;
import com.cognos.pogo.pdk.common.Envelope;
import com.cognos.pogo.pdk.common.SetCookieVar;
import com.cognos.pogo.pdk.common.SetCookieVars;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import com.cognos.pogo.pdk.stax.StaxBodyFault;
import com.cognos.pogo.pdk.stax.StaxEnvelope;
import com.cognos.pogo.pdk.stax.StaxEnvelopeFactory;
import com.ibm.cognos.bux.buxservice.BUXServiceBaseHandler;
import com.ibm.cognos.bux.buxservice.stax.BUXRequestBodyHandler;
import com.ibm.cognos.bux.buxservice.stax.BUXResponseBodyHandler;
import com.ibm.cognos.bux.buxservice.stax.BiBusRequestImpl;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusContext;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequest;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestContextParameters;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestCookie;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusResponseBase;
import java.util.List;
import utils.BUXUtils;

public class BUXServiceHandler
extends BUXServiceBaseHandler
implements BodyHandlerFactory {
    public BodyHandler createBodyHandler() {
        return new BUXRequestBodyHandler();
    }

    @Override
    protected Envelope createResponse(MessageContext mc) {
        BIBusEnvelope requestEnvelope = this.getRequestEnvelope(mc);
        return this.createStaxResponse(requestEnvelope);
    }

    @Override
    protected BiBusRequest getBiBusRequestImpl(MessageContext mc) {
        BiBusRequestImpl request = new BiBusRequestImpl(mc, this.getGlobalConfig().getGatewayURL(), this.getProductLocale(mc), this.getContentLocale(mc));
        request.setCurrentUserRole(this.getCurrentUserRole(this.getRequestEnvelope(mc)));
        return request;
    }

    @Override
    protected BiBusRequest.BiBusUserRole getCurrentUserRole(BIBusEnvelope requestEnvelope) {
        BiBusRequest.BiBusUserRole userRole = BiBusRequest.BiBusUserRole.CONSUME;
        UserCapabilityCache cache = requestEnvelope.getBiBusHeader().getUserCapabilityCache();
        userRole = cache.hasItem("canUseAdvancedDashboardFeatures") ? BiBusRequest.BiBusUserRole.ASSEMBLE : (cache.hasItem("canUseInteractiveDashboardFeatures") ? BiBusRequest.BiBusUserRole.INTERACT : BiBusRequest.BiBusUserRole.CONSUME);
        return userRole;
    }

    @Override
    protected boolean hasCapability(BIBusEnvelope envelope) {
        return envelope.getBiBusHeader().getUserCapabilityCache().hasItem("canUseDashboardViewer");
    }

    @Override
    protected void processCookies(BiBusResponseBase response, Envelope envelope) {
        List cookies = response.getCookies();
        if (cookies != null) {
            SetCookieVars setCookieVars = envelope.getBiBusHeader().getHdrSession().getSetCookieVars();
            for (BiBusRequestCookie cookie : cookies) {
                setCookieVars.setSetCookie(cookie.getName(), cookie.getValue(), Integer.valueOf(cookie.getMaxAge()));
                SetCookieVar scv = setCookieVars.getSetCookie(cookie.getName());
                scv.setDomain(cookie.getDomain());
                scv.setPath(cookie.getPath());
                if (scv.getOptionalSecure() != null || !this.isCookieSecure()) continue;
                scv.setSecure(true);
            }
        }
    }

    @Override
    protected BiBusContext getBiBusContext(BIBusEnvelope envelope) {
        BiBusRequestContextParameters details = new BiBusRequestContextParameters();
        details.setRequestID(envelope.getRequestContext());
        details.setSessionID(envelope.getSessionContext());
        return new BiBusContext(details);
    }

    private Envelope createStaxResponse(BIBusEnvelope requestEnvelope) {
        BUXResponseBodyHandler responseBodyHandler = new BUXResponseBodyHandler();
        StaxEnvelope response = StaxEnvelopeFactory.createStaxEnvelope((BodyHandler)responseBodyHandler);
        requestEnvelope.copyBiBusHeaderTo((Envelope)response);
        return response;
    }

    @Override
    protected BIBusEnvelope createBusFaultResponseEnvelope(BIBusEnvelope requestEnvelope, String faultCodeText, String msgCode, String msgDetail, Throwable exceptionObj) {
        if (null == requestEnvelope) {
            return null;
        }
        BUXResponseBodyHandler responseBodyHandler = new BUXResponseBodyHandler();
        StaxEnvelope responseEnvelope = StaxEnvelopeFactory.createStaxEnvelope((BodyHandler)responseBodyHandler);
        requestEnvelope.copyBiBusHeaderTo((Envelope)responseEnvelope);
        StaxBodyFault bodyFault = new StaxBodyFault();
        bodyFault.setFaultCode(faultCodeText);
        bodyFault.setFaultString(msgDetail);
        BodyFaultException bfex = bodyFault.getDetail().createAndAddException();
        bfex.setErrorCode(msgCode);
        BodyFaultMessage msg = bfex.createAndAddMessage();
        msg.setNestingLevel(Integer.valueOf(1));
        msg.setMessageString(msgDetail);
        if (exceptionObj != null) {
            msg = bfex.createAndAddMessage();
            msg.setNestingLevel(Integer.valueOf(1));
            msg.setMessageString(BUXUtils.stringifyThrowable(exceptionObj));
        }
        responseEnvelope.setBodyFault((BodyFault)bodyFault);
        return responseEnvelope;
    }
}

