/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.buxservice.stax;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.common.CookieVars;
import com.cognos.pogo.pdk.stax.StaxBiBusHeader;
import com.ibm.cognos.bux.buxservice.BUXServiceMessage;
import com.ibm.cognos.bux.buxservice.BiBusBaseRequest;
import com.ibm.cognos.bux.buxservice.logging.IPFTraceLoggerFactory;
import com.ibm.cognos.bux.buxservice.stax.BiBusHeaderXMLStreamWriter;
import com.ibm.cognos.bux.buxservice.stax.DOMXMLStreamWriter;
import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestCookie;
import com.ibm.cognos.bux.osgibridge.delegate.Logger;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class BiBusRequestImpl
extends BiBusBaseRequest {
    public BiBusRequestImpl(MessageContext mc, String gatewayURL, Locale productLocale, Locale contentLocale) {
        super(mc, gatewayURL, productLocale, contentLocale);
    }

    @Override
    protected void populateCookies(MessageContext mc) {
        ArrayList<BiBusRequestCookie> cookies = new ArrayList<BiBusRequestCookie>(10);
        this.setCookies(cookies);
        BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("request.envelope");
        CookieVars cookieVars = envelope.getBiBusHeader().getHdrSession().getCookieVars();
        for (String name : cookieVars.getNames()) {
            BiBusRequestCookie cookie = new BiBusRequestCookie(name, cookieVars.getValue(name));
            cookies.add(cookie);
        }
    }

    @Override
    protected Element getBiBusDomHeader(BIBusEnvelope envelope) {
        try {
            StaxBiBusHeader header = (StaxBiBusHeader)envelope.getBiBusHeader();
            DOMXMLStreamWriter xsw = new DOMXMLStreamWriter();
            header.writeXML((XMLStreamWriter)xsw);
            return xsw.toElement();
        }
        catch (Exception e) {
            String message = BUXServiceMessage.getInstance().getMessage(this.getProductLocale(), "bux.error.GetBiBusHeaderFailed");
            Logger logger = IPFTraceLoggerFactory.getInstance().getLogger(BiBusRequestImpl.class.getName());
            logger.error(BiBusRequestImpl.class.getName(), message, (Throwable)e, null);
            return null;
        }
    }

    @Override
    public BIBusEnvelope createDom4jEnvelopeCopy() {
        BIBusEnvelope ret = new BIBusEnvelope();
        ret.setBIBusHeader(this.getBiBusDom4jHeader(this.getRequestEnvelope()));
        return ret;
    }

    private org.dom4j.Element getBiBusDom4jHeader(BIBusEnvelope envelope) {
        try {
            StaxBiBusHeader header = (StaxBiBusHeader)envelope.getBiBusHeader();
            BiBusHeaderXMLStreamWriter xsw = new BiBusHeaderXMLStreamWriter();
            header.writeXML((XMLStreamWriter)xsw);
            return xsw.toElement();
        }
        catch (Exception e) {
            String message = BUXServiceMessage.getInstance().getMessage(this.getProductLocale(), "bux.error.GetBiBusDom4jHeaderFailed");
            Logger logger = IPFTraceLoggerFactory.getInstance().getLogger(BiBusRequestImpl.class.getName());
            logger.error(BiBusRequestImpl.class.getName(), message, (Throwable)e, null);
            return null;
        }
    }
}

