/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.lc;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.bux.lc.DiscoveryClient;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ServiceConfig {
    public static final String SERVICE_DISCOVERY_URI = "collaborationDiscoveryURI";
    private static final String CFG_PARAMETER_NAME_PREFIX = "lc_";
    private static final String CFG_PARAMETER_NAME_POSTFIX = "_uri";
    private static final String DISC_DOC_ENTRY = "entry";
    private static final String DISC_DOC_FEATURE_ID = "id";
    private static final String DISC_DOC_FEATURE_ID_PREFIX = "urn:lsid:ibm.com:config:";
    private static final String DISC_DOC_LINK = "link";
    private static final String DISC_DOC_HREF = "href";
    private static final String DISC_DOC_REL = "rel";
    private static final String DISC_DOC_REL_HTTPS = "http://www.ibm.com/xmlns/prod/sn/alternate-ssl";
    private static final String DISC_DOC_REL_HTTP = "alternate";
    private static final String CFG_INIT_QUERY_RESULT = "queryResult";
    private static final String CFG_INIT_ITEM = "item";
    private static final String CFG_INIT_VALUE = "value";
    private static PogoLogger cat = PogoLogger.getLogger();
    private String m_uri = "";
    private Element m_discoveryDoc;
    private final DiscoveryClient m_discoveryClient;
    private static final String LC_SEVERCFG_FEED_GENERATOR_ELE_NAME = "generator";
    private static final String LC_SEVERCFG_FEED_VERSION_ELE_NAME = "version";
    private static final String LC_SEVERCFG_DEFAULT_VERSION = "0";

    public ServiceConfig() {
        this(new DiscoveryClient());
    }

    public ServiceConfig(DiscoveryClient discoveryClient) {
        this.m_discoveryClient = discoveryClient;
    }

    public String getURI() {
        return this.m_uri;
    }

    public void update(Configuration configuration) {
        if (configuration == null) {
            return;
        }
        String newURI = configuration.getValue(SERVICE_DISCOVERY_URI);
        if (this.uriHasChanged(newURI)) {
            Element tmpDiscoveryDoc;
            Element newDiscoveryDoc = this.fetchDiscoveryDoc(newURI);
            if (this.m_discoveryDoc == null && newDiscoveryDoc == null) {
                return;
            }
            boolean bResetConfig = this.m_discoveryDoc != null && newDiscoveryDoc == null;
            Element element = tmpDiscoveryDoc = bResetConfig ? this.m_discoveryDoc : newDiscoveryDoc;
            if (!this.updateICCLConfig(configuration, bResetConfig, tmpDiscoveryDoc)) {
                return;
            }
            this.m_uri = newURI;
            this.m_discoveryDoc = newDiscoveryDoc;
        }
    }

    private boolean updateICCLConfig(Configuration configuration, boolean bResetConfig, Element tmpDiscoveryDoc) {
        try {
            configuration.getICCLConfiguration().init(ServiceConfig.createConfigInitElem(tmpDiscoveryDoc, bResetConfig));
        }
        catch (CCLConfigurationException e) {
            cat.error("Unable to update the configuration object.", (Throwable)e);
            return false;
        }
        return true;
    }

    private Element fetchDiscoveryDoc(String uri) {
        Element discoveryDoc = null;
        if (uri == null || uri.length() == 0) {
            cat.debug(new Object[]{"URI is null or empty."});
        } else {
            try {
                String response = this.m_discoveryClient.get(uri);
                Document doc = DocumentHelper.parseText((String)response);
                discoveryDoc = doc.getRootElement();
            }
            catch (DocumentException e) {
                cat.debug("Unable to parse the discovery doc from " + uri, (Throwable)e);
            }
            catch (NullPointerException e) {
                cat.debug("Unable to parse the discovery doc from " + uri, (Throwable)e);
            }
        }
        return discoveryDoc;
    }

    private boolean uriHasChanged(String sNewURI) {
        String sNormalizedURI;
        String string = sNormalizedURI = sNewURI == null ? "" : sNewURI;
        return !sNormalizedURI.equals(this.m_uri);
    }

    private static Element createConfigInitElem(Element discoveryDoc, boolean bResetConfig) {
        Element cfgInitElement = DocumentHelper.createElement((String)CFG_INIT_QUERY_RESULT);
        Element itemElement = cfgInitElement.addElement(CFG_INIT_ITEM);
        ServiceConfig.addItemVersionElement(itemElement, discoveryDoc);
        Iterator it = discoveryDoc.elementIterator(DISC_DOC_ENTRY);
        while (it.hasNext()) {
            int endIdx;
            Element entryElem = (Element)it.next();
            String sId = entryElem.elementText(DISC_DOC_FEATURE_ID);
            int idx = sId.indexOf(DISC_DOC_FEATURE_ID_PREFIX);
            if (idx == -1 || (endIdx = sId.indexOf(":", idx + DISC_DOC_FEATURE_ID_PREFIX.length())) == -1) continue;
            String sFeature = sId.substring(idx + DISC_DOC_FEATURE_ID_PREFIX.length(), endIdx);
            String sName = CFG_PARAMETER_NAME_PREFIX + sFeature + CFG_PARAMETER_NAME_POSTFIX;
            String sValue = "";
            if (bResetConfig) {
                cat.debug(new Object[]{"Resetting the configuration for ", sName});
            } else {
                Element link = (Element)entryElem.selectSingleNode("*[local-name()='link'][@rel='alternate']");
                if (link != null) {
                    sValue = link.attributeValue(DISC_DOC_HREF, "");
                } else {
                    link = (Element)entryElem.selectSingleNode("*[local-name()='link'][@rel='http://www.ibm.com/xmlns/prod/sn/alternate-ssl']");
                    if (link != null) {
                        sValue = link.attributeValue(DISC_DOC_HREF, "");
                    }
                }
            }
            ServiceConfig.addItemChildElement(itemElement, sName, sValue);
        }
        return cfgInitElement;
    }

    private static void addItemVersionElement(Element itemElement, Element feedDoc) {
        String eleName = CFG_PARAMETER_NAME_PREFIX + LC_SEVERCFG_FEED_VERSION_ELE_NAME + CFG_PARAMETER_NAME_POSTFIX;
        ServiceConfig.addItemChildElement(itemElement, eleName, ServiceConfig.getLCServerVersion(feedDoc));
    }

    private static void addItemChildElement(Element itemElement, String eleName, String eleValue) {
        Element nameElement = itemElement.addElement(eleName);
        Element valueElement = nameElement.addElement(CFG_INIT_VALUE);
        valueElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        valueElement.setText(eleValue);
    }

    private static String getLCServerVersion(Element feedDoc) {
        Attribute versionAttr;
        Element ele_generator;
        String version = null;
        if (feedDoc != null && (ele_generator = feedDoc.element(LC_SEVERCFG_FEED_GENERATOR_ELE_NAME)) != null && (versionAttr = ele_generator.attribute(LC_SEVERCFG_FEED_VERSION_ELE_NAME)) != null) {
            version = versionAttr.getText();
        }
        return version != null && version.trim().length() > 0 ? version : LC_SEVERCFG_DEFAULT_VERSION;
    }
}

