/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.bux.osgibridge.delegate;

import com.ibm.cognos.bux.osgibridge.delegate.BiBusRequestHandler;

public class BiBusDelegateParent {
    private static final String[] errorMessages = new String[6];
    private static BiBusDelegateParent instance = null;
    private BiBusRequestHandler delegate;
    private int delegateReferenceCount;

    public static void setErrorMessage(BiBusDelegateErrorMessage err, String message) {
        BiBusDelegateParent.errorMessages[err.ordinal()] = message;
    }

    public static synchronized void setInstance(BiBusDelegateParent delegateParent) {
        if (instance != null && delegateParent != null) {
            throw new IllegalStateException(BiBusDelegateParent.getMessage(BiBusDelegateErrorMessage.DELEGATE_PARENT_INSTANCE_ALREADY_SET));
        }
        instance = delegateParent;
    }

    protected synchronized void releaseDelegateReference() {
        --this.delegateReferenceCount;
        this.notifyAll();
    }

    protected synchronized BiBusRequestHandler acquireDelegateReference() {
        if (this.delegate != null) {
            ++this.delegateReferenceCount;
        }
        return this.delegate;
    }

    public static synchronized boolean isInstanceSet() {
        return null != instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void registerDelegate(BiBusRequestHandler handlerDelegate) {
        if (instance == null) {
            throw new NullPointerException(BiBusDelegateParent.getMessage(BiBusDelegateErrorMessage.DELEGATE_PARENT_INSTANCE_NULL));
        }
        if (handlerDelegate == null) {
            throw new NullPointerException(BiBusDelegateParent.getMessage(BiBusDelegateErrorMessage.CANNOT_REGISTER_A_NULL_HANDLER_DELEGATE));
        }
        BiBusDelegateParent biBusDelegateParent = instance;
        synchronized (biBusDelegateParent) {
            if (BiBusDelegateParent.instance.delegate != null) {
                throw new IllegalStateException(BiBusDelegateParent.getMessage(BiBusDelegateErrorMessage.A_HANDLER_DELEGATE_IS_ALREADY_REGISTERED));
            }
            BiBusDelegateParent.instance.delegate = handlerDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void unregisterDelegate(BiBusRequestHandler handlerDelegate) {
        if (instance == null) {
            return;
        }
        BiBusDelegateParent biBusDelegateParent = instance;
        synchronized (biBusDelegateParent) {
            if (BiBusDelegateParent.instance.delegate == null) {
                throw new IllegalStateException(BiBusDelegateParent.getMessage(BiBusDelegateErrorMessage.NO_HANDLER_DELEGATE_IS_REGISTERED));
            }
            if (BiBusDelegateParent.instance.delegate != handlerDelegate) {
                throw new IllegalStateException(BiBusDelegateParent.getMessage(BiBusDelegateErrorMessage.HANDLER_DELEGATE_DOES_NOT_MATCH_REGISTERED_DELEGATE));
            }
            BiBusRequestHandler oldProxy = BiBusDelegateParent.instance.delegate;
            BiBusDelegateParent.instance.delegate = null;
            while (BiBusDelegateParent.instance.delegateReferenceCount != 0) {
                try {
                    instance.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            oldProxy.destroy();
        }
    }

    private static String getMessage(BiBusDelegateErrorMessage msg) {
        return errorMessages[msg.ordinal()];
    }

    public static enum BiBusDelegateErrorMessage {
        HANDLER_DELEGATE_DOES_NOT_MATCH_REGISTERED_DELEGATE,
        NO_HANDLER_DELEGATE_IS_REGISTERED,
        A_HANDLER_DELEGATE_IS_ALREADY_REGISTERED,
        CANNOT_REGISTER_A_NULL_HANDLER_DELEGATE,
        DELEGATE_PARENT_INSTANCE_NULL,
        DELEGATE_PARENT_INSTANCE_ALREADY_SET;

    }
}

