/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base;

import com.ibm.cognos.fmd.sdk.base.IResponder;
import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.AggregateCubeCommand;
import com.ibm.cognos.fmd.sdk.base.commands.AggregateDimensionCommand;
import com.ibm.cognos.fmd.sdk.base.commands.AggregateHierarchyCommand;
import com.ibm.cognos.fmd.sdk.base.commands.AggregateLevelCommand;
import com.ibm.cognos.fmd.sdk.base.commands.AggregateMeasureCommand;
import com.ibm.cognos.fmd.sdk.base.commands.AuthenticateCommand;
import com.ibm.cognos.fmd.sdk.base.commands.CalculatedMemberCommand;
import com.ibm.cognos.fmd.sdk.base.commands.CubeCommand;
import com.ibm.cognos.fmd.sdk.base.commands.CubeDeployCommand;
import com.ibm.cognos.fmd.sdk.base.commands.CubeRegisterCommand;
import com.ibm.cognos.fmd.sdk.base.commands.CubeStartCommand;
import com.ibm.cognos.fmd.sdk.base.commands.DataSourceCommand;
import com.ibm.cognos.fmd.sdk.base.commands.FolderCommand;
import com.ibm.cognos.fmd.sdk.base.commands.LevelCommand;
import com.ibm.cognos.fmd.sdk.base.commands.MeasureCommand;
import com.ibm.cognos.fmd.sdk.base.commands.MeasureDimensionCommand;
import com.ibm.cognos.fmd.sdk.base.commands.MeasureFolderCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelCloseCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelNewCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelOpenCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelOpenStreamCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelSaveAsCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelSaveCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ModelSaveStreamCommand;
import com.ibm.cognos.fmd.sdk.base.commands.NamedSetCommand;
import com.ibm.cognos.fmd.sdk.base.commands.NamedSetFolderCommand;
import com.ibm.cognos.fmd.sdk.base.commands.NamespaceCommand;
import com.ibm.cognos.fmd.sdk.base.commands.ParameterMapCommand;
import com.ibm.cognos.fmd.sdk.base.commands.PhysicalAssociationCommand;
import com.ibm.cognos.fmd.sdk.base.commands.PhysicalJoinCommand;
import com.ibm.cognos.fmd.sdk.base.commands.PhysicalTableCommand;
import com.ibm.cognos.fmd.sdk.base.commands.QueryItemCommand;
import com.ibm.cognos.fmd.sdk.base.commands.QueryItemMappingCommand;
import com.ibm.cognos.fmd.sdk.base.commands.QueryItemRoleCommand;
import com.ibm.cognos.fmd.sdk.base.commands.RelationalDimensionCommand;
import com.ibm.cognos.fmd.sdk.base.commands.RelationalFilterCommand;
import com.ibm.cognos.fmd.sdk.base.commands.RelationalHierarchyCommand;
import com.ibm.cognos.fmd.sdk.base.commands.RelationalParameterMapCommand;
import com.ibm.cognos.fmd.sdk.base.commands.RelationalQuerySubjectCommand;
import com.ibm.cognos.fmd.sdk.base.commands.RelationshipCommand;
import com.ibm.cognos.fmd.sdk.base.commands.RelativeTimeMemberCommand;
import com.ibm.cognos.fmd.sdk.base.commands.SQLObjectCommand;
import com.ibm.cognos.fmd.sdk.base.commands.SearchCommand;
import com.ibm.cognos.fmd.sdk.base.commands.SecurityFilterCommand;
import com.ibm.cognos.fmd.sdk.base.commands.SecurityViewCommand;
import com.ibm.cognos.fmd.sdk.base.commands.SelftTestCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualCubeCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualDimensionCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualHierarchyCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualLevelCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualMeasureCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualMeasureDimensionCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualMeasureFolderCommand;
import com.ibm.cognos.fmd.sdk.base.commands.VirtualSourceCommand;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class CommandProcessor {
    protected static final String URL_PREFIX = "/FmCommand";
    protected static final String VERSION_ONE = "/v1/";
    protected static final String VERSION_LATEST = "/latest/";
    private static Map<String, IResponder> responders = new HashMap<String, IResponder>();

    static {
        responders.put("aggregate", new AggregateCubeCommand());
        responders.put("aggegate_dimension", new AggregateDimensionCommand());
        responders.put("aggregate_hierarchy", new AggregateHierarchyCommand());
        responders.put("aggregate_level", new AggregateLevelCommand());
        responders.put("aggregate_measure", new AggregateMeasureCommand());
        responders.put("authenticate", new AuthenticateCommand());
        responders.put("calculated_member", new CalculatedMemberCommand());
        responders.put("cube", new CubeCommand());
        responders.put("cube_deploy", new CubeDeployCommand());
        responders.put("cube_register", new CubeRegisterCommand());
        responders.put("cube_start", new CubeStartCommand());
        responders.put("datasource", new DataSourceCommand());
        responders.put("folder", new FolderCommand());
        responders.put("level", new LevelCommand());
        responders.put("measure", new MeasureCommand());
        responders.put("measure_dimension", new MeasureDimensionCommand());
        responders.put("measure_folder", new MeasureFolderCommand());
        responders.put("model", new ModelCommand());
        responders.put("model_close", new ModelCloseCommand());
        responders.put("model_new", new ModelNewCommand());
        responders.put("model_open", new ModelOpenCommand());
        responders.put("model_open_stream", new ModelOpenStreamCommand());
        responders.put("model_save", new ModelSaveCommand());
        responders.put("model_save_as", new ModelSaveAsCommand());
        responders.put("model_save_stream", new ModelSaveStreamCommand());
        responders.put("named_set", new NamedSetCommand());
        responders.put("named_set_folder", new NamedSetFolderCommand());
        responders.put("namespace", new NamespaceCommand());
        responders.put("physical_association", new PhysicalAssociationCommand());
        responders.put("physical_join", new PhysicalJoinCommand());
        responders.put("physical_table", new PhysicalTableCommand());
        responders.put("query_item", new QueryItemCommand());
        responders.put("query_item_mapping", new QueryItemMappingCommand());
        responders.put("query_item_role", new QueryItemRoleCommand());
        responders.put("parameter_map", new ParameterMapCommand());
        responders.put("relational_dimension", new RelationalDimensionCommand());
        responders.put("relational_filter", new RelationalFilterCommand());
        responders.put("relational_hierarchy", new RelationalHierarchyCommand());
        responders.put("relational_query_subject", new RelationalQuerySubjectCommand());
        responders.put("relational_parameter_map", new RelationalParameterMapCommand());
        responders.put("relationship", new RelationshipCommand());
        responders.put("relative_time_member", new RelativeTimeMemberCommand());
        responders.put("search", new SearchCommand());
        responders.put("security_filter", new SecurityFilterCommand());
        responders.put("security_view", new SecurityViewCommand());
        responders.put("sql_object", new SQLObjectCommand());
        responders.put("test", new SelftTestCommand());
        responders.put("virtual_cube", new VirtualCubeCommand());
        responders.put("virtual_dimension", new VirtualDimensionCommand());
        responders.put("virtual_hierarchy", new VirtualHierarchyCommand());
        responders.put("virtual_level", new VirtualLevelCommand());
        responders.put("virtual_measure", new VirtualMeasureCommand());
        responders.put("virtual_measure_dimension", new VirtualMeasureDimensionCommand());
        responders.put("virtual_measure_folder", new VirtualMeasureFolderCommand());
        responders.put("virtual_source", new VirtualSourceCommand());
    }

    public static int process(String urlPath, String action, JSONObject dataIn, JSONObject dataOut) {
        String[] urlSegments;
        if (urlPath.startsWith(URL_PREFIX)) {
            urlPath = urlPath.substring(URL_PREFIX.length());
        }
        int requestedVersion = 0;
        if (urlPath.startsWith(VERSION_ONE)) {
            urlPath = urlPath.substring(VERSION_ONE.length());
            requestedVersion = 1;
        } else if (urlPath.startsWith(VERSION_LATEST)) {
            urlPath = urlPath.substring(VERSION_LATEST.length());
            requestedVersion = 1;
        }
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        if (urlPath.endsWith("/")) {
            urlPath = urlPath.substring(0, urlPath.length() - 1);
        }
        if ((urlSegments = urlPath.split("/")).length == 0) {
            JSONUtils.addError(dataOut, "Requested URL missing method name.");
            return 0;
        }
        IResponder responder = responders.get(urlSegments[0]);
        if (responder != null) {
            if ("POST".equalsIgnoreCase(action)) {
                return responder.processPost(urlPath, dataIn, dataOut, requestedVersion);
            }
            if ("GET".equalsIgnoreCase(action)) {
                return responder.processGet(urlPath, dataIn, dataOut, requestedVersion);
            }
            if ("PUT".equalsIgnoreCase(action)) {
                return responder.processPut(urlPath, dataIn, dataOut, requestedVersion);
            }
            if ("DELETE".equalsIgnoreCase(action)) {
                return responder.processDelete(urlPath, dataIn, dataOut, requestedVersion);
            }
        }
        JSONUtils.addError(dataOut, "Unknown method requested: " + urlSegments[1]);
        return 0;
    }
}

