/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.BaseObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmAggregateHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmAggregateLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.json.java.JSONObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateLevelCommand
extends BaseObjectCommand {
    protected static final String PROP_LEVEL = "level";
    protected static final String PROP_HIERARCHY = "hierarchy";

    @Override
    protected Class<?> expectedObjectType() {
        return FmAggregateLevel.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmAggregateHierarchy parent = this.getTypedParent(parentObject, FmAggregateHierarchy.class, dataOut);
        if (parent == null) {
            return null;
        }
        BaseObject ref = this.getRefProperty(PROP_LEVEL, modelObj, true, BaseObject.class, dataOut);
        LevelReference foundLevelReference = null;
        if (ref instanceof Level) {
            FmRelationalHierarchy relationalHierarchy = this.getRefProperty(PROP_HIERARCHY, modelObj, true, FmRelationalHierarchy.class, dataOut);
            if (relationalHierarchy == null) {
                return null;
            }
            List levelReferences = relationalHierarchy.getLevelReferences();
            for (LevelReference levelReference : levelReferences) {
                if (!levelReference.getLevel().equals((Object)ref)) continue;
                foundLevelReference = levelReference;
                break;
            }
            if (foundLevelReference == null) {
                return null;
            }
        } else if (ref instanceof LevelReference) {
            foundLevelReference = (LevelReference)ref;
        }
        if (foundLevelReference == null) {
            return null;
        }
        return parent.createLevel(foundLevelReference);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        super.jsonToObject(object, modelObj, version, dataOut);
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmAggregateLevel aggregateLevel = (FmAggregateLevel)object;
        LevelReference ref = aggregateLevel.getLevel();
        this.addRefToJson(result, PROP_LEVEL, ref.getLevel());
        this.addRefToJson(result, PROP_HIERARCHY, ref.getHierarchy());
    }
}

