/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.ReportObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueNameBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeCommand
extends ReportObjectCommand {
    protected static final String PROP_REMOVE_TUPLES = "removeNonExistentTuples";
    protected static final String PROP_STYLE = "style";
    protected static final String PROP_AGGREGATE_ORDINAL = "aggregateOrdinal";
    protected static final String PROP_MEASURE_DIMENSION = "measureDimension";
    protected static final String PROP_ACCESS_RULES = "accessRules";
    protected static final String PROP_RELATIONSHIPS = "relationships";
    protected static final String PROP_DIMENSIONS = "dimensions";
    protected static final String PROP_SLICES = "slices";
    protected static final String PROP_NAMED_SET_FOLDERS = "namedSetFolders";
    protected static final String PROP_NAMED_SETS = "namedSets";
    protected static final String PROP_AGGREGATES_DB = "inDatabaseAggregates";
    protected static final String PROP_AGREGATES_MEMORY = "inMemoryAggregates";

    @Override
    protected Class<?> expectedObjectType() {
        return FmCube.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        BaseObject parent = this.getTypedParent(parentObject, BaseObject.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        Object sName = modelObj.get((Object)"name");
        String defaultName = this.getDefaultName(sName, session);
        Object property = modelObj.remove((Object)PROP_STYLE);
        if (property != null && property instanceof String) {
            if ("regular".equals(property) && parentObject instanceof Section) {
                FmSection section = (FmSection)parentObject;
                return section.createCube(defaultName);
            }
            if ("aggregate".equals(property) && parentObject instanceof Cube) {
                Cube parentCube = (Cube)parentObject;
                return parentCube.createAggregateCube(defaultName);
            }
            if ("virtual".equals(property) && parentObject instanceof Section) {
                FmSection section = (FmSection)parentObject;
                return section.createVirtualCube(defaultName);
            }
            JSONUtils.addError(dataOut, "Unknown cube style or invalid cube parent for the style");
        } else if (parentObject instanceof Section) {
            FmSection section = (FmSection)parentObject;
            return section.createCube(defaultName);
        }
        JSONUtils.addError(dataOut, "Invalid cube parent");
        return null;
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        JSONArray jsonSlices;
        String ordinal;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmCube cube = (FmCube)object;
        Boolean removeTuples = this.getBooleanProperty(PROP_REMOVE_TUPLES, modelObj, null, false, dataOut);
        if (removeTuples != null) {
            cube.setRemoveNonExistentTuples(removeTuples.booleanValue());
        }
        if ((ordinal = this.getStringProperty(PROP_AGGREGATE_ORDINAL, modelObj, false, dataOut)) != null) {
            cube.setAggregateOrdinal(ordinal);
        }
        if ((jsonSlices = this.getJsonProperty(PROP_SLICES, modelObj, false, JSONArray.class, dataOut)) != null) {
            List currentSlices = cube.getSlices();
            if (currentSlices != null) {
                for (MemberUniqueName currentSlice : currentSlices) {
                    cube.removeSlice(currentSlice);
                }
            }
            int i = 0;
            while (i < jsonSlices.size()) {
                MemberUniqueNameBuilder slice = this.getMUNfromJSON((JSONObject)jsonSlices.get(i), dataOut);
                cube.addSlice(slice);
                ++i;
            }
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmCube cube = (FmCube)object;
        this.addObjectToJson(result, PROP_REMOVE_TUPLES, cube.isRemoveNonExistentTuples());
        this.addObjectToJson(result, PROP_STYLE, cube.getCubeStyle());
        this.addObjectToJson(result, PROP_AGGREGATE_ORDINAL, cube.getAggregateOrdinal());
        this.addRefToJson(result, PROP_MEASURE_DIMENSION, cube.getMeasureDimension());
        this.addRefListToJson(result, PROP_ACCESS_RULES, cube.getAccessRules());
        this.addRefListToJson(result, PROP_RELATIONSHIPS, cube.getAllRelationships());
        this.addRefListToJson(result, PROP_DIMENSIONS, cube.getAllDimensions());
        this.addRefListToJson(result, PROP_NAMED_SET_FOLDERS, cube.getNamedSetFolders());
        this.addRefListToJson(result, PROP_NAMED_SETS, cube.getNamedSets());
        this.addRefListToJson(result, PROP_AGGREGATES_DB, cube.getAggregateCubes());
        this.addRefListToJson(result, PROP_AGREGATES_MEMORY, cube.getAggregateCubes2());
        List slices = cube.getSlices();
        if (slices != null && !slices.isEmpty()) {
            FMMDSession session = cube.getSession();
            JSONArray jsonSlices = new JSONArray();
            for (MemberUniqueName slice : slices) {
                JSONObject jsonSlice = this.getJSONfromMUN(session, (FmMemberUniqueName)slice, dataOut);
                jsonSlices.add((Object)jsonSlice);
            }
            result.put((Object)PROP_SLICES, (Object)jsonSlices);
        }
    }
}

