/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.ActionCommand;
import com.ibm.cognos.fmeng.fmmd.impl.task.ModelPublisher;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.PackageBase;
import com.ibm.cognos.fmeng.fmmd.model.PseudoPackage;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.TaskExportToCognosROLAP;
import com.ibm.cognos.fmeng.fmmd.model.TaskROLAPtoDMR;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CubeDeployCommand
extends ActionCommand {
    protected static final String PROP_CUBE = "cube";
    protected static final String PROP_PACKAGE_NAME = "packageName";
    protected static final String PROP_REFRESH_DATA_SOURCES = "refreshDataSources";
    protected static final String PROP_CM_PATH = "contentManagerModelPath";

    protected Object action(String url, JSONObject modelObj, JSONObject dataOut) {
        CubeBase cube = this.getRefProperty(PROP_CUBE, modelObj, true, CubeBase.class, dataOut);
        if (cube == null) {
            return null;
        }
        FMMDSession fmSession = cube.getSession();
        if (fmSession == null) {
            return null;
        }
        String cmPath = this.getStringProperty(PROP_CM_PATH, modelObj, dataOut);
        String packageName = this.getStringProperty(PROP_PACKAGE_NAME, modelObj, dataOut);
        boolean refreshDataSources = this.getBooleanProperty(PROP_REFRESH_DATA_SOURCES, modelObj, Boolean.FALSE, false, dataOut);
        if (cube == null || cmPath == null || packageName == null) {
            return null;
        }
        PseudoPackage pkg = new PseudoPackage((ReportObject)cube, packageName, cmPath);
        if (refreshDataSources) {
            List dataSources = fmSession.getProject().getDataSources();
            for (DataSource dataSource : dataSources) {
                String cmDsName = dataSource.getName();
                String catalog = dataSource.getCatalogName();
                String schema = dataSource.getSchemaName();
                fmSession.refreshMetadataSource(cmDsName, null, null, catalog, schema, false);
            }
        }
        TaskExportToCognosROLAP rolapTask = fmSession.getTaskExportToCognosROLAP();
        ArrayList messages = new ArrayList();
        try {
            rolapTask.checkPackageSanity((PackageBase)pkg, messages, false);
            rolapTask.exportToCognosROLAP((PackageBase)pkg);
        }
        catch (FmMDException e) {
            JSONUtils.addError(dataOut, e.getLocalizedMessage());
        }
        if (!messages.isEmpty()) {
            Locale locale = cube.getSession().getActiveLocale();
            for (FeedbackMessage message : messages) {
                FeedbackMessage.FeedbackSeverity severity = message.getSeverity();
                switch (severity) {
                    case WARNING: {
                        JSONUtils.addWarning(dataOut, message.render(locale));
                        break;
                    }
                    case ERROR: {
                        JSONUtils.addError(dataOut, message.render(locale));
                    }
                }
            }
        }
        FMMDSession tempNewModelSession = FMMDSession.createFMMDSession((FMMDSession)fmSession);
        tempNewModelSession.create(ProjectFactory.createInMemoryProject());
        TaskROLAPtoDMR taskROLAPtoDMR = fmSession.getTaskROLAPtoDMR();
        taskROLAPtoDMR.convertFromPackage((PackageBase)pkg, tempNewModelSession);
        ModelPublisher publisher = new ModelPublisher(tempNewModelSession);
        publisher.publishModelToCM(cmPath, packageName, "model", null);
        return null;
    }
}

