/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.BaseObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceCommand
extends BaseObjectCommand {
    protected static final String PROP_CM_DATA_SOURCE = "cmDataSource";
    protected static final String PROP_CATALOG = "catalog";
    protected static final String PROP_SCHEMA = "schema";
    protected static final String PROP_CUBE = "cube";
    protected static final String PROP_QUERY_TYPE = "queryType";
    protected static final String PROP_QUERY_PROCESSING = "queryProcessing";
    protected static final String PROP_ROLLUP_PROCESSING = "rollupProcessing";
    protected static final String PROP_FUNCTION_SET_ID = "functionSetId";
    protected static final String PROP_INTERFACE = "interface";

    @Override
    protected Class<?> expectedObjectType() {
        return DataSource.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        BaseObject parent = this.getTypedParent(parentObject, BaseObject.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        String name = (String)modelObj.remove((Object)"name");
        return (FmBaseObject)session.getProject().createDataSource(name);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        DataSource.EQueryType queryType;
        DataSource.EQueryProcessing queryProcesing;
        DataSource.ERollupProcessing rollupProcesing;
        String functionSetId;
        String sInterface;
        String cube;
        String schema;
        String catalog;
        super.jsonToObject(object, modelObj, version, dataOut);
        DataSource dataSource = (DataSource)object;
        String cmSource = this.getStringProperty(PROP_CM_DATA_SOURCE, modelObj, false, dataOut);
        if (cmSource != null) {
            dataSource.setCmDataSourceName(cmSource);
        }
        if ((catalog = this.getStringProperty(PROP_CATALOG, modelObj, false, dataOut)) != null) {
            dataSource.setCatalogName(catalog);
        }
        if ((schema = this.getStringProperty(PROP_SCHEMA, modelObj, false, dataOut)) != null) {
            dataSource.setSchemaName(schema);
        }
        if ((cube = this.getStringProperty(PROP_CUBE, modelObj, false, dataOut)) != null) {
            dataSource.setCube(cube);
        }
        if ((sInterface = this.getStringProperty(PROP_INTERFACE, modelObj, false, dataOut)) != null) {
            dataSource.setInterface(sInterface);
        }
        if ((functionSetId = this.getStringProperty(PROP_FUNCTION_SET_ID, modelObj, false, dataOut)) != null) {
            dataSource.setFunctionSetID(functionSetId);
        }
        if ((rollupProcesing = this.getEnumProperty(PROP_ROLLUP_PROCESSING, modelObj, DataSource.ERollupProcessing.class, false, dataOut)) != null) {
            dataSource.setRollupProcessing(rollupProcesing);
        }
        if ((queryProcesing = this.getEnumProperty(PROP_QUERY_PROCESSING, modelObj, DataSource.EQueryProcessing.class, false, dataOut)) != null) {
            dataSource.setQueryProcessing(queryProcesing);
        }
        if ((queryType = this.getEnumProperty(PROP_QUERY_TYPE, modelObj, DataSource.EQueryType.class, false, dataOut)) != null) {
            dataSource.setQueryType(queryType);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        DataSource dataSource = (DataSource)object;
        result.put((Object)"name", (Object)dataSource.getName());
        result.put((Object)PROP_CM_DATA_SOURCE, (Object)dataSource.getCmDataSourceName());
        result.put((Object)PROP_CATALOG, (Object)dataSource.getCatalogName());
        result.put((Object)PROP_SCHEMA, (Object)dataSource.getSchemaName());
        result.put((Object)PROP_CUBE, (Object)dataSource.getCube());
        result.put((Object)PROP_FUNCTION_SET_ID, (Object)dataSource.getFunctionSetID());
        result.put((Object)PROP_INTERFACE, (Object)dataSource.getInterface());
        result.put((Object)PROP_QUERY_TYPE, (Object)dataSource.getQueryType().toString());
        result.put((Object)PROP_QUERY_PROCESSING, (Object)dataSource.getQueryProcessing().toString());
        result.put((Object)PROP_ROLLUP_PROCESSING, (Object)dataSource.getRollupProcessing().toString());
    }
}

