/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.ReportObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.LevelParentInternal;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.LevelStyle;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelCommand
extends ReportObjectCommand {
    protected static final String PROP_LEVEL_TYPE = "levelType";
    protected static final String PROP_IS_UNIQUE = "isUnique";
    protected static final String PROP_CURRENT_PERIOD = "currentPeriod";
    protected static final String PROP_LEVEL_KEY = "levelKeys";

    @Override
    protected Class<?> expectedObjectType() {
        return FmLevel.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        LevelParentInternal parent = this.getTypedParent(parentObject, LevelParentInternal.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        Object sName = modelObj.get((Object)"name");
        String defaultName = this.getDefaultName(sName, session);
        return FmLevel.createLevel((FMMDSession)session, (LevelParentInternal)parent, (String)defaultName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        List<QueryItem> levelKeys;
        ExpressionBuilder expression;
        LevelStyle levelStyle;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmLevel level = (FmLevel)object;
        Boolean isUnique = this.getBooleanProperty(PROP_IS_UNIQUE, modelObj, null, false, dataOut);
        if (isUnique != null) {
            level.setIsUnique(isUnique.booleanValue());
        }
        if ((levelStyle = this.getEnumProperty(PROP_LEVEL_TYPE, modelObj, LevelStyle.class, false, dataOut)) != null) {
            level.setLevelStyle(levelStyle);
        }
        if ((expression = this.jsonToExpression(level.getSession(), PROP_CURRENT_PERIOD, modelObj, dataOut)) != null) {
            level.setCurrentPeriodExpression(expression);
        }
        if ((levelKeys = this.jsonToList(PROP_LEVEL_KEY, modelObj, QueryItem.class, dataOut)) != null) {
            List existingKeys = level.getLevelKeys();
            if (existingKeys != null) {
                for (QueryItem key : level.getLevelKeys()) {
                    level.removeLevelKey(key);
                }
            }
            for (QueryItem key : levelKeys) {
                level.addLevelKey(key);
            }
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmLevel level = (FmLevel)object;
        this.addObjectToJson(result, PROP_IS_UNIQUE, level.getIsUnique());
        this.addObjectToJson(result, PROP_LEVEL_TYPE, level.getLevelStyle());
        Expression exp = level.getCurrentPeriodExpression();
        if (exp != null) {
            JSONArray jsonExpresson = this.expressionToJson(BuilderFactory.createExpressionBuilder((Expression)exp), dataOut);
            result.put((Object)PROP_CURRENT_PERIOD, (Object)jsonExpresson);
        }
        this.addRefListToJson(result, PROP_LEVEL_KEY, level.getLevelKeys());
    }
}

