/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.JSONUtils;
import com.ibm.cognos.fmd.sdk.base.commands.BaseObjectCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapEntry;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMapCommand
extends BaseObjectCommand {
    protected static final String PROP_DEFAULT_VALUE = "defaultValue";
    protected static final String PROP_ENTRIES = "entries";
    protected static final String PROP_ENTRIES_KEY = "key";
    protected static final String PROP_ENTRIES_VALUE = "value";

    @Override
    protected Class<?> expectedObjectType() {
        return FmParameterMap.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmNamespace parent = this.getTypedParent(parentObject, FmNamespace.class, dataOut);
        if (parent == null) {
            return null;
        }
        FMMDSession session = parent.getSession();
        FmProject project = (FmProject)session.getProject();
        String sName = this.getStringProperty("name", modelObj, dataOut);
        return project.createParameterMap(sName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        Object property;
        String defaultValue;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmParameterMap parameterMap = (FmParameterMap)object;
        String name = this.getStringProperty("name", modelObj, false, dataOut);
        if (name != null) {
            parameterMap.setName(name);
        }
        if ((defaultValue = this.getStringProperty(PROP_DEFAULT_VALUE, modelObj, false, dataOut)) != null) {
            parameterMap.setDefaultValue(defaultValue);
        }
        if ((property = modelObj.remove((Object)PROP_ENTRIES)) != null) {
            if (property instanceof JSONArray) {
                List existingEntries = parameterMap.getParameterMapEntries();
                if (!existingEntries.isEmpty()) {
                    ArrayList<String> existingKeys = new ArrayList<String>(existingEntries.size());
                    for (ParameterMapEntry entry : existingEntries) {
                        existingKeys.add(entry.getKey());
                    }
                    parameterMap.removeEntries(existingKeys);
                }
                for (Object entry : (JSONArray)property) {
                    Object key = ((JSONObject)entry).get((Object)PROP_ENTRIES_KEY);
                    if (key == null) {
                        JSONUtils.addError(dataOut, "Missing required key property: " + entry.toString());
                        continue;
                    }
                    if (!(key instanceof String)) {
                        JSONUtils.addError(dataOut, "The key property is expected to be of String type: " + entry.toString());
                        continue;
                    }
                    Object value = ((JSONObject)entry).get((Object)PROP_ENTRIES_VALUE);
                    if (value == null) {
                        JSONUtils.addError(dataOut, "Missing required value property: " + entry.toString());
                        continue;
                    }
                    if (!(value instanceof String)) {
                        JSONUtils.addError(dataOut, "The value property is expected to be of String type: " + entry.toString());
                        continue;
                    }
                    parameterMap.addEntry((String)key, (String)value);
                }
            } else {
                JSONUtils.addError(dataOut, "Expected array for the value of the property entries");
            }
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmParameterMap parameterMap = (FmParameterMap)object;
        this.addObjectToJson(result, "name", parameterMap.getName());
        this.addObjectToJson(result, PROP_DEFAULT_VALUE, parameterMap.getDefaultValue());
        List existingEntries = parameterMap.getParameterMapEntries();
        if (!existingEntries.isEmpty()) {
            JSONArray jsonEntries = new JSONArray();
            for (ParameterMapEntry entry : existingEntries) {
                JSONObject jsonEntry = new JSONObject();
                jsonEntry.put((Object)PROP_ENTRIES_KEY, (Object)entry.getKey());
                jsonEntry.put((Object)PROP_ENTRIES_VALUE, (Object)entry.getValue());
                jsonEntries.add((Object)jsonEntry);
            }
            result.put((Object)PROP_ENTRIES, (Object)jsonEntries);
        }
    }
}

