/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.ResourceCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalJoinCommand
extends ResourceCommand {
    protected static final String PROP_LEFT_TABLE = "leftTable";
    protected static final String PROP_RIGHT_TABLE = "rightTable";
    protected static final String PROP_LEFT_MAX_CARD = "leftMaxCardinality";
    protected static final String PROP_LEFT_MIN_CARD = "leftMinCardinality";
    protected static final String PROP_RIGHT_MAX_CARD = "rightMaxCardinality";
    protected static final String PROP_RIGHT_MIN_CARD = "rightMinCardinality";
    protected static final String PROP_ASSOCIATIONS = "associations";

    @Override
    protected Class<?> expectedObjectType() {
        return FmJoin.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmRelationalObject parent = this.getTypedParent(parentObject, FmRelationalObject.class, dataOut);
        String sName = this.getStringProperty("name", modelObj, dataOut);
        Table leftTable = this.getRefProperty(PROP_LEFT_TABLE, modelObj, true, Table.class, dataOut);
        Table rightTable = this.getRefProperty(PROP_RIGHT_TABLE, modelObj, true, Table.class, dataOut);
        if (parent == null || sName == null || leftTable == null || rightTable == null) {
            return null;
        }
        return parent.getPhysicalDefinition().createJoin(sName, leftTable, rightTable);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        Cardinality.ECardinality rightMinCard;
        Cardinality.ECardinality rightMaxCard;
        Cardinality.ECardinality leftMinCard;
        super.jsonToObject(object, modelObj, version, dataOut);
        FmJoin join = (FmJoin)object;
        Cardinality.ECardinality leftMaxCard = this.getEnumProperty(PROP_LEFT_MAX_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut);
        if (leftMaxCard != null) {
            join.setLeftMaxcard(leftMaxCard);
        }
        if ((leftMinCard = this.getEnumProperty(PROP_LEFT_MIN_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut)) != null) {
            join.setLeftMincard(leftMinCard);
        }
        if ((rightMaxCard = this.getEnumProperty(PROP_RIGHT_MAX_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut)) != null) {
            join.setRightMaxcard(rightMaxCard);
        }
        if ((rightMinCard = this.getEnumProperty(PROP_RIGHT_MIN_CARD, modelObj, Cardinality.ECardinality.class, false, dataOut)) != null) {
            join.setRightMincard(rightMinCard);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmJoin join = (FmJoin)object;
        this.addRefToJson(result, PROP_LEFT_TABLE, join.getLeft());
        this.addRefToJson(result, PROP_RIGHT_TABLE, join.getRight());
        this.addRefToJson(result, PROP_LEFT_MAX_CARD, join.getLeftMaxcard());
        this.addRefToJson(result, PROP_LEFT_MIN_CARD, join.getLeftMincard());
        this.addRefToJson(result, PROP_RIGHT_MAX_CARD, join.getRightMaxcard());
        this.addRefToJson(result, PROP_RIGHT_MIN_CARD, join.getRightMincard());
        this.addRefListToJson(result, PROP_ASSOCIATIONS, join.getAssociations());
    }

    @Override
    protected boolean delete(Object object, JSONObject dataOut) {
        FmJoin join = (FmJoin)object;
        RelationalObject parent = join.getRelationalParent();
        if (parent == null) {
            return false;
        }
        parent.removeJoin((Join)join);
        return true;
    }
}

