/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmd.sdk.base.commands;

import com.ibm.cognos.fmd.sdk.base.commands.ResourceCommand;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.json.java.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalTableCommand
extends ResourceCommand {
    protected static final String PROP_DATASOURCE = "datasource";

    @Override
    protected Class<?> expectedObjectType() {
        return FmTable.class;
    }

    @Override
    protected Object create(Object parentObject, JSONObject modelObj, JSONObject dataOut) {
        FmRelationalObject parent = this.getTypedParent(parentObject, FmRelationalObject.class, dataOut);
        DataSource dsObject = this.getRefProperty(PROP_DATASOURCE, modelObj, true, DataSource.class, dataOut);
        String sName = this.getStringProperty("name", modelObj, dataOut);
        if (dsObject == null || sName == null || parent == null) {
            return null;
        }
        return parent.getPhysicalDefinition().createTable(dsObject, sName);
    }

    @Override
    protected void jsonToObject(Object object, JSONObject modelObj, String version, JSONObject dataOut) {
        super.jsonToObject(object, modelObj, version, dataOut);
        FmTable table = (FmTable)object;
        String name = this.getStringProperty("name", modelObj, false, dataOut);
        if (name != null) {
            table.setName(name);
        }
    }

    @Override
    protected void objectToJson(JSONObject result, Object object, String version, JSONObject dataOut) {
        super.objectToJson(result, object, version, dataOut);
        FmTable table = (FmTable)object;
        this.addObjectToJson(result, "name", table.getName());
        this.addRefToJson(result, PROP_DATASOURCE, table.getDataSource());
    }

    @Override
    protected boolean delete(Object object, JSONObject dataOut) {
        FmTable table = (FmTable)object;
        RelationalObject parent = table.getRelationalParent();
        if (parent == null) {
            return false;
        }
        parent.removeTable((Table)table);
        return true;
    }
}

